/*
 * Decompiled with CFR 0.152.
 */
package com.king.app.updater;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.king.app.updater.UpdateConfig;
import com.king.app.updater.callback.UpdateCallback;
import com.king.app.updater.http.IHttpManager;
import com.king.app.updater.notify.INotification;
import com.king.app.updater.service.DownloadService;
import com.king.app.updater.util.LogUtils;
import com.king.app.updater.util.PermissionUtils;
import java.util.Map;

public class AppUpdater {
    private Context mContext;
    private UpdateConfig mConfig;
    private UpdateCallback mCallback;
    private IHttpManager mHttpManager;
    private INotification mNotification;
    private ServiceConnection mServiceConnection;

    public AppUpdater(@NonNull Context context, @NonNull UpdateConfig config) {
        this.mContext = context;
        this.mConfig = config;
    }

    public AppUpdater(@NonNull Context context, @NonNull String url) {
        this.mContext = context;
        this.mConfig = new UpdateConfig();
        this.mConfig.setUrl(url);
    }

    public AppUpdater setUpdateCallback(@Nullable UpdateCallback callback) {
        this.mCallback = callback;
        return this;
    }

    public AppUpdater setHttpManager(@Nullable IHttpManager httpManager) {
        this.mHttpManager = httpManager;
        return this;
    }

    public AppUpdater setNotification(@Nullable INotification notification) {
        this.mNotification = notification;
        return this;
    }

    public void start() {
        if (this.mConfig != null && !TextUtils.isEmpty((CharSequence)this.mConfig.getUrl())) {
            if (this.mContext instanceof Activity && !TextUtils.isEmpty((CharSequence)this.mConfig.getPath())) {
                PermissionUtils.verifyReadAndWritePermissions((Activity)this.mContext, 102);
            }
            if (this.mConfig.isShowNotification() && !PermissionUtils.isNotificationEnabled(this.mContext)) {
                LogUtils.w("Notification permission is not enabled.");
            }
        } else {
            throw new IllegalArgumentException("Url must not be empty.");
        }
        this.startDownloadService();
    }

    private void startDownloadService() {
        Intent intent = new Intent(this.mContext, DownloadService.class);
        if (this.mCallback != null || this.mHttpManager != null || this.mNotification != null) {
            this.mServiceConnection = new ServiceConnection(){

                public void onServiceConnected(ComponentName name, IBinder service) {
                    DownloadService.DownloadBinder binder = (DownloadService.DownloadBinder)service;
                    if (AppUpdater.this.mNotification != null) {
                        binder.start(AppUpdater.this.mConfig, AppUpdater.this.mHttpManager, AppUpdater.this.mCallback, AppUpdater.this.mNotification);
                    } else {
                        binder.start(AppUpdater.this.mConfig, AppUpdater.this.mHttpManager, AppUpdater.this.mCallback);
                    }
                }

                public void onServiceDisconnected(ComponentName name) {
                }
            };
            this.mContext.getApplicationContext().bindService(intent, this.mServiceConnection, 1);
        } else {
            intent.putExtra("app_update_config", (Parcelable)this.mConfig);
            this.mContext.startService(intent);
        }
    }

    public void stop() {
        this.stopDownloadService();
    }

    private void stopDownloadService() {
        Intent intent = new Intent(this.mContext, DownloadService.class);
        intent.putExtra("stop_download_service", true);
        this.mContext.startService(intent);
    }

    public static class Builder {
        private Context mContext;
        private UpdateConfig mConfig;

        @Deprecated
        public Builder() {
            this.mConfig = new UpdateConfig();
        }

        public Builder(@NonNull Context context) {
            this.setContext(context);
            this.mConfig = new UpdateConfig();
        }

        public Builder setContext(@NonNull Context context) {
            this.mContext = context;
            return this;
        }

        public Builder setUrl(@NonNull String url) {
            this.mConfig.setUrl(url);
            return this;
        }

        @Deprecated
        public Builder setPath(String path) {
            this.mConfig.setPath(path);
            return this;
        }

        public Builder setFilename(String filename) {
            this.mConfig.setFilename(filename);
            return this;
        }

        public Builder setShowNotification(boolean isShowNotification) {
            this.mConfig.setShowNotification(isShowNotification);
            return this;
        }

        public Builder setNotificationId(int notificationId) {
            this.mConfig.setNotificationId(notificationId);
            return this;
        }

        public Builder setChannelId(String channelId) {
            this.mConfig.setChannelId(channelId);
            return this;
        }

        public Builder setChannelName(String channelName) {
            this.mConfig.setChannelName(channelName);
            return this;
        }

        public Builder setNotificationIcon(@DrawableRes int icon) {
            this.mConfig.setNotificationIcon(icon);
            return this;
        }

        public Builder setVibrate(boolean vibrate) {
            this.mConfig.setVibrate(vibrate);
            return this;
        }

        public Builder setSound(boolean sound) {
            this.mConfig.setSound(sound);
            return this;
        }

        public Builder setInstallApk(boolean isInstallApk) {
            this.mConfig.setInstallApk(isInstallApk);
            return this;
        }

        public Builder setAuthority(String authority) {
            this.mConfig.setAuthority(authority);
            return this;
        }

        public Builder setShowPercentage(boolean showPercentage) {
            this.mConfig.setShowPercentage(showPercentage);
            return this;
        }

        public Builder setReDownload(boolean reDownload) {
            this.mConfig.setReDownload(reDownload);
            return this;
        }

        public Builder setReDownloads(int reDownloads) {
            this.mConfig.setReDownloads(reDownloads);
            return this;
        }

        public Builder setVersionCode(long versionCode) {
            this.mConfig.setVersionCode(versionCode);
            return this;
        }

        public Builder setApkMD5(String md5) {
            this.mConfig.setApkMD5(md5);
            return this;
        }

        public Builder addHeader(String key, String value) {
            this.mConfig.addHeader(key, value);
            return this;
        }

        public Builder addHeader(Map<String, String> headers) {
            this.mConfig.addHeader(headers);
            return this;
        }

        public Builder setDeleteCancelFile(boolean deleteCancelFile) {
            this.mConfig.setDeleteCancelFile(deleteCancelFile);
            return this;
        }

        @Deprecated
        public Builder setCancelDownload(boolean cancelDownload) {
            return this.setSupportCancelDownload(cancelDownload);
        }

        public Builder setSupportCancelDownload(boolean supportCancelDownload) {
            this.mConfig.setSupportCancelDownload(supportCancelDownload);
            return this;
        }

        public AppUpdater build() {
            if (this.mContext == null) {
                throw new NullPointerException("Context must not be null.");
            }
            return new AppUpdater(this.mContext, this.mConfig);
        }

        @Deprecated
        public AppUpdater build(@NonNull Context context) {
            return new AppUpdater(context, this.mConfig);
        }
    }
}

