/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.apache.tools.ant.taskdefs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.zip.CRC32;
import shadow.org.apache.tools.ant.BuildException;
import shadow.org.apache.tools.ant.DirectoryScanner;
import shadow.org.apache.tools.ant.taskdefs.MatchingTask;
import shadow.org.apache.tools.ant.types.ArchiveFileSet;
import shadow.org.apache.tools.ant.types.EnumeratedAttribute;
import shadow.org.apache.tools.ant.types.FileSet;
import shadow.org.apache.tools.ant.types.PatternSet;
import shadow.org.apache.tools.ant.types.Resource;
import shadow.org.apache.tools.ant.types.ResourceCollection;
import shadow.org.apache.tools.ant.types.ZipFileSet;
import shadow.org.apache.tools.ant.types.ZipScanner;
import shadow.org.apache.tools.ant.types.resources.ArchiveResource;
import shadow.org.apache.tools.ant.types.resources.FileProvider;
import shadow.org.apache.tools.ant.types.resources.FileResource;
import shadow.org.apache.tools.ant.types.resources.Union;
import shadow.org.apache.tools.ant.types.resources.ZipResource;
import shadow.org.apache.tools.ant.types.resources.selectors.ResourceSelector;
import shadow.org.apache.tools.ant.util.FileNameMapper;
import shadow.org.apache.tools.ant.util.FileUtils;
import shadow.org.apache.tools.ant.util.GlobPatternMapper;
import shadow.org.apache.tools.ant.util.IdentityMapper;
import shadow.org.apache.tools.ant.util.MergingMapper;
import shadow.org.apache.tools.ant.util.ResourceUtils;
import shadow.org.apache.tools.zip.Zip64Mode;
import shadow.org.apache.tools.zip.ZipEntry;
import shadow.org.apache.tools.zip.ZipExtraField;
import shadow.org.apache.tools.zip.ZipFile;
import shadow.org.apache.tools.zip.ZipOutputStream;

public class Zip
extends MatchingTask {
    private static final int BUFFER_SIZE = 8192;
    private static final int ROUNDUP_MILLIS = 1999;
    protected File zipFile;
    private ZipScanner zs;
    private File baseDir;
    protected Hashtable<String, String> entries = new Hashtable();
    private final Vector<FileSet> groupfilesets = new Vector();
    private final Vector<ZipFileSet> filesetsFromGroupfilesets = new Vector();
    protected String duplicate = "add";
    private boolean doCompress = true;
    private boolean doUpdate = false;
    private boolean savedDoUpdate = false;
    private boolean doFilesonly = false;
    protected String archiveType = "zip";
    private static final long EMPTY_CRC = new CRC32().getValue();
    protected String emptyBehavior = "skip";
    private final Vector<ResourceCollection> resources = new Vector();
    protected Hashtable<String, String> addedDirs = new Hashtable();
    private final Vector<String> addedFiles = new Vector();
    private static final ResourceSelector MISSING_SELECTOR = new ResourceSelector(){

        public boolean isSelected(Resource target) {
            return !target.isExists();
        }
    };
    private static final ResourceUtils.ResourceSelectorProvider MISSING_DIR_PROVIDER = new ResourceUtils.ResourceSelectorProvider(){

        public ResourceSelector getTargetSelectorForSource(Resource sr) {
            return MISSING_SELECTOR;
        }
    };
    protected boolean doubleFilePass = false;
    protected boolean skipWriting = false;
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private boolean updatedFile = false;
    private boolean addingNewFiles = false;
    private String encoding;
    private boolean keepCompression = false;
    private boolean roundUp = true;
    private String comment = "";
    private int level = -1;
    private boolean preserve0Permissions = false;
    private boolean useLanguageEncodingFlag = true;
    private UnicodeExtraField createUnicodeExtraFields = UnicodeExtraField.NEVER;
    private boolean fallBackToUTF8 = false;
    private Zip64ModeAttribute zip64Mode = Zip64ModeAttribute.AS_NEEDED;
    private static final ThreadLocal<Boolean> HAVE_NON_FILE_SET_RESOURCES_TO_ADD = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private static final ThreadLocal<ZipExtraField[]> CURRENT_ZIP_EXTRA = new ThreadLocal();

    protected final boolean isFirstPass() {
        return !this.doubleFilePass || this.skipWriting;
    }

    @Deprecated
    public void setZipfile(File zipFile) {
        this.setDestFile(zipFile);
    }

    @Deprecated
    public void setFile(File file) {
        this.setDestFile(file);
    }

    public void setDestFile(File destFile) {
        this.zipFile = destFile;
    }

    public File getDestFile() {
        return this.zipFile;
    }

    public void setBasedir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setCompress(boolean c) {
        this.doCompress = c;
    }

    public boolean isCompress() {
        return this.doCompress;
    }

    public void setFilesonly(boolean f) {
        this.doFilesonly = f;
    }

    public void setUpdate(boolean c) {
        this.doUpdate = c;
        this.savedDoUpdate = c;
    }

    public boolean isInUpdateMode() {
        return this.doUpdate;
    }

    public void addFileset(FileSet set) {
        this.add(set);
    }

    public void addZipfileset(ZipFileSet set) {
        this.add(set);
    }

    public void add(ResourceCollection a) {
        this.resources.add(a);
    }

    public void addZipGroupFileset(FileSet set) {
        this.groupfilesets.addElement(set);
    }

    public void setDuplicate(Duplicate df) {
        this.duplicate = df.getValue();
    }

    public void setWhenempty(WhenEmpty we) {
        this.emptyBehavior = we.getValue();
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setKeepCompression(boolean keep) {
        this.keepCompression = keep;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public void setRoundUp(boolean r) {
        this.roundUp = r;
    }

    public void setPreserve0Permissions(boolean b) {
        this.preserve0Permissions = b;
    }

    public boolean getPreserve0Permissions() {
        return this.preserve0Permissions;
    }

    public void setUseLanguageEncodingFlag(boolean b) {
        this.useLanguageEncodingFlag = b;
    }

    public boolean getUseLanguageEnodingFlag() {
        return this.useLanguageEncodingFlag;
    }

    public void setCreateUnicodeExtraFields(UnicodeExtraField b) {
        this.createUnicodeExtraFields = b;
    }

    public UnicodeExtraField getCreateUnicodeExtraFields() {
        return this.createUnicodeExtraFields;
    }

    public void setFallBackToUTF8(boolean b) {
        this.fallBackToUTF8 = b;
    }

    public boolean getFallBackToUTF8() {
        return this.fallBackToUTF8;
    }

    public void setZip64Mode(Zip64ModeAttribute b) {
        this.zip64Mode = b;
    }

    public Zip64ModeAttribute getZip64Mode() {
        return this.zip64Mode;
    }

    public void execute() throws BuildException {
        if (this.doubleFilePass) {
            this.skipWriting = true;
            this.executeMain();
            this.skipWriting = false;
            this.executeMain();
        } else {
            this.executeMain();
        }
    }

    protected boolean hasUpdatedFile() {
        return this.updatedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeMain() throws BuildException {
        this.checkAttributesAndElements();
        File renamedFile = null;
        this.addingNewFiles = true;
        this.processDoUpdate();
        this.processGroupFilesets();
        Vector<ResourceCollection> vfss = new Vector<ResourceCollection>();
        if (this.baseDir != null) {
            FileSet fs = (FileSet)this.getImplicitFileSet().clone();
            fs.setDir(this.baseDir);
            vfss.addElement(fs);
        }
        int size = this.resources.size();
        for (int i = 0; i < size; ++i) {
            ResourceCollection rc = this.resources.elementAt(i);
            vfss.addElement(rc);
        }
        Object[] fss = new ResourceCollection[vfss.size()];
        vfss.copyInto(fss);
        boolean success = false;
        try {
            String action;
            ArchiveState state = this.getResourcesToAdd((ResourceCollection[])fss, this.zipFile, false);
            if (!state.isOutOfDate()) {
                return;
            }
            File parent = this.zipFile.getParentFile();
            if (!(parent == null || parent.isDirectory() || parent.mkdirs() || parent.isDirectory())) {
                throw new BuildException("Failed to create missing parent directory for " + this.zipFile);
            }
            this.updatedFile = true;
            if (!this.zipFile.exists() && state.isWithoutAnyResources()) {
                this.createEmptyZip(this.zipFile);
                return;
            }
            Resource[][] addThem = state.getResourcesToAdd();
            if (this.doUpdate) {
                renamedFile = this.renameFile();
            }
            String string = action = this.doUpdate ? "Updating " : "Building ";
            if (!this.skipWriting) {
                this.log(action + this.archiveType + ": " + this.zipFile.getAbsolutePath());
            }
            ZipOutputStream zOut = null;
            try {
                if (!this.skipWriting) {
                    zOut = new ZipOutputStream(this.zipFile);
                    zOut.setEncoding(this.encoding);
                    zOut.setUseLanguageEncodingFlag(this.useLanguageEncodingFlag);
                    zOut.setCreateUnicodeExtraFields(this.createUnicodeExtraFields.getPolicy());
                    zOut.setFallbackToUTF8(this.fallBackToUTF8);
                    zOut.setMethod(this.doCompress ? 8 : 0);
                    zOut.setLevel(this.level);
                    zOut.setUseZip64(this.zip64Mode.getMode());
                }
                this.initZipOutputStream(zOut);
                for (int i = 0; i < fss.length; ++i) {
                    if (addThem[i].length == 0) continue;
                    this.addResources((ResourceCollection)fss[i], addThem[i], zOut);
                }
                if (this.doUpdate) {
                    this.addingNewFiles = false;
                    ZipFileSet oldFiles = new ZipFileSet();
                    oldFiles.setProject(this.getProject());
                    oldFiles.setSrc(renamedFile);
                    oldFiles.setDefaultexcludes(false);
                    int addSize = this.addedFiles.size();
                    for (int i = 0; i < addSize; ++i) {
                        PatternSet.NameEntry ne = oldFiles.createExclude();
                        ne.setName(this.addedFiles.elementAt(i));
                    }
                    DirectoryScanner ds = oldFiles.getDirectoryScanner(this.getProject());
                    ((ZipScanner)ds).setEncoding(this.encoding);
                    String[] f = ds.getIncludedFiles();
                    Resource[] r = new Resource[f.length];
                    for (int i = 0; i < f.length; ++i) {
                        r[i] = ds.getResource(f[i]);
                    }
                    if (!this.doFilesonly) {
                        String[] d = ds.getIncludedDirectories();
                        Resource[] dr = new Resource[d.length];
                        for (int i = 0; i < d.length; ++i) {
                            dr[i] = ds.getResource(d[i]);
                        }
                        Resource[] tmp = r;
                        r = new Resource[tmp.length + dr.length];
                        System.arraycopy(dr, 0, r, 0, dr.length);
                        System.arraycopy(tmp, 0, r, dr.length, tmp.length);
                    }
                    this.addResources(oldFiles, r, zOut);
                }
                if (zOut != null) {
                    zOut.setComment(this.comment);
                }
                this.finalizeZipOutputStream(zOut);
                if (this.doUpdate && !renamedFile.delete()) {
                    this.log("Warning: unable to delete temporary file " + renamedFile.getName(), 1);
                }
                success = true;
            }
            catch (Throwable throwable) {
                this.closeZout(zOut, success);
                throw throwable;
            }
            this.closeZout(zOut, success);
        }
        catch (IOException ioe) {
            String msg = "Problem creating " + this.archiveType + ": " + ioe.getMessage();
            if (!(this.doUpdate && renamedFile == null || this.zipFile.delete())) {
                msg = msg + " (and the archive is probably corrupt but I could not delete it)";
            }
            if (this.doUpdate && renamedFile != null) {
                try {
                    FILE_UTILS.rename(renamedFile, this.zipFile);
                }
                catch (IOException e) {
                    msg = msg + " (and I couldn't rename the temporary file " + renamedFile.getName() + " back)";
                }
            }
            throw new BuildException(msg, ioe, this.getLocation());
        }
        finally {
            this.cleanUp();
        }
    }

    private File renameFile() {
        File renamedFile = FILE_UTILS.createTempFile("zip", ".tmp", this.zipFile.getParentFile(), true, false);
        try {
            FILE_UTILS.rename(this.zipFile, renamedFile);
        }
        catch (SecurityException e) {
            throw new BuildException("Not allowed to rename old file (" + this.zipFile.getAbsolutePath() + ") to temporary file");
        }
        catch (IOException e) {
            throw new BuildException("Unable to rename old file (" + this.zipFile.getAbsolutePath() + ") to temporary file");
        }
        return renamedFile;
    }

    private void closeZout(ZipOutputStream zOut, boolean success) throws IOException {
        block3: {
            if (zOut == null) {
                return;
            }
            try {
                zOut.close();
            }
            catch (IOException ex) {
                if (!success) break block3;
                throw ex;
            }
        }
    }

    private void checkAttributesAndElements() {
        if (this.baseDir == null && this.resources.size() == 0 && this.groupfilesets.size() == 0 && "zip".equals(this.archiveType)) {
            throw new BuildException("basedir attribute must be set, or at least one resource collection must be given!");
        }
        if (this.zipFile == null) {
            throw new BuildException("You must specify the " + this.archiveType + " file to create!");
        }
        if (this.zipFile.exists() && !this.zipFile.isFile()) {
            throw new BuildException(this.zipFile + " is not a file.");
        }
        if (this.zipFile.exists() && !this.zipFile.canWrite()) {
            throw new BuildException(this.zipFile + " is read-only.");
        }
    }

    private void processDoUpdate() {
        if (this.doUpdate && !this.zipFile.exists()) {
            this.doUpdate = false;
            this.logWhenWriting("ignoring update attribute as " + this.archiveType + " doesn't exist.", 4);
        }
    }

    private void processGroupFilesets() {
        int size = this.groupfilesets.size();
        for (int i = 0; i < size; ++i) {
            this.logWhenWriting("Processing groupfileset ", 3);
            FileSet fs = this.groupfilesets.elementAt(i);
            DirectoryScanner scanner = fs.getDirectoryScanner(this.getProject());
            String[] files = scanner.getIncludedFiles();
            File basedir = scanner.getBasedir();
            for (int j = 0; j < files.length; ++j) {
                this.logWhenWriting("Adding file " + files[j] + " to fileset", 3);
                ZipFileSet zf = new ZipFileSet();
                zf.setProject(this.getProject());
                zf.setSrc(new File(basedir, files[j]));
                this.add(zf);
                this.filesetsFromGroupfilesets.addElement(zf);
            }
        }
    }

    protected final boolean isAddingNewFiles() {
        return this.addingNewFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addResources(FileSet fileset, Resource[] resources, ZipOutputStream zOut) throws IOException {
        String prefix = "";
        String fullpath = "";
        int dirMode = 16877;
        int fileMode = 33188;
        ArchiveFileSet zfs = null;
        if (fileset instanceof ArchiveFileSet) {
            zfs = (ArchiveFileSet)fileset;
            prefix = zfs.getPrefix(this.getProject());
            fullpath = zfs.getFullpath(this.getProject());
            dirMode = zfs.getDirMode(this.getProject());
            fileMode = zfs.getFileMode(this.getProject());
        }
        if (prefix.length() > 0 && fullpath.length() > 0) {
            throw new BuildException("Both prefix and fullpath attributes must not be set on the same fileset.");
        }
        if (resources.length != 1 && fullpath.length() > 0) {
            throw new BuildException("fullpath attribute may only be specified for filesets that specify a single file.");
        }
        if (prefix.length() > 0) {
            if (!prefix.endsWith("/") && !prefix.endsWith("\\")) {
                prefix = prefix + "/";
            }
            this.addParentDirs(null, prefix, zOut, "", dirMode);
        }
        ZipFile zf = null;
        try {
            boolean dealingWithFiles = false;
            File base = null;
            if (zfs == null || zfs.getSrc(this.getProject()) == null) {
                dealingWithFiles = true;
                base = fileset.getDir(this.getProject());
            } else if (zfs instanceof ZipFileSet) {
                zf = new ZipFile(zfs.getSrc(this.getProject()), this.encoding);
            }
            for (int i = 0; i < resources.length; ++i) {
                String name = null;
                name = fullpath.length() > 0 ? fullpath : resources[i].getName();
                if ("".equals(name = name.replace(File.separatorChar, '/'))) continue;
                if (resources[i].isDirectory()) {
                    if (this.doFilesonly) continue;
                    int thisDirMode = zfs != null && zfs.hasDirModeBeenSet() ? dirMode : this.getUnixMode(resources[i], zf, dirMode);
                    this.addDirectoryResource(resources[i], name, prefix, base, zOut, dirMode, thisDirMode);
                    continue;
                }
                this.addParentDirs(base, name, zOut, prefix, dirMode);
                if (dealingWithFiles) {
                    File f = FILE_UTILS.resolveFile(base, resources[i].getName());
                    this.zipFile(f, zOut, prefix + name, fileMode);
                    continue;
                }
                int thisFileMode = zfs != null && zfs.hasFileModeBeenSet() ? fileMode : this.getUnixMode(resources[i], zf, fileMode);
                this.addResource(resources[i], name, prefix, zOut, thisFileMode, zf, zfs == null ? null : zfs.getSrc(this.getProject()));
            }
        }
        finally {
            if (zf != null) {
                zf.close();
            }
        }
    }

    private void addDirectoryResource(Resource r, String name, String prefix, File base, ZipOutputStream zOut, int defaultDirMode, int thisDirMode) throws IOException {
        int nextToLastSlash;
        if (!name.endsWith("/")) {
            name = name + "/";
        }
        if ((nextToLastSlash = name.lastIndexOf("/", name.length() - 2)) != -1) {
            this.addParentDirs(base, name.substring(0, nextToLastSlash + 1), zOut, prefix, defaultDirMode);
        }
        this.zipDir(r, zOut, prefix + name, thisDirMode, r instanceof ZipResource ? ((ZipResource)r).getExtraFields() : null);
    }

    private int getUnixMode(Resource r, ZipFile zf, int defaultMode) throws IOException {
        int unixMode = defaultMode;
        if (zf != null) {
            ZipEntry ze = zf.getEntry(r.getName());
            unixMode = ze.getUnixMode();
            if (!(unixMode != 0 && unixMode != 16384 || this.preserve0Permissions)) {
                unixMode = defaultMode;
            }
        } else if (r instanceof ArchiveResource) {
            unixMode = ((ArchiveResource)r).getMode();
        }
        return unixMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResource(Resource r, String name, String prefix, ZipOutputStream zOut, int mode, ZipFile zf, File fromArchive) throws IOException {
        if (zf != null) {
            ZipEntry ze = zf.getEntry(r.getName());
            if (ze != null) {
                boolean oldCompress = this.doCompress;
                if (this.keepCompression) {
                    this.doCompress = ze.getMethod() == 8;
                }
                InputStream is = null;
                try {
                    is = zf.getInputStream(ze);
                    this.zipFile(is, zOut, prefix + name, ze.getTime(), fromArchive, mode, ze.getExtraFields(true));
                }
                finally {
                    this.doCompress = oldCompress;
                    FileUtils.close(is);
                }
            }
        } else {
            InputStream is = null;
            try {
                is = r.getInputStream();
                this.zipFile(is, zOut, prefix + name, r.getLastModified(), fromArchive, mode, r instanceof ZipResource ? ((ZipResource)r).getExtraFields() : null);
            }
            finally {
                FileUtils.close(is);
            }
        }
    }

    protected final void addResources(ResourceCollection rc, Resource[] resources, ZipOutputStream zOut) throws IOException {
        if (rc instanceof FileSet) {
            this.addResources((FileSet)rc, resources, zOut);
            return;
        }
        for (int i = 0; i < resources.length; ++i) {
            Resource resource = resources[i];
            String name = resource.getName();
            if (name == null || "".equals(name = name.replace(File.separatorChar, '/')) || resource.isDirectory() && this.doFilesonly) continue;
            File base = null;
            FileProvider fp = resource.as(FileProvider.class);
            if (fp != null) {
                base = ResourceUtils.asFileResource(fp).getBaseDir();
            }
            if (resource.isDirectory()) {
                this.addDirectoryResource(resource, name, "", base, zOut, 16877, 16877);
                continue;
            }
            this.addParentDirs(base, name, zOut, "", 16877);
            if (fp != null) {
                File f = fp.getFile();
                this.zipFile(f, zOut, name, 33188);
                continue;
            }
            this.addResource(resource, name, "", zOut, 33188, null, null);
        }
    }

    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
    }

    protected void finalizeZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
    }

    protected boolean createEmptyZip(File zipFile) throws BuildException {
        if (!this.skipWriting) {
            this.log("Note: creating empty " + this.archiveType + " archive " + zipFile, 2);
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(zipFile);
            byte[] empty = new byte[22];
            empty[0] = 80;
            empty[1] = 75;
            empty[2] = 5;
            empty[3] = 6;
            ((OutputStream)os).write(empty);
        }
        catch (IOException ioe) {
            try {
                throw new BuildException("Could not create empty ZIP archive (" + ioe.getMessage() + ")", ioe, this.getLocation());
            }
            catch (Throwable throwable) {
                FileUtils.close(os);
                throw throwable;
            }
        }
        FileUtils.close(os);
        return true;
    }

    private synchronized ZipScanner getZipScanner() {
        if (this.zs == null) {
            this.zs = new ZipScanner();
            this.zs.setEncoding(this.encoding);
            this.zs.setSrc(this.zipFile);
        }
        return this.zs;
    }

    protected ArchiveState getResourcesToAdd(ResourceCollection[] rcs, File zipFile, boolean needsUpdate) throws BuildException {
        ArrayList<ResourceCollection> filesets = new ArrayList<ResourceCollection>();
        ArrayList<ResourceCollection> rest = new ArrayList<ResourceCollection>();
        for (int i = 0; i < rcs.length; ++i) {
            if (rcs[i] instanceof FileSet) {
                filesets.add(rcs[i]);
                continue;
            }
            rest.add(rcs[i]);
        }
        ResourceCollection[] rc = rest.toArray(new ResourceCollection[rest.size()]);
        ArchiveState as = this.getNonFileSetResourcesToAdd(rc, zipFile, needsUpdate);
        FileSet[] fs = filesets.toArray(new FileSet[filesets.size()]);
        ArchiveState as2 = this.getResourcesToAdd(fs, zipFile, as.isOutOfDate());
        if (!as.isOutOfDate() && as2.isOutOfDate()) {
            as = this.getNonFileSetResourcesToAdd(rc, zipFile, true);
        }
        Resource[][] toAdd = new Resource[rcs.length][];
        int fsIndex = 0;
        int restIndex = 0;
        for (int i = 0; i < rcs.length; ++i) {
            toAdd[i] = rcs[i] instanceof FileSet ? as2.getResourcesToAdd()[fsIndex++] : as.getResourcesToAdd()[restIndex++];
        }
        return new ArchiveState(as2.isOutOfDate(), toAdd);
    }

    protected ArchiveState getResourcesToAdd(FileSet[] filesets, File zipFile, boolean needsUpdate) throws BuildException {
        int i;
        Resource[][] initialResources = this.grabResources(filesets);
        if (Zip.isEmpty(initialResources)) {
            if (Boolean.FALSE.equals(HAVE_NON_FILE_SET_RESOURCES_TO_ADD.get())) {
                if (needsUpdate && this.doUpdate) {
                    return new ArchiveState(true, initialResources);
                }
                if (this.emptyBehavior.equals("skip")) {
                    if (this.doUpdate) {
                        this.logWhenWriting(this.archiveType + " archive " + zipFile + " not updated because no new files were" + " included.", 3);
                    } else {
                        this.logWhenWriting("Warning: skipping " + this.archiveType + " archive " + zipFile + " because no files were included.", 1);
                    }
                } else {
                    if (this.emptyBehavior.equals("fail")) {
                        throw new BuildException("Cannot create " + this.archiveType + " archive " + zipFile + ": no files were included.", this.getLocation());
                    }
                    if (!zipFile.exists()) {
                        needsUpdate = true;
                    }
                }
            }
            return new ArchiveState(needsUpdate, initialResources);
        }
        if (!zipFile.exists()) {
            return new ArchiveState(true, initialResources);
        }
        if (needsUpdate && !this.doUpdate) {
            return new ArchiveState(true, initialResources);
        }
        Resource[][] newerResources = new Resource[filesets.length][];
        for (i = 0; i < filesets.length; ++i) {
            if (this.fileset instanceof ZipFileSet && ((ZipFileSet)this.fileset).getSrc(this.getProject()) != null) continue;
            File base = filesets[i].getDir(this.getProject());
            for (int j = 0; j < initialResources[i].length; ++j) {
                File resourceAsFile = FILE_UTILS.resolveFile(base, initialResources[i][j].getName());
                if (!resourceAsFile.equals(zipFile)) continue;
                throw new BuildException("A zip file cannot include itself", this.getLocation());
            }
        }
        for (i = 0; i < filesets.length; ++i) {
            if (initialResources[i].length == 0) {
                newerResources[i] = new Resource[0];
                continue;
            }
            FileNameMapper myMapper = new IdentityMapper();
            if (filesets[i] instanceof ZipFileSet) {
                ZipFileSet zfs = (ZipFileSet)filesets[i];
                if (zfs.getFullpath(this.getProject()) != null && !zfs.getFullpath(this.getProject()).equals("")) {
                    MergingMapper fm = new MergingMapper();
                    fm.setTo(zfs.getFullpath(this.getProject()));
                    myMapper = fm;
                } else if (zfs.getPrefix(this.getProject()) != null && !zfs.getPrefix(this.getProject()).equals("")) {
                    GlobPatternMapper gm = new GlobPatternMapper();
                    gm.setFrom("*");
                    String prefix = zfs.getPrefix(this.getProject());
                    if (!prefix.endsWith("/") && !prefix.endsWith("\\")) {
                        prefix = prefix + "/";
                    }
                    gm.setTo(prefix + "*");
                    myMapper = gm;
                }
            }
            newerResources[i] = this.selectOutOfDateResources(initialResources[i], myMapper);
            boolean bl = needsUpdate = needsUpdate || newerResources[i].length > 0;
            if (needsUpdate && !this.doUpdate) break;
        }
        if (needsUpdate && !this.doUpdate) {
            return new ArchiveState(true, initialResources);
        }
        return new ArchiveState(needsUpdate, newerResources);
    }

    protected ArchiveState getNonFileSetResourcesToAdd(ResourceCollection[] rcs, File zipFile, boolean needsUpdate) throws BuildException {
        Resource[][] initialResources = this.grabNonFileSetResources(rcs);
        boolean empty = Zip.isEmpty(initialResources);
        HAVE_NON_FILE_SET_RESOURCES_TO_ADD.set(!empty);
        if (empty) {
            return new ArchiveState(needsUpdate, initialResources);
        }
        if (!zipFile.exists()) {
            return new ArchiveState(true, initialResources);
        }
        if (needsUpdate && !this.doUpdate) {
            return new ArchiveState(true, initialResources);
        }
        Resource[][] newerResources = new Resource[rcs.length][];
        for (int i = 0; i < rcs.length; ++i) {
            if (initialResources[i].length == 0) {
                newerResources[i] = new Resource[0];
                continue;
            }
            for (int j = 0; j < initialResources[i].length; ++j) {
                FileProvider fp = initialResources[i][j].as(FileProvider.class);
                if (fp == null || !zipFile.equals(fp.getFile())) continue;
                throw new BuildException("A zip file cannot include itself", this.getLocation());
            }
            newerResources[i] = this.selectOutOfDateResources(initialResources[i], new IdentityMapper());
            boolean bl = needsUpdate = needsUpdate || newerResources[i].length > 0;
            if (needsUpdate && !this.doUpdate) break;
        }
        if (needsUpdate && !this.doUpdate) {
            return new ArchiveState(true, initialResources);
        }
        return new ArchiveState(needsUpdate, newerResources);
    }

    private Resource[] selectOutOfDateResources(Resource[] initial, FileNameMapper mapper) {
        Resource[] rs = this.selectFileResources(initial);
        Resource[] result = ResourceUtils.selectOutOfDateSources(this, rs, mapper, this.getZipScanner());
        if (!this.doFilesonly) {
            Union u = new Union();
            u.addAll(Arrays.asList(this.selectDirectoryResources(initial)));
            ResourceCollection rc = ResourceUtils.selectSources(this, u, mapper, this.getZipScanner(), MISSING_DIR_PROVIDER);
            if (rc.size() > 0) {
                ArrayList<Resource> newer = new ArrayList<Resource>();
                newer.addAll(Arrays.asList(((Union)rc).listResources()));
                newer.addAll(Arrays.asList(result));
                result = newer.toArray(result);
            }
        }
        return result;
    }

    protected Resource[][] grabResources(FileSet[] filesets) {
        Resource[][] result = new Resource[filesets.length][];
        for (int i = 0; i < filesets.length; ++i) {
            int j;
            DirectoryScanner rs;
            boolean skipEmptyNames = true;
            if (filesets[i] instanceof ZipFileSet) {
                ZipFileSet zfs = (ZipFileSet)filesets[i];
                boolean bl = skipEmptyNames = zfs.getPrefix(this.getProject()).equals("") && zfs.getFullpath(this.getProject()).equals("");
            }
            if ((rs = filesets[i].getDirectoryScanner(this.getProject())) instanceof ZipScanner) {
                ((ZipScanner)rs).setEncoding(this.encoding);
            }
            Vector<Resource> resources = new Vector<Resource>();
            if (!this.doFilesonly) {
                String[] directories = rs.getIncludedDirectories();
                for (j = 0; j < directories.length; ++j) {
                    if ("".equals(directories[j]) && skipEmptyNames) continue;
                    resources.addElement(rs.getResource(directories[j]));
                }
            }
            String[] files = rs.getIncludedFiles();
            for (j = 0; j < files.length; ++j) {
                if ("".equals(files[j]) && skipEmptyNames) continue;
                resources.addElement(rs.getResource(files[j]));
            }
            result[i] = new Resource[resources.size()];
            resources.copyInto(result[i]);
        }
        return result;
    }

    protected Resource[][] grabNonFileSetResources(ResourceCollection[] rcs) {
        Resource[][] result = new Resource[rcs.length][];
        for (int i = 0; i < rcs.length; ++i) {
            ArrayList<Resource> dirs = new ArrayList<Resource>();
            ArrayList<Resource> files = new ArrayList<Resource>();
            for (Resource r : rcs[i]) {
                if (!r.isExists()) continue;
                if (r.isDirectory()) {
                    dirs.add(r);
                    continue;
                }
                files.add(r);
            }
            Collections.sort(dirs, new Comparator<Resource>(){

                @Override
                public int compare(Resource r1, Resource r2) {
                    return r1.getName().compareTo(r2.getName());
                }
            });
            ArrayList<Resource> rs = new ArrayList<Resource>(dirs);
            rs.addAll(files);
            result[i] = rs.toArray(new Resource[rs.size()]);
        }
        return result;
    }

    protected void zipDir(File dir, ZipOutputStream zOut, String vPath, int mode) throws IOException {
        this.zipDir(dir, zOut, vPath, mode, null);
    }

    protected void zipDir(File dir, ZipOutputStream zOut, String vPath, int mode, ZipExtraField[] extra) throws IOException {
        this.zipDir(dir == null ? (Resource)null : new FileResource(dir), zOut, vPath, mode, extra);
    }

    protected void zipDir(Resource dir, ZipOutputStream zOut, String vPath, int mode, ZipExtraField[] extra) throws IOException {
        if (this.doFilesonly) {
            this.logWhenWriting("skipping directory " + vPath + " for file-only archive", 3);
            return;
        }
        if (this.addedDirs.get(vPath) != null) {
            return;
        }
        this.logWhenWriting("adding directory " + vPath, 3);
        this.addedDirs.put(vPath, vPath);
        if (!this.skipWriting) {
            int millisToAdd;
            ZipEntry ze = new ZipEntry(vPath);
            int n = millisToAdd = this.roundUp ? 1999 : 0;
            if (dir != null && dir.isExists()) {
                ze.setTime(dir.getLastModified() + (long)millisToAdd);
            } else {
                ze.setTime(System.currentTimeMillis() + (long)millisToAdd);
            }
            ze.setSize(0L);
            ze.setMethod(0);
            ze.setCrc(EMPTY_CRC);
            ze.setUnixMode(mode);
            if (extra != null) {
                ze.setExtraFields(extra);
            }
            zOut.putNextEntry(ze);
        }
    }

    protected final ZipExtraField[] getCurrentExtraFields() {
        return CURRENT_ZIP_EXTRA.get();
    }

    protected final void setCurrentExtraFields(ZipExtraField[] extra) {
        CURRENT_ZIP_EXTRA.set(extra);
    }

    protected void zipFile(InputStream in, ZipOutputStream zOut, String vPath, long lastModified, File fromArchive, int mode) throws IOException {
        if (this.entries.containsKey(vPath)) {
            if (this.duplicate.equals("preserve")) {
                this.logWhenWriting(vPath + " already added, skipping", 2);
                return;
            }
            if (this.duplicate.equals("fail")) {
                throw new BuildException("Duplicate file " + vPath + " was found and the duplicate " + "attribute is 'fail'.");
            }
            this.logWhenWriting("duplicate file " + vPath + " found, adding.", 3);
        } else {
            this.logWhenWriting("adding entry " + vPath, 3);
        }
        this.entries.put(vPath, vPath);
        if (!this.skipWriting) {
            ZipEntry ze = new ZipEntry(vPath);
            ze.setTime(lastModified);
            ze.setMethod(this.doCompress ? 8 : 0);
            if (!zOut.isSeekable() && !this.doCompress) {
                long size = 0L;
                CRC32 cal = new CRC32();
                if (!in.markSupported()) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[8192];
                    int count = 0;
                    do {
                        size += (long)count;
                        cal.update(buffer, 0, count);
                        bos.write(buffer, 0, count);
                    } while ((count = in.read(buffer, 0, buffer.length)) != -1);
                    in = new ByteArrayInputStream(bos.toByteArray());
                } else {
                    in.mark(Integer.MAX_VALUE);
                    byte[] buffer = new byte[8192];
                    int count = 0;
                    do {
                        size += (long)count;
                        cal.update(buffer, 0, count);
                    } while ((count = in.read(buffer, 0, buffer.length)) != -1);
                    in.reset();
                }
                ze.setSize(size);
                ze.setCrc(cal.getValue());
            }
            ze.setUnixMode(mode);
            ZipExtraField[] extra = this.getCurrentExtraFields();
            if (extra != null) {
                ze.setExtraFields(extra);
            }
            zOut.putNextEntry(ze);
            byte[] buffer = new byte[8192];
            int count = 0;
            do {
                if (count == 0) continue;
                zOut.write(buffer, 0, count);
            } while ((count = in.read(buffer, 0, buffer.length)) != -1);
        }
        this.addedFiles.addElement(vPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zipFile(InputStream in, ZipOutputStream zOut, String vPath, long lastModified, File fromArchive, int mode, ZipExtraField[] extra) throws IOException {
        try {
            this.setCurrentExtraFields(extra);
            this.zipFile(in, zOut, vPath, lastModified, fromArchive, mode);
        }
        finally {
            this.setCurrentExtraFields(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zipFile(File file, ZipOutputStream zOut, String vPath, int mode) throws IOException {
        if (file.equals(this.zipFile)) {
            throw new BuildException("A zip file cannot include itself", this.getLocation());
        }
        FileInputStream fIn = new FileInputStream(file);
        try {
            this.zipFile(fIn, zOut, vPath, file.lastModified() + (long)(this.roundUp ? 1999 : 0), null, mode);
        }
        finally {
            fIn.close();
        }
    }

    protected final void addParentDirs(File baseDir, String entry, ZipOutputStream zOut, String prefix, int dirMode) throws IOException {
        if (!this.doFilesonly) {
            String dir;
            Stack<String> directories = new Stack<String>();
            int slashPos = entry.length();
            while ((slashPos = entry.lastIndexOf(47, slashPos - 1)) != -1) {
                dir = entry.substring(0, slashPos + 1);
                if (this.addedDirs.get(prefix + dir) != null) break;
                directories.push(dir);
            }
            while (!directories.isEmpty()) {
                dir = (String)directories.pop();
                File f = null;
                f = baseDir != null ? new File(baseDir, dir) : new File(dir);
                this.zipDir(f, zOut, prefix + dir, dirMode);
            }
        }
    }

    protected void cleanUp() {
        this.addedDirs.clear();
        this.addedFiles.removeAllElements();
        this.entries.clear();
        this.addingNewFiles = false;
        this.doUpdate = this.savedDoUpdate;
        Enumeration<ZipFileSet> e = this.filesetsFromGroupfilesets.elements();
        while (e.hasMoreElements()) {
            ZipFileSet zf = e.nextElement();
            this.resources.removeElement(zf);
        }
        this.filesetsFromGroupfilesets.removeAllElements();
        HAVE_NON_FILE_SET_RESOURCES_TO_ADD.set(Boolean.FALSE);
    }

    public void reset() {
        this.resources.removeAllElements();
        this.zipFile = null;
        this.baseDir = null;
        this.groupfilesets.removeAllElements();
        this.duplicate = "add";
        this.archiveType = "zip";
        this.doCompress = true;
        this.emptyBehavior = "skip";
        this.doUpdate = false;
        this.doFilesonly = false;
        this.encoding = null;
    }

    protected static final boolean isEmpty(Resource[][] r) {
        for (int i = 0; i < r.length; ++i) {
            if (r[i].length <= 0) continue;
            return false;
        }
        return true;
    }

    protected Resource[] selectFileResources(Resource[] orig) {
        return this.selectResources(orig, new ResourceSelector(){

            public boolean isSelected(Resource r) {
                if (!r.isDirectory()) {
                    return true;
                }
                if (Zip.this.doFilesonly) {
                    Zip.this.logWhenWriting("Ignoring directory " + r.getName() + " as only files will" + " be added.", 3);
                }
                return false;
            }
        });
    }

    protected Resource[] selectDirectoryResources(Resource[] orig) {
        return this.selectResources(orig, new ResourceSelector(){

            public boolean isSelected(Resource r) {
                return r.isDirectory();
            }
        });
    }

    protected Resource[] selectResources(Resource[] orig, ResourceSelector selector) {
        if (orig.length == 0) {
            return orig;
        }
        ArrayList<Resource> v = new ArrayList<Resource>(orig.length);
        for (int i = 0; i < orig.length; ++i) {
            if (!selector.isSelected(orig[i])) continue;
            v.add(orig[i]);
        }
        if (v.size() != orig.length) {
            return v.toArray(new Resource[v.size()]);
        }
        return orig;
    }

    protected void logWhenWriting(String msg, int level) {
        if (!this.skipWriting) {
            this.log(msg, level);
        }
    }

    public static final class Zip64ModeAttribute
    extends EnumeratedAttribute {
        private static final Map<String, Zip64Mode> MODES = new HashMap<String, Zip64Mode>();
        private static final String NEVER_KEY = "never";
        private static final String ALWAYS_KEY = "always";
        private static final String A_N_KEY = "as-needed";
        public static final Zip64ModeAttribute NEVER;
        public static final Zip64ModeAttribute AS_NEEDED;

        public String[] getValues() {
            return new String[]{NEVER_KEY, ALWAYS_KEY, A_N_KEY};
        }

        private Zip64ModeAttribute(String name) {
            this.setValue(name);
        }

        public Zip64ModeAttribute() {
        }

        public Zip64Mode getMode() {
            return MODES.get(this.getValue());
        }

        static {
            MODES.put(NEVER_KEY, Zip64Mode.Never);
            MODES.put(ALWAYS_KEY, Zip64Mode.Always);
            MODES.put(A_N_KEY, Zip64Mode.AsNeeded);
            NEVER = new Zip64ModeAttribute(NEVER_KEY);
            AS_NEEDED = new Zip64ModeAttribute(A_N_KEY);
        }
    }

    public static final class UnicodeExtraField
    extends EnumeratedAttribute {
        private static final Map<String, ZipOutputStream.UnicodeExtraFieldPolicy> POLICIES = new HashMap<String, ZipOutputStream.UnicodeExtraFieldPolicy>();
        private static final String NEVER_KEY = "never";
        private static final String ALWAYS_KEY = "always";
        private static final String N_E_KEY = "not-encodeable";
        public static final UnicodeExtraField NEVER;

        public String[] getValues() {
            return new String[]{NEVER_KEY, ALWAYS_KEY, N_E_KEY};
        }

        private UnicodeExtraField(String name) {
            this.setValue(name);
        }

        public UnicodeExtraField() {
        }

        public ZipOutputStream.UnicodeExtraFieldPolicy getPolicy() {
            return POLICIES.get(this.getValue());
        }

        static {
            POLICIES.put(NEVER_KEY, ZipOutputStream.UnicodeExtraFieldPolicy.NEVER);
            POLICIES.put(ALWAYS_KEY, ZipOutputStream.UnicodeExtraFieldPolicy.ALWAYS);
            POLICIES.put(N_E_KEY, ZipOutputStream.UnicodeExtraFieldPolicy.NOT_ENCODEABLE);
            NEVER = new UnicodeExtraField(NEVER_KEY);
        }
    }

    public static class ArchiveState {
        private final boolean outOfDate;
        private final Resource[][] resourcesToAdd;

        ArchiveState(boolean state, Resource[][] r) {
            this.outOfDate = state;
            this.resourcesToAdd = r;
        }

        public boolean isOutOfDate() {
            return this.outOfDate;
        }

        public Resource[][] getResourcesToAdd() {
            return this.resourcesToAdd;
        }

        public boolean isWithoutAnyResources() {
            if (this.resourcesToAdd == null) {
                return true;
            }
            for (int counter = 0; counter < this.resourcesToAdd.length; ++counter) {
                if (this.resourcesToAdd[counter] == null || this.resourcesToAdd[counter].length <= 0) continue;
                return false;
            }
            return true;
        }
    }

    public static class Duplicate
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"add", "preserve", "fail"};
        }
    }

    public static class WhenEmpty
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"fail", "skip", "create"};
        }
    }
}

