/*
 * Decompiled with CFR 0.152.
 */
package com.dragonfruit.Parseux;

import java.util.Iterator;
import java.util.StringJoiner;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class ExcelIterator
implements Iterator<String> {
    private Iterator<Sheet> sheets;
    private Iterator<Row> rows;

    public ExcelIterator(XSSFWorkbook workbook) {
        this.sheets = workbook.iterator();
        this.rows = this.sheets.next().iterator();
    }

    @Override
    public boolean hasNext() {
        return this.rows.hasNext();
    }

    @Override
    public String next() {
        Iterator cells = this.rows.next().iterator();
        StringJoiner joiner = new StringJoiner(",");
        while (cells.hasNext()) {
            joiner.add(this.extractCellValue((Cell)cells.next()));
        }
        if (!this.rows.hasNext() && this.sheets.hasNext()) {
            this.rows = this.sheets.next().iterator();
        }
        return joiner.toString();
    }

    private String extractCellValue(Cell cell) {
        switch (cell.getCellTypeEnum()) {
            case STRING: {
                return cell.getStringCellValue();
            }
            case NUMERIC: {
                return String.valueOf(cell.getNumericCellValue());
            }
        }
        throw new IllegalStateException(String.format("No string conversion defined for sheet %s, cell %s with type %s", cell.getSheet().getSheetName(), cell.getAddress().formatAsString(), cell.getCellTypeEnum().toString()));
    }
}

