/*
 * Decompiled with CFR 0.152.
 */
package com.dragonfruit.Parseux;

import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class CsvAsDTO<T> {
    private final Stream<String> streams;
    private final Class<T> dtoClass;
    private final ObjectReader reader;

    public CsvAsDTO(Stream<String> streams, Class<T> dtoClass) {
        this.streams = streams;
        this.dtoClass = dtoClass;
        this.reader = new CsvMapper().readerWithSchemaFor(this.dtoClass).with((FormatFeature)CsvParser.Feature.FAIL_ON_MISSING_COLUMNS).without((FormatFeature)CsvParser.Feature.ALLOW_TRAILING_COMMA);
    }

    public CsvAsDTO(Iterator<String> iterator, Class<T> dtoClass) {
        this(StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false), dtoClass);
    }

    public CsvAsDTO(BufferedReader bufferedReader, Class<T> dtoClass) {
        this(bufferedReader.lines(), dtoClass);
    }

    public CsvAsDTO(InputStreamReader inputStreamReader, Class<T> dtoClass) {
        this(new BufferedReader(inputStreamReader), dtoClass);
    }

    public CsvAsDTO(ByteArrayInputStream byteArrayInputStream, Class<T> dtoClass) {
        this(new InputStreamReader(byteArrayInputStream), dtoClass);
    }

    public CsvAsDTO(byte[] bytes, Class<T> dtoClass) {
        this(new ByteArrayInputStream(bytes), dtoClass);
    }

    public final List<T> asDTOs() {
        try (Stream<String> stream = this.streams;){
            List list = stream.map(this::castToDTO).collect(Collectors.toList());
            return list;
        }
    }

    private T castToDTO(String csvStr) {
        try {
            return this.dtoClass.cast(this.reader.readValue(csvStr));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

