/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.util;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import java.lang.ref.WeakReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class WeakHandler {
    private final Handler.Callback mCallback;
    private final ExecHandler mExec;
    private Lock mLock = new ReentrantLock();
    @VisibleForTesting
    final ChainedRef mRunnables = new ChainedRef(this.mLock, null);

    public WeakHandler() {
        this.mCallback = null;
        this.mExec = new ExecHandler(this);
    }

    public WeakHandler(@Nullable Handler.Callback callback) {
        this.mCallback = callback;
        this.mExec = new ExecHandler(this);
    }

    public WeakHandler(@NonNull Looper looper) {
        this.mCallback = null;
        this.mExec = new ExecHandler(this, looper);
    }

    public WeakHandler(@NonNull Looper looper, @NonNull Handler.Callback callback) {
        this.mCallback = callback;
        this.mExec = new ExecHandler(this, looper);
    }

    public final boolean post(@NonNull Runnable r) {
        return this.mExec.post(this.wrapRunnable(r));
    }

    public final boolean postAtTime(@NonNull Runnable r, long uptimeMillis) {
        return this.mExec.postAtTime(this.wrapRunnable(r), uptimeMillis);
    }

    public final boolean postAtTime(Runnable r, Object token, long uptimeMillis) {
        return this.mExec.postAtTime(this.wrapRunnable(r), token, uptimeMillis);
    }

    public final boolean postDelayed(Runnable r, long delayMillis) {
        return this.mExec.postDelayed(this.wrapRunnable(r), delayMillis);
    }

    public final boolean postAtFrontOfQueue(Runnable r) {
        return this.mExec.postAtFrontOfQueue(this.wrapRunnable(r));
    }

    public final void removeCallbacks(Runnable r) {
        WeakRunnable runnable = this.mRunnables.remove(r);
        if (runnable != null) {
            this.mExec.removeCallbacks(runnable);
        }
    }

    public final void removeCallbacks(Runnable r, Object token) {
        WeakRunnable runnable = this.mRunnables.remove(r);
        if (runnable != null) {
            this.mExec.removeCallbacks(runnable, token);
        }
    }

    public final boolean sendMessage(Message msg) {
        return this.mExec.sendMessage(msg);
    }

    public final boolean sendEmptyMessage(int what) {
        return this.mExec.sendEmptyMessage(what);
    }

    public final boolean sendEmptyMessageDelayed(int what, long delayMillis) {
        return this.mExec.sendEmptyMessageDelayed(what, delayMillis);
    }

    public final boolean sendEmptyMessageAtTime(int what, long uptimeMillis) {
        return this.mExec.sendEmptyMessageAtTime(what, uptimeMillis);
    }

    public final boolean sendMessageDelayed(Message msg, long delayMillis) {
        return this.mExec.sendMessageDelayed(msg, delayMillis);
    }

    public boolean sendMessageAtTime(Message msg, long uptimeMillis) {
        return this.mExec.sendMessageAtTime(msg, uptimeMillis);
    }

    public final boolean sendMessageAtFrontOfQueue(Message msg) {
        return this.mExec.sendMessageAtFrontOfQueue(msg);
    }

    public final void removeMessages(int what) {
        this.mExec.removeMessages(what);
    }

    public final void removeMessages(int what, Object object) {
        this.mExec.removeMessages(what, object);
    }

    public final void removeCallbacksAndMessages(Object token) {
        this.mExec.removeCallbacksAndMessages(token);
    }

    public final boolean hasMessages(int what) {
        return this.mExec.hasMessages(what);
    }

    public final boolean hasMessages(int what, Object object) {
        return this.mExec.hasMessages(what, object);
    }

    public final Message obtainMessage() {
        return this.mExec.obtainMessage();
    }

    public final Message obtainMessage(int what) {
        return this.mExec.obtainMessage(what);
    }

    public final Message obtainMessage(int what, Object obj) {
        return this.mExec.obtainMessage(what, obj);
    }

    public final Message obtainMessage(int what, int arg1, int arg2) {
        return this.mExec.obtainMessage(what, arg1, arg2);
    }

    public final Message obtainMessage(int what, int arg1, int arg2, Object obj) {
        return this.mExec.obtainMessage(what, arg1, arg2, obj);
    }

    public final Looper getLooper() {
        return this.mExec.getLooper();
    }

    private WeakRunnable wrapRunnable(@NonNull Runnable r) {
        if (r == null) {
            throw new NullPointerException("Runnable can't be null");
        }
        ChainedRef hardRef = new ChainedRef(this.mLock, r);
        this.mRunnables.insertAfter(hardRef);
        return hardRef.wrapper;
    }

    public void handleMessage(Message msg) {
    }

    private static final class ChainedRef {
        @Nullable
        ChainedRef next;
        @Nullable
        ChainedRef prev;
        @NonNull
        final Runnable runnable;
        @NonNull
        final WeakRunnable wrapper;
        @NonNull
        Lock lock;

        public ChainedRef(@NonNull Lock lock, @NonNull Runnable r) {
            this.runnable = r;
            this.lock = lock;
            this.wrapper = new WeakRunnable(new WeakReference<Runnable>(r), new WeakReference<ChainedRef>(this));
        }

        public WeakRunnable remove() {
            this.lock.lock();
            try {
                if (this.prev != null) {
                    this.prev.next = this.next;
                }
                if (this.next != null) {
                    this.next.prev = this.prev;
                }
                this.prev = null;
                this.next = null;
            }
            finally {
                this.lock.unlock();
            }
            return this.wrapper;
        }

        public void insertAfter(@NonNull ChainedRef candidate) {
            this.lock.lock();
            try {
                if (this.next != null) {
                    this.next.prev = candidate;
                }
                candidate.next = this.next;
                this.next = candidate;
                candidate.prev = this;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public WeakRunnable remove(Runnable obj) {
            this.lock.lock();
            try {
                ChainedRef curr = this.next;
                while (curr != null) {
                    if (curr.runnable == obj) {
                        WeakRunnable weakRunnable = curr.remove();
                        return weakRunnable;
                    }
                    curr = curr.next;
                }
            }
            finally {
                this.lock.unlock();
            }
            return null;
        }
    }

    private static final class WeakRunnable
    implements Runnable {
        private final WeakReference<Runnable> mDelegate;
        private final WeakReference<ChainedRef> mReference;

        WeakRunnable(WeakReference<Runnable> delegate, WeakReference<ChainedRef> reference) {
            this.mDelegate = delegate;
            this.mReference = reference;
        }

        @Override
        public void run() {
            Runnable delegate = (Runnable)this.mDelegate.get();
            ChainedRef reference = (ChainedRef)this.mReference.get();
            if (reference != null) {
                reference.remove();
            }
            if (delegate != null) {
                delegate.run();
            }
        }
    }

    private static class ExecHandler
    extends Handler {
        private final WeakReference<WeakHandler> mBase;

        ExecHandler(WeakHandler base) {
            this.mBase = new WeakReference<WeakHandler>(base);
        }

        ExecHandler(WeakHandler base, Looper looper) {
            super(looper);
            this.mBase = new WeakReference<WeakHandler>(base);
        }

        public void handleMessage(@NonNull Message msg) {
            WeakHandler base = (WeakHandler)this.mBase.get();
            if (base != null) {
                if (base.mCallback != null) {
                    base.mCallback.handleMessage(msg);
                } else {
                    base.handleMessage(msg);
                }
            }
        }
    }
}

