/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.ItemDecoration;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.github.jdsjlzx.recyclerview.LRecyclerViewAdapter;

public class DividerDecoration
extends RecyclerView.ItemDecoration {
    private int mHeight;
    private int mLPadding;
    private int mRPadding;
    private Paint mPaint;

    private DividerDecoration(int height, int lPadding, int rPadding, int colour) {
        this.mHeight = height;
        this.mLPadding = lPadding;
        this.mRPadding = rPadding;
        this.mPaint = new Paint();
        this.mPaint.setColor(colour);
    }

    public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
        RecyclerView.Adapter adapter = parent.getAdapter();
        if (!(adapter instanceof LRecyclerViewAdapter)) {
            throw new RuntimeException("the adapter must be LRecyclerViewAdapter");
        }
        LRecyclerViewAdapter lRecyclerViewAdapter = (LRecyclerViewAdapter)adapter;
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = parent.getChildAt(i);
            int top = child.getBottom();
            int bottom = top + this.mHeight;
            int left = child.getLeft() + this.mLPadding;
            int right = child.getRight() - this.mRPadding;
            int position = parent.getChildAdapterPosition(child);
            c.save();
            if (lRecyclerViewAdapter.isRefreshHeader(position) || lRecyclerViewAdapter.isHeader(position) || lRecyclerViewAdapter.isFooter(position)) {
                c.drawRect(0.0f, 0.0f, 0.0f, 0.0f, this.mPaint);
            } else {
                c.drawRect((float)left, (float)top, (float)right, (float)bottom, this.mPaint);
            }
            c.restore();
        }
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        RecyclerView.Adapter adapter = parent.getAdapter();
        if (!(adapter instanceof LRecyclerViewAdapter)) {
            throw new RuntimeException("the adapter must be LRecyclerViewAdapter");
        }
        LRecyclerViewAdapter lRecyclerViewAdapter = (LRecyclerViewAdapter)adapter;
        int position = parent.getChildAdapterPosition(view);
        if (lRecyclerViewAdapter.isRefreshHeader(position) || lRecyclerViewAdapter.isHeader(position) || lRecyclerViewAdapter.isFooter(position)) {
            outRect.bottom = this.mHeight;
            outRect.set(0, 0, 0, 0);
        } else {
            outRect.set(0, 0, 0, this.mHeight);
        }
    }

    public static class Builder {
        private Context mContext;
        private Resources mResources;
        private int mHeight;
        private int mLPadding;
        private int mRPadding;
        private int mColour;

        public Builder(Context context) {
            this.mContext = context;
            this.mResources = context.getResources();
            this.mHeight = (int)TypedValue.applyDimension((int)0, (float)1.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
            this.mLPadding = 0;
            this.mRPadding = 0;
            this.mColour = -16777216;
        }

        public Builder setHeight(float pixels) {
            this.mHeight = (int)TypedValue.applyDimension((int)0, (float)pixels, (DisplayMetrics)this.mResources.getDisplayMetrics());
            return this;
        }

        public Builder setHeight(@DimenRes int resource) {
            this.mHeight = this.mResources.getDimensionPixelSize(resource);
            return this;
        }

        public Builder setPadding(float pixels) {
            this.setLeftPadding(pixels);
            this.setRightPadding(pixels);
            return this;
        }

        public Builder setPadding(@DimenRes int resource) {
            this.setLeftPadding(resource);
            this.setRightPadding(resource);
            return this;
        }

        public Builder setLeftPadding(float pixelPadding) {
            this.mLPadding = (int)TypedValue.applyDimension((int)0, (float)pixelPadding, (DisplayMetrics)this.mResources.getDisplayMetrics());
            return this;
        }

        public Builder setRightPadding(float pixelPadding) {
            this.mRPadding = (int)TypedValue.applyDimension((int)0, (float)pixelPadding, (DisplayMetrics)this.mResources.getDisplayMetrics());
            return this;
        }

        public Builder setLeftPadding(@DimenRes int resource) {
            this.mLPadding = this.mResources.getDimensionPixelSize(resource);
            return this;
        }

        public Builder setRightPadding(@DimenRes int resource) {
            this.mRPadding = this.mResources.getDimensionPixelSize(resource);
            return this;
        }

        public Builder setColorResource(@ColorRes int resource) {
            this.setColor(ContextCompat.getColor((Context)this.mContext, (int)resource));
            return this;
        }

        public Builder setColor(@ColorInt int color) {
            this.mColour = color;
            return this;
        }

        public DividerDecoration build() {
            return new DividerDecoration(this.mHeight, this.mLPadding, this.mRPadding, this.mColour);
        }
    }
}

