/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.recyclerview;

import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;
import android.view.ViewGroup;
import com.github.jdsjlzx.interfaces.OnItemClickListener;
import com.github.jdsjlzx.interfaces.OnItemLongClickListener;
import java.util.ArrayList;
import java.util.List;

public class LuRecyclerViewAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int TYPE_NORMAL = 0;
    private static final int TYPE_FOOTER_VIEW = 10001;
    private static final int HEADER_INIT_INDEX = 10002;
    private List<Integer> mHeaderTypes = new ArrayList<Integer>();
    private OnItemClickListener mOnItemClickListener;
    private OnItemLongClickListener mOnItemLongClickListener;
    private RecyclerView.Adapter mInnerAdapter;
    private ArrayList<View> mHeaderViews = new ArrayList();
    private ArrayList<View> mFooterViews = new ArrayList();
    private SpanSizeLookup mSpanSizeLookup;

    public LuRecyclerViewAdapter(RecyclerView.Adapter innerAdapter) {
        this.mInnerAdapter = innerAdapter;
    }

    public RecyclerView.Adapter getInnerAdapter() {
        return this.mInnerAdapter;
    }

    public void addHeaderView(View view) {
        if (view == null) {
            throw new RuntimeException("header is null");
        }
        this.mHeaderTypes.add(10002 + this.mHeaderViews.size());
        this.mHeaderViews.add(view);
    }

    public void addFooterView(View view) {
        if (view == null) {
            throw new RuntimeException("footer is null");
        }
        if (this.getFooterViewsCount() > 0) {
            this.removeFooterView();
        }
        this.mFooterViews.add(view);
    }

    private View getHeaderViewByType(int itemType) {
        if (!this.isHeaderType(itemType)) {
            return null;
        }
        return this.mHeaderViews.get(itemType - 10002);
    }

    private boolean isHeaderType(int itemViewType) {
        return this.mHeaderViews.size() > 0 && this.mHeaderTypes.contains(itemViewType);
    }

    public View getFooterView() {
        return this.getFooterViewsCount() > 0 ? this.mFooterViews.get(0) : null;
    }

    public View getHeaderView() {
        return this.getHeaderViewsCount() > 0 ? this.mHeaderViews.get(0) : null;
    }

    public ArrayList<View> getHeaderViews() {
        return this.mHeaderViews;
    }

    public void removeHeaderView(View view) {
        this.mHeaderViews.remove(view);
        this.notifyDataSetChanged();
    }

    public void removeFooterView() {
        if (this.getFooterViewsCount() > 0) {
            View footerView = this.getFooterView();
            this.mFooterViews.remove(footerView);
            this.notifyDataSetChanged();
        }
    }

    public int getHeaderViewsCount() {
        return this.mHeaderViews.size();
    }

    public int getFooterViewsCount() {
        return this.mFooterViews.size();
    }

    public boolean isHeader(int position) {
        return position >= 0 && position < this.mHeaderViews.size();
    }

    public boolean isFooter(int position) {
        int lastPosition = this.getItemCount() - 1;
        return this.getFooterViewsCount() > 0 && position >= lastPosition;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (this.isHeaderType(viewType)) {
            ViewHolder viewHolder = new ViewHolder(this.getHeaderViewByType(viewType));
            return viewHolder;
        }
        if (viewType == 10001) {
            ViewHolder viewHolder = new ViewHolder(this.mFooterViews.get(0));
            return viewHolder;
        }
        return this.mInnerAdapter.onCreateViewHolder(parent, viewType);
    }

    public void onBindViewHolder(final RecyclerView.ViewHolder holder, int position) {
        int adapterCount;
        if (this.isHeader(position)) {
            return;
        }
        final int adjPosition = position - this.getHeaderViewsCount();
        if (this.mInnerAdapter != null && adjPosition < (adapterCount = this.mInnerAdapter.getItemCount())) {
            this.mInnerAdapter.onBindViewHolder(holder, adjPosition);
            if (this.mOnItemClickListener != null) {
                holder.itemView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        LuRecyclerViewAdapter.this.mOnItemClickListener.onItemClick(holder.itemView, adjPosition);
                    }
                });
            }
            if (this.mOnItemLongClickListener != null) {
                holder.itemView.setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View v) {
                        LuRecyclerViewAdapter.this.mOnItemLongClickListener.onItemLongClick(holder.itemView, adjPosition);
                        return true;
                    }
                });
            }
        }
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position, List<Object> payloads) {
        if (payloads.isEmpty()) {
            this.onBindViewHolder(holder, position);
        } else {
            int adapterCount;
            if (this.isHeader(position)) {
                return;
            }
            int adjPosition = position - this.getHeaderViewsCount();
            if (this.mInnerAdapter != null && adjPosition < (adapterCount = this.mInnerAdapter.getItemCount())) {
                this.mInnerAdapter.onBindViewHolder(holder, adjPosition, payloads);
            }
        }
    }

    public int getItemCount() {
        if (this.mInnerAdapter != null) {
            return this.getHeaderViewsCount() + this.getFooterViewsCount() + this.mInnerAdapter.getItemCount();
        }
        return this.getHeaderViewsCount() + this.getFooterViewsCount();
    }

    public int getItemViewType(int position) {
        int adapterCount;
        int adjPosition = position - this.getHeaderViewsCount();
        if (this.isHeader(position)) {
            return this.mHeaderTypes.get(position);
        }
        if (this.isFooter(position)) {
            return 10001;
        }
        if (this.mInnerAdapter != null && adjPosition < (adapterCount = this.mInnerAdapter.getItemCount())) {
            return this.mInnerAdapter.getItemViewType(adjPosition);
        }
        return 0;
    }

    public long getItemId(int position) {
        int adapterCount;
        int adjPosition;
        if (this.mInnerAdapter != null && position >= this.getHeaderViewsCount() && (adjPosition = position - this.getHeaderViewsCount()) < (adapterCount = this.mInnerAdapter.getItemCount())) {
            return this.mInnerAdapter.getItemId(adjPosition);
        }
        return -1L;
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        RecyclerView.LayoutManager manager = recyclerView.getLayoutManager();
        if (manager instanceof GridLayoutManager) {
            final GridLayoutManager gridManager = (GridLayoutManager)manager;
            gridManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    if (LuRecyclerViewAdapter.this.mSpanSizeLookup == null) {
                        return LuRecyclerViewAdapter.this.isHeader(position) || LuRecyclerViewAdapter.this.isFooter(position) ? gridManager.getSpanCount() : 1;
                    }
                    return LuRecyclerViewAdapter.this.isHeader(position) || LuRecyclerViewAdapter.this.isFooter(position) ? gridManager.getSpanCount() : LuRecyclerViewAdapter.this.mSpanSizeLookup.getSpanSize(gridManager, position - (LuRecyclerViewAdapter.this.getHeaderViewsCount() + 1));
                }
            });
        }
        this.mInnerAdapter.onAttachedToRecyclerView(recyclerView);
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        this.mInnerAdapter.onDetachedFromRecyclerView(recyclerView);
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        super.onViewAttachedToWindow(holder);
        ViewGroup.LayoutParams lp = holder.itemView.getLayoutParams();
        if (lp != null && lp instanceof StaggeredGridLayoutManager.LayoutParams && (this.isHeader(holder.getLayoutPosition()) || this.isFooter(holder.getLayoutPosition()))) {
            StaggeredGridLayoutManager.LayoutParams p = (StaggeredGridLayoutManager.LayoutParams)lp;
            p.setFullSpan(true);
        }
        this.mInnerAdapter.onViewAttachedToWindow(holder);
    }

    public void onViewDetachedFromWindow(RecyclerView.ViewHolder holder) {
        this.mInnerAdapter.onViewDetachedFromWindow(holder);
    }

    public void onViewRecycled(RecyclerView.ViewHolder holder) {
        this.mInnerAdapter.onViewRecycled(holder);
    }

    public int getAdapterPosition(boolean isCallback, int position) {
        if (isCallback) {
            int adapterCount;
            int adjPosition = position - this.getHeaderViewsCount();
            if (adjPosition < (adapterCount = this.mInnerAdapter.getItemCount())) {
                return adjPosition;
            }
        } else {
            return position + this.getHeaderViewsCount();
        }
        return -1;
    }

    public void setOnItemClickListener(OnItemClickListener mOnItemClickListener) {
        this.mOnItemClickListener = mOnItemClickListener;
    }

    public void setOnItemLongClickListener(OnItemLongClickListener itemLongClickListener) {
        this.mOnItemLongClickListener = itemLongClickListener;
    }

    public void setSpanSizeLookup(SpanSizeLookup spanSizeLookup) {
        this.mSpanSizeLookup = spanSizeLookup;
    }

    public static interface SpanSizeLookup {
        public int getSpanSize(GridLayoutManager var1, int var2);
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        public ViewHolder(View itemView) {
            super(itemView);
        }
    }
}

