/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.recyclerview;

import android.content.Context;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.github.jdsjlzx.interfaces.ILoadMoreFooter;
import com.github.jdsjlzx.interfaces.IRefreshHeader;
import com.github.jdsjlzx.interfaces.OnLoadMoreListener;
import com.github.jdsjlzx.interfaces.OnNetWorkErrorListener;
import com.github.jdsjlzx.interfaces.OnRefreshListener;
import com.github.jdsjlzx.recyclerview.AppBarStateChangeListener;
import com.github.jdsjlzx.recyclerview.LRecyclerViewAdapter;
import com.github.jdsjlzx.view.ArrowRefreshHeader;
import com.github.jdsjlzx.view.LoadingFooter;

public class LRecyclerView
extends RecyclerView {
    private boolean mPullRefreshEnabled = true;
    private boolean mLoadMoreEnabled = true;
    private boolean mRefreshing = false;
    private boolean mLoadingData = false;
    private OnRefreshListener mRefreshListener;
    private OnLoadMoreListener mLoadMoreListener;
    private LScrollListener mLScrollListener;
    private IRefreshHeader mRefreshHeader;
    private ILoadMoreFooter mLoadMoreFooter;
    private View mEmptyView;
    private View mFootView;
    private final RecyclerView.AdapterDataObserver mDataObserver = new DataObserver();
    private int mActivePointerId;
    private float mLastY = -1.0f;
    private float sumOffSet;
    private static final float DRAG_RATE = 2.0f;
    private int mPageSize = 10;
    private LRecyclerViewAdapter mWrapAdapter;
    private boolean isNoMore = false;
    private boolean mIsVpDragger;
    private int mTouchSlop;
    private float startY;
    private float startX;
    private boolean isRegisterDataObserver;
    protected LayoutManagerType layoutManagerType;
    private int[] lastPositions;
    private int lastVisibleItemPosition;
    private int currentScrollState = 0;
    private static final int HIDE_THRESHOLD = 20;
    private int mDistance = 0;
    private boolean mIsScrollDown = true;
    private int mScrolledYDistance = 0;
    private int mScrolledXDistance = 0;
    private AppBarStateChangeListener.State appbarState = AppBarStateChangeListener.State.EXPANDED;

    public LRecyclerView(Context context) {
        this(context, null);
    }

    public LRecyclerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LRecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.mTouchSlop = ViewConfiguration.get((Context)this.getContext().getApplicationContext()).getScaledTouchSlop();
        if (this.mPullRefreshEnabled) {
            this.setRefreshHeader(new ArrowRefreshHeader(this.getContext().getApplicationContext()));
        }
        if (this.mLoadMoreEnabled) {
            this.setLoadMoreFooter(new LoadingFooter(this.getContext().getApplicationContext()), false);
        }
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        if (this.mWrapAdapter != null && this.mDataObserver != null && this.isRegisterDataObserver) {
            this.mWrapAdapter.getInnerAdapter().unregisterAdapterDataObserver(this.mDataObserver);
        }
        this.mWrapAdapter = (LRecyclerViewAdapter)adapter;
        super.setAdapter((RecyclerView.Adapter)this.mWrapAdapter);
        this.mWrapAdapter.getInnerAdapter().registerAdapterDataObserver(this.mDataObserver);
        this.mDataObserver.onChanged();
        this.isRegisterDataObserver = true;
        this.mWrapAdapter.setRefreshHeader(this.mRefreshHeader);
        if (this.mLoadMoreEnabled && this.mWrapAdapter.getFooterViewsCount() == 0) {
            this.mWrapAdapter.addFooterView(this.mFootView);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mWrapAdapter != null && this.mDataObserver != null && this.isRegisterDataObserver) {
            this.mWrapAdapter.getInnerAdapter().unregisterAdapterDataObserver(this.mDataObserver);
            this.isRegisterDataObserver = false;
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        switch (action) {
            case 0: {
                this.startY = ev.getY();
                this.startX = ev.getX();
                this.mIsVpDragger = false;
                break;
            }
            case 2: {
                if (this.mIsVpDragger) {
                    return false;
                }
                float endY = ev.getY();
                float endX = ev.getX();
                float distanceX = Math.abs(endX - this.startX);
                float distanceY = Math.abs(endY - this.startY);
                if (!(distanceX > (float)this.mTouchSlop) || !(distanceX > distanceY)) break;
                this.mIsVpDragger = true;
                return false;
            }
            case 1: 
            case 3: {
                this.mIsVpDragger = false;
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mLastY == -1.0f) {
            this.mLastY = ev.getY();
            this.mActivePointerId = ev.getPointerId(0);
            this.sumOffSet = 0.0f;
        }
        switch (ev.getActionMasked()) {
            case 0: {
                this.mLastY = ev.getY();
                this.mActivePointerId = ev.getPointerId(0);
                this.sumOffSet = 0.0f;
                break;
            }
            case 5: {
                int index = ev.getActionIndex();
                this.mActivePointerId = ev.getPointerId(index);
                this.mLastY = (int)ev.getY(index);
                break;
            }
            case 2: {
                int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
                if (pointerIndex == -1) {
                    pointerIndex = 0;
                    this.mActivePointerId = ev.getPointerId(pointerIndex);
                }
                int moveY = (int)ev.getY(pointerIndex);
                float deltaY = ((float)moveY - this.mLastY) / 2.0f;
                this.mLastY = moveY;
                this.sumOffSet += deltaY;
                if (!this.isOnTop() || !this.mPullRefreshEnabled || this.mRefreshing || this.appbarState != AppBarStateChangeListener.State.EXPANDED) break;
                if (this.mRefreshHeader.getType() == 0) {
                    this.mRefreshHeader.onMove(deltaY, this.sumOffSet);
                    break;
                }
                if (this.mRefreshHeader.getType() != 1 || !(deltaY > 0.0f && !this.canScrollVertically(-1)) && (!(deltaY < 0.0f) || this.canScrollVertically(1))) break;
                this.overScrollBy(0, (int)(-deltaY), 0, 0, 0, 0, 0, (int)this.sumOffSet, true);
                break;
            }
            case 1: {
                this.mLastY = -1.0f;
                this.mActivePointerId = -1;
                if (!this.isOnTop() || !this.mPullRefreshEnabled || this.mRefreshing || this.mRefreshHeader == null || !this.mRefreshHeader.onRelease() || this.mRefreshListener == null) break;
                this.mRefreshing = true;
                this.mFootView.setVisibility(8);
                this.mRefreshListener.onRefresh();
            }
        }
        return super.onTouchEvent(ev);
    }

    protected boolean overScrollBy(int deltaX, int deltaY, int scrollX, int scrollY, int scrollRangeX, int scrollRangeY, int maxOverScrollX, int maxOverScrollY, boolean isTouchEvent) {
        if (deltaY != 0 && isTouchEvent) {
            this.mRefreshHeader.onMove(deltaY, this.sumOffSet);
        }
        return super.overScrollBy(deltaX, deltaY, scrollX, scrollY, scrollRangeX, scrollRangeY, maxOverScrollX, maxOverScrollY, isTouchEvent);
    }

    private int findMax(int[] lastPositions) {
        int max = lastPositions[0];
        for (int value : lastPositions) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    public boolean isOnTop() {
        return this.mPullRefreshEnabled && this.mRefreshHeader.getHeaderView().getParent() != null;
    }

    public void setEmptyView(View emptyView) {
        this.mEmptyView = emptyView;
        this.mDataObserver.onChanged();
    }

    public void refreshComplete(int pageSize) {
        this.mPageSize = pageSize;
        if (this.mRefreshing) {
            this.isNoMore = false;
            this.mRefreshing = false;
            this.mRefreshHeader.refreshComplete();
            if (this.mWrapAdapter.getInnerAdapter().getItemCount() < pageSize) {
                this.mFootView.setVisibility(8);
            }
        } else if (this.mLoadingData) {
            this.mLoadingData = false;
            this.mLoadMoreFooter.onComplete();
        }
    }

    public void setNoMore(boolean noMore) {
        this.mLoadingData = false;
        this.isNoMore = noMore;
        if (this.isNoMore) {
            this.mLoadMoreFooter.onNoMore();
        } else {
            this.mLoadMoreFooter.onComplete();
        }
    }

    public void setRefreshHeader(IRefreshHeader refreshHeader) {
        if (this.isRegisterDataObserver) {
            throw new RuntimeException("setRefreshHeader must been invoked before setting the adapter.");
        }
        this.mRefreshHeader = refreshHeader;
    }

    public void setLoadMoreFooter(ILoadMoreFooter loadMoreFooter, boolean isCustom) {
        this.mLoadMoreFooter = loadMoreFooter;
        if (isCustom && null != this.mWrapAdapter && this.mWrapAdapter.getFooterViewsCount() > 0) {
            this.mWrapAdapter.removeFooterView();
        }
        this.mFootView = loadMoreFooter.getFootView();
        this.mFootView.setVisibility(0);
        ViewGroup.LayoutParams layoutParams = this.mFootView.getLayoutParams();
        if (layoutParams != null) {
            this.mFootView.setLayoutParams((ViewGroup.LayoutParams)new RecyclerView.LayoutParams(layoutParams));
        } else {
            this.mFootView.setLayoutParams((ViewGroup.LayoutParams)new RecyclerView.LayoutParams(-1, -2));
        }
        if (isCustom && this.mLoadMoreEnabled && this.mWrapAdapter.getFooterViewsCount() == 0) {
            this.mWrapAdapter.addFooterView(this.mFootView);
        }
    }

    public void setPullRefreshEnabled(boolean enabled) {
        this.mPullRefreshEnabled = enabled;
    }

    public void setLoadMoreEnabled(boolean enabled) {
        if (this.mWrapAdapter == null) {
            throw new NullPointerException("LRecyclerViewAdapter cannot be null, please make sure the variable mWrapAdapter have been initialized.");
        }
        this.mLoadMoreEnabled = enabled;
        if (!enabled) {
            if (null != this.mWrapAdapter) {
                this.mWrapAdapter.removeFooterView();
            } else {
                this.mLoadMoreFooter.onReset();
            }
        }
    }

    public void setRefreshProgressStyle(int style2) {
        if (this.mRefreshHeader != null && this.mRefreshHeader instanceof ArrowRefreshHeader) {
            ((ArrowRefreshHeader)this.mRefreshHeader).setProgressStyle(style2);
        }
    }

    public void setArrowImageView(int resId) {
        if (this.mRefreshHeader != null && this.mRefreshHeader instanceof ArrowRefreshHeader) {
            ((ArrowRefreshHeader)this.mRefreshHeader).setArrowImageView(resId);
        }
    }

    public void setLoadingMoreProgressStyle(int style2) {
        if (this.mLoadMoreFooter != null && this.mLoadMoreFooter instanceof LoadingFooter) {
            ((LoadingFooter)this.mLoadMoreFooter).setProgressStyle(style2);
        }
    }

    public void setOnRefreshListener(OnRefreshListener listener) {
        this.mRefreshListener = listener;
    }

    public void setOnLoadMoreListener(OnLoadMoreListener listener) {
        this.mLoadMoreListener = listener;
    }

    public void setOnNetWorkErrorListener(final OnNetWorkErrorListener listener) {
        LoadingFooter loadingFooter = (LoadingFooter)this.mFootView;
        loadingFooter.setState(LoadingFooter.State.NetWorkError);
        loadingFooter.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LRecyclerView.this.mLoadMoreFooter.onLoading();
                listener.reload();
            }
        });
    }

    public void setFooterViewHint(String loading, String noMore, String noNetWork) {
        if (this.mLoadMoreFooter != null && this.mLoadMoreFooter instanceof LoadingFooter) {
            LoadingFooter loadingFooter = (LoadingFooter)this.mLoadMoreFooter;
            loadingFooter.setLoadingHint(loading);
            loadingFooter.setNoMoreHint(noMore);
            loadingFooter.setNoNetWorkHint(noNetWork);
        }
    }

    public void setFooterViewColor(int indicatorColor, int hintColor, int backgroundColor) {
        if (this.mLoadMoreFooter != null && this.mLoadMoreFooter instanceof LoadingFooter) {
            LoadingFooter loadingFooter = (LoadingFooter)this.mLoadMoreFooter;
            loadingFooter.setIndicatorColor(ContextCompat.getColor((Context)this.getContext(), (int)indicatorColor));
            loadingFooter.setHintTextColor(hintColor);
            loadingFooter.setViewBackgroundColor(backgroundColor);
        }
    }

    public void setHeaderViewColor(int indicatorColor, int hintColor, int backgroundColor) {
        if (this.mRefreshHeader != null && this.mRefreshHeader instanceof ArrowRefreshHeader) {
            ArrowRefreshHeader arrowRefreshHeader = (ArrowRefreshHeader)this.mRefreshHeader;
            arrowRefreshHeader.setIndicatorColor(ContextCompat.getColor((Context)this.getContext(), (int)indicatorColor));
            arrowRefreshHeader.setHintTextColor(hintColor);
            arrowRefreshHeader.setViewBackgroundColor(backgroundColor);
        }
    }

    public void setLScrollListener(LScrollListener listener) {
        this.mLScrollListener = listener;
    }

    public void refresh() {
        if (this.mRefreshHeader.getVisibleHeight() > 0 || this.mRefreshing) {
            return;
        }
        if (this.mPullRefreshEnabled && this.mRefreshListener != null) {
            this.mRefreshHeader.onRefreshing();
            int offSet = this.mRefreshHeader.getHeaderView().getMeasuredHeight();
            this.mRefreshHeader.onMove(offSet, offSet);
            this.mRefreshing = true;
            this.mFootView.setVisibility(8);
            this.mRefreshListener.onRefresh();
        }
    }

    public void forceToRefresh() {
        if (this.mLoadingData) {
            return;
        }
        this.refresh();
    }

    public void onScrolled(int dx, int dy) {
        super.onScrolled(dx, dy);
        int firstVisibleItemPosition = 0;
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (this.layoutManagerType == null) {
            if (layoutManager instanceof LinearLayoutManager) {
                this.layoutManagerType = LayoutManagerType.LinearLayout;
            } else if (layoutManager instanceof GridLayoutManager) {
                this.layoutManagerType = LayoutManagerType.GridLayout;
            } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                this.layoutManagerType = LayoutManagerType.StaggeredGridLayout;
            } else {
                throw new RuntimeException("Unsupported LayoutManager used. Valid ones are LinearLayoutManager, GridLayoutManager and StaggeredGridLayoutManager");
            }
        }
        switch (this.layoutManagerType) {
            case LinearLayout: {
                firstVisibleItemPosition = ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
                this.lastVisibleItemPosition = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
                break;
            }
            case GridLayout: {
                firstVisibleItemPosition = ((GridLayoutManager)layoutManager).findFirstVisibleItemPosition();
                this.lastVisibleItemPosition = ((GridLayoutManager)layoutManager).findLastVisibleItemPosition();
                break;
            }
            case StaggeredGridLayout: {
                StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
                if (this.lastPositions == null) {
                    this.lastPositions = new int[staggeredGridLayoutManager.getSpanCount()];
                }
                staggeredGridLayoutManager.findLastVisibleItemPositions(this.lastPositions);
                this.lastVisibleItemPosition = this.findMax(this.lastPositions);
                staggeredGridLayoutManager.findFirstCompletelyVisibleItemPositions(this.lastPositions);
                firstVisibleItemPosition = this.findMax(this.lastPositions);
            }
        }
        this.calculateScrollUpOrDown(firstVisibleItemPosition, dy);
        this.mScrolledXDistance += dx;
        this.mScrolledYDistance += dy;
        this.mScrolledXDistance = this.mScrolledXDistance < 0 ? 0 : this.mScrolledXDistance;
        int n = this.mScrolledYDistance = this.mScrolledYDistance < 0 ? 0 : this.mScrolledYDistance;
        if (this.mIsScrollDown && dy == 0) {
            this.mScrolledYDistance = 0;
        }
        if (null != this.mLScrollListener) {
            this.mLScrollListener.onScrolled(this.mScrolledXDistance, this.mScrolledYDistance);
        }
        if (this.mLoadMoreListener != null && this.mLoadMoreEnabled) {
            int visibleItemCount = layoutManager.getChildCount();
            int totalItemCount = layoutManager.getItemCount();
            if (visibleItemCount > 0 && this.lastVisibleItemPosition >= totalItemCount - 1 && totalItemCount > visibleItemCount && !this.isNoMore && !this.mRefreshing) {
                this.mFootView.setVisibility(0);
                if (!this.mLoadingData) {
                    this.mLoadingData = true;
                    this.mLoadMoreFooter.onLoading();
                    this.mLoadMoreListener.onLoadMore();
                }
            }
        }
        if (this.isOnTop() && dy > 0 && this.mRefreshHeader.getType() == 1 && !this.mRefreshing && this.appbarState == AppBarStateChangeListener.State.EXPANDED) {
            this.mRefreshHeader.onMove(dy, this.mScrolledYDistance);
        }
    }

    public void onScrollStateChanged(int state) {
        super.onScrollStateChanged(state);
        this.currentScrollState = state;
        if (this.mLScrollListener != null) {
            this.mLScrollListener.onScrollStateChanged(state);
        }
    }

    private void calculateScrollUpOrDown(int firstVisibleItemPosition, int dy) {
        if (null != this.mLScrollListener) {
            if (firstVisibleItemPosition == 0) {
                if (!this.mIsScrollDown) {
                    this.mIsScrollDown = true;
                    this.mLScrollListener.onScrollDown();
                }
            } else if (this.mDistance > 20 && this.mIsScrollDown) {
                this.mIsScrollDown = false;
                this.mLScrollListener.onScrollUp();
                this.mDistance = 0;
            } else if (this.mDistance < -20 && !this.mIsScrollDown) {
                this.mIsScrollDown = true;
                this.mLScrollListener.onScrollDown();
                this.mDistance = 0;
            }
        }
        if (this.mIsScrollDown && dy > 0 || !this.mIsScrollDown && dy < 0) {
            this.mDistance += dy;
        }
    }

    protected void onAttachedToWindow() {
        ViewParent p;
        super.onAttachedToWindow();
        AppBarLayout appBarLayout = null;
        for (p = this.getParent(); p != null && !(p instanceof CoordinatorLayout); p = p.getParent()) {
        }
        if (null != p && p instanceof CoordinatorLayout) {
            CoordinatorLayout coordinatorLayout = (CoordinatorLayout)p;
            int childCount = coordinatorLayout.getChildCount();
            for (int i = childCount - 1; i >= 0; --i) {
                View child = coordinatorLayout.getChildAt(i);
                if (!(child instanceof AppBarLayout)) continue;
                appBarLayout = (AppBarLayout)child;
                break;
            }
            if (appBarLayout != null) {
                appBarLayout.addOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)new AppBarStateChangeListener(){

                    @Override
                    public void onStateChanged(AppBarLayout appBarLayout, AppBarStateChangeListener.State state) {
                        LRecyclerView.this.appbarState = state;
                    }
                });
            }
        }
    }

    public static enum LayoutManagerType {
        LinearLayout,
        StaggeredGridLayout,
        GridLayout;

    }

    public static interface LScrollListener {
        public void onScrollUp();

        public void onScrollDown();

        public void onScrolled(int var1, int var2);

        public void onScrollStateChanged(int var1);
    }

    private class DataObserver
    extends RecyclerView.AdapterDataObserver {
        private DataObserver() {
        }

        public void onChanged() {
            RecyclerView.Adapter adapter = LRecyclerView.this.getAdapter();
            if (adapter instanceof LRecyclerViewAdapter) {
                LRecyclerViewAdapter lRecyclerViewAdapter = (LRecyclerViewAdapter)adapter;
                if (lRecyclerViewAdapter.getInnerAdapter() != null && LRecyclerView.this.mEmptyView != null) {
                    int count = lRecyclerViewAdapter.getInnerAdapter().getItemCount();
                    if (count == 0) {
                        LRecyclerView.this.mEmptyView.setVisibility(0);
                        LRecyclerView.this.setVisibility(8);
                    } else {
                        LRecyclerView.this.mEmptyView.setVisibility(8);
                        LRecyclerView.this.setVisibility(0);
                    }
                }
            } else if (adapter != null && LRecyclerView.this.mEmptyView != null) {
                if (adapter.getItemCount() == 0) {
                    LRecyclerView.this.mEmptyView.setVisibility(0);
                    LRecyclerView.this.setVisibility(8);
                } else {
                    LRecyclerView.this.mEmptyView.setVisibility(8);
                    LRecyclerView.this.setVisibility(0);
                }
            }
            if (LRecyclerView.this.mWrapAdapter != null) {
                LRecyclerView.this.mWrapAdapter.notifyDataSetChanged();
                if (LRecyclerView.this.mWrapAdapter.getInnerAdapter().getItemCount() < LRecyclerView.this.mPageSize) {
                    LRecyclerView.this.mFootView.setVisibility(8);
                }
            }
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            LRecyclerView.this.mWrapAdapter.notifyItemRangeChanged(positionStart + LRecyclerView.this.mWrapAdapter.getHeaderViewsCount() + 1, itemCount);
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            LRecyclerView.this.mWrapAdapter.notifyItemRangeInserted(positionStart + LRecyclerView.this.mWrapAdapter.getHeaderViewsCount() + 1, itemCount);
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            LRecyclerView.this.mWrapAdapter.notifyItemRangeRemoved(positionStart + LRecyclerView.this.mWrapAdapter.getHeaderViewsCount() + 1, itemCount);
            if (LRecyclerView.this.mWrapAdapter.getInnerAdapter().getItemCount() < LRecyclerView.this.mPageSize) {
                LRecyclerView.this.mFootView.setVisibility(8);
            }
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            int headerViewsCountCount = LRecyclerView.this.mWrapAdapter.getHeaderViewsCount();
            LRecyclerView.this.mWrapAdapter.notifyItemRangeChanged(fromPosition + headerViewsCountCount + 1, toPosition + headerViewsCountCount + 1 + itemCount);
        }
    }
}

