/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.ItemDecoration;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.github.jdsjlzx.ItemDecoration.SpanLookup;
import com.github.jdsjlzx.ItemDecoration.SpanLookupFactory;
import com.github.jdsjlzx.recyclerview.LuRecyclerViewAdapter;

public class LuSpacesItemDecoration
extends RecyclerView.ItemDecoration {
    private final int itemSplitMarginEven;
    private final int itemSplitMarginLarge;
    private final int itemSplitMarginSmall;
    private final int verticalSpacing;
    private Paint mPaint;

    public static LuSpacesItemDecoration newInstance(int horizontalSpacing, int verticalSpacing, int spanCount, int color) {
        int maxNumberOfSpaces = spanCount - 1;
        int totalSpaceToSplitBetweenItems = maxNumberOfSpaces * horizontalSpacing;
        int itemSplitMarginEven = (int)(0.5f * (float)horizontalSpacing);
        int itemSplitMarginLarge = totalSpaceToSplitBetweenItems / spanCount;
        int itemSplitMarginSmall = horizontalSpacing - itemSplitMarginLarge;
        return new LuSpacesItemDecoration(itemSplitMarginEven, itemSplitMarginLarge, itemSplitMarginSmall, verticalSpacing, color);
    }

    private LuSpacesItemDecoration(int itemSplitMarginEven, int itemSplitMarginLarge, int itemSplitMarginSmall, int verticalSpacing, int color) {
        this.itemSplitMarginEven = itemSplitMarginEven;
        this.itemSplitMarginLarge = itemSplitMarginLarge;
        this.itemSplitMarginSmall = itemSplitMarginSmall;
        this.verticalSpacing = verticalSpacing;
        this.mPaint = new Paint();
        this.mPaint.setColor(color);
    }

    public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
        RecyclerView.Adapter adapter = parent.getAdapter();
        if (!(adapter instanceof LuRecyclerViewAdapter)) {
            throw new RuntimeException("the adapter must be LuRecyclerViewAdapter");
        }
        LuRecyclerViewAdapter LuRecyclerViewAdapter2 = (LuRecyclerViewAdapter)adapter;
        this.drawHorizontal(c, parent, LuRecyclerViewAdapter2);
        this.drawVertical(c, parent, LuRecyclerViewAdapter2);
    }

    public void drawHorizontal(Canvas c, RecyclerView parent, LuRecyclerViewAdapter adapter) {
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = parent.getChildAt(i);
            int top = child.getBottom();
            int bottom = top + this.verticalSpacing;
            int left = child.getLeft();
            int right = child.getRight();
            int position = parent.getChildAdapterPosition(child);
            c.save();
            if (adapter.isHeader(position) || adapter.isFooter(position)) {
                c.drawRect(0.0f, 0.0f, 0.0f, 0.0f, this.mPaint);
            } else {
                c.drawRect((float)left, (float)top, (float)right, (float)bottom, this.mPaint);
            }
            c.restore();
        }
    }

    public void drawVertical(Canvas c, RecyclerView parent, LuRecyclerViewAdapter adapter) {
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = parent.getChildAt(i);
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            int top = child.getTop();
            int bottom = child.getBottom() + this.verticalSpacing;
            int left = child.getRight() + params.rightMargin;
            int right = left + this.itemSplitMarginEven * 2;
            int position = parent.getChildAdapterPosition(child);
            c.save();
            if (adapter.isHeader(position) || adapter.isFooter(position)) {
                c.drawRect(0.0f, 0.0f, 0.0f, 0.0f, this.mPaint);
            } else {
                c.drawRect((float)left, (float)top, (float)right, (float)bottom, this.mPaint);
            }
            c.restore();
        }
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        RecyclerView.Adapter adapter = parent.getAdapter();
        if (!(adapter instanceof LuRecyclerViewAdapter)) {
            throw new RuntimeException("the adapter must be LuRecyclerViewAdapter");
        }
        LuRecyclerViewAdapter LuRecyclerViewAdapter2 = (LuRecyclerViewAdapter)adapter;
        RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
        int itemPosition = layoutParams.getViewLayoutPosition();
        int childCount = parent.getAdapter().getItemCount();
        SpanLookup spanLookup = this.getSpanLookup(view, parent);
        this.applyItemHorizontalOffsets(spanLookup, itemPosition, outRect);
        this.applyItemVerticalOffsets(outRect, itemPosition, childCount, spanLookup.getSpanCount(), spanLookup, LuRecyclerViewAdapter2);
    }

    protected SpanLookup getSpanLookup(View view, RecyclerView parent) {
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            return SpanLookupFactory.gridLayoutSpanLookup((GridLayoutManager)layoutManager);
        }
        return SpanLookupFactory.singleSpan();
    }

    private void applyItemVerticalOffsets(Rect outRect, int itemPosition, int childCount, int spanCount, SpanLookup spanLookup, LuRecyclerViewAdapter adapter) {
        outRect.top = LuSpacesItemDecoration.getItemTopSpacing(spanLookup, this.verticalSpacing, itemPosition, spanCount, childCount, adapter);
        outRect.bottom = LuSpacesItemDecoration.getItemBottomSpacing(spanLookup, this.verticalSpacing, itemPosition, childCount, adapter);
    }

    private void applyItemHorizontalOffsets(SpanLookup spanLookup, int itemPosition, Rect offsets) {
        if (LuSpacesItemDecoration.itemIsFullSpan(spanLookup, itemPosition)) {
            offsets.left = 0;
            offsets.right = 0;
            return;
        }
        if (LuSpacesItemDecoration.itemStartsAtTheLeftEdge(spanLookup, itemPosition)) {
            offsets.left = 0;
            offsets.right = this.itemSplitMarginLarge;
            return;
        }
        if (LuSpacesItemDecoration.itemEndsAtTheRightEdge(spanLookup, itemPosition)) {
            offsets.left = this.itemSplitMarginLarge;
            offsets.right = 0;
            return;
        }
        offsets.left = LuSpacesItemDecoration.itemIsNextToAnItemThatStartsOnTheLeftEdge(spanLookup, itemPosition) ? this.itemSplitMarginSmall : this.itemSplitMarginEven;
        offsets.right = LuSpacesItemDecoration.itemIsNextToAnItemThatEndsOnTheRightEdge(spanLookup, itemPosition) ? this.itemSplitMarginSmall : this.itemSplitMarginEven;
    }

    private static boolean itemIsNextToAnItemThatStartsOnTheLeftEdge(SpanLookup spanLookup, int itemPosition) {
        return !LuSpacesItemDecoration.itemStartsAtTheLeftEdge(spanLookup, itemPosition) && LuSpacesItemDecoration.itemStartsAtTheLeftEdge(spanLookup, itemPosition - 1);
    }

    private static boolean itemIsNextToAnItemThatEndsOnTheRightEdge(SpanLookup spanLookup, int itemPosition) {
        return !LuSpacesItemDecoration.itemEndsAtTheRightEdge(spanLookup, itemPosition) && LuSpacesItemDecoration.itemEndsAtTheRightEdge(spanLookup, itemPosition + 1);
    }

    private static boolean itemIsFullSpan(SpanLookup spanLookup, int itemPosition) {
        return LuSpacesItemDecoration.itemStartsAtTheLeftEdge(spanLookup, itemPosition) && LuSpacesItemDecoration.itemEndsAtTheRightEdge(spanLookup, itemPosition);
    }

    private static boolean itemStartsAtTheLeftEdge(SpanLookup spanLookup, int itemPosition) {
        return spanLookup.getSpanIndex(itemPosition) == 0;
    }

    private static boolean itemEndsAtTheRightEdge(SpanLookup spanLookup, int itemPosition) {
        return spanLookup.getSpanIndex(itemPosition) + spanLookup.getSpanSize(itemPosition) == spanLookup.getSpanCount();
    }

    private static int getItemTopSpacing(SpanLookup spanLookup, int verticalSpacing, int itemPosition, int spanCount, int childCount, LuRecyclerViewAdapter adapter) {
        if (adapter.isHeader(itemPosition) || adapter.isFooter(itemPosition)) {
            return 0;
        }
        if (LuSpacesItemDecoration.itemIsOnTheTopRow(spanLookup, itemPosition, spanCount, childCount)) {
            return 0;
        }
        return (int)(0.5f * (float)verticalSpacing);
    }

    private static boolean itemIsOnTheTopRow(SpanLookup spanLookup, int itemPosition, int spanCount, int childCount) {
        int latestCheckedPosition = 0;
        for (int i = 0; i < childCount; ++i) {
            latestCheckedPosition = i;
            int spanEndIndex = spanLookup.getSpanIndex(i) + spanLookup.getSpanSize(i) - 1;
            if (spanEndIndex == spanCount - 1) break;
        }
        return itemPosition <= latestCheckedPosition;
    }

    private static int getItemBottomSpacing(SpanLookup spanLookup, int verticalSpacing, int itemPosition, int childCount, LuRecyclerViewAdapter adapter) {
        if (adapter.isHeader(itemPosition) || adapter.isFooter(itemPosition)) {
            return 0;
        }
        if (LuSpacesItemDecoration.itemIsOnTheBottomRow(spanLookup, itemPosition, childCount)) {
            return 0;
        }
        return (int)(0.5f * (float)verticalSpacing);
    }

    private static boolean itemIsOnTheBottomRow(SpanLookup spanLookup, int itemPosition, int childCount) {
        int latestCheckedPosition = 0;
        for (int i = childCount - 1; i >= 0; --i) {
            latestCheckedPosition = i;
            int spanIndex = spanLookup.getSpanIndex(i);
            if (spanIndex == 0) break;
        }
        return itemPosition >= latestCheckedPosition;
    }
}

