/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.recyclerview;

import android.content.Context;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewParent;
import com.github.jdsjlzx.interfaces.ILoadMoreFooter;
import com.github.jdsjlzx.interfaces.OnLoadMoreListener;
import com.github.jdsjlzx.interfaces.OnNetWorkErrorListener;
import com.github.jdsjlzx.recyclerview.AppBarStateChangeListener;
import com.github.jdsjlzx.recyclerview.LRecyclerViewAdapter;
import com.github.jdsjlzx.recyclerview.LuRecyclerViewAdapter;
import com.github.jdsjlzx.view.LoadingFooter;

public class LuRecyclerView
extends RecyclerView {
    private boolean mLoadMoreEnabled = true;
    private boolean mRefreshing = false;
    private boolean mLoadingData = false;
    private boolean flag = false;
    private OnLoadMoreListener mLoadMoreListener;
    private LScrollListener mLScrollListener;
    private ILoadMoreFooter mLoadMoreFooter;
    private View mEmptyView;
    private View mFootView;
    private final RecyclerView.AdapterDataObserver mDataObserver = new DataObserver();
    private int mPageSize = 10;
    private LuRecyclerViewAdapter mWrapAdapter;
    private boolean isNoMore = false;
    protected LayoutManagerType layoutManagerType;
    private int[] lastPositions;
    private int lastVisibleItemPosition;
    private int currentScrollState = 0;
    private static final int HIDE_THRESHOLD = 20;
    private int mDistance = 0;
    private boolean mIsScrollDown = true;
    private int mScrolledYDistance = 0;
    private int mScrolledXDistance = 0;
    private AppBarStateChangeListener.State appbarState = AppBarStateChangeListener.State.EXPANDED;

    public LuRecyclerView(Context context) {
        this(context, null);
    }

    public LuRecyclerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LuRecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        if (this.mLoadMoreEnabled) {
            this.setLoadMoreFooter(new LoadingFooter(this.getContext().getApplicationContext()));
        }
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        if (this.mWrapAdapter != null && this.mDataObserver != null) {
            this.mWrapAdapter.getInnerAdapter().unregisterAdapterDataObserver(this.mDataObserver);
        }
        this.mWrapAdapter = (LuRecyclerViewAdapter)adapter;
        super.setAdapter((RecyclerView.Adapter)this.mWrapAdapter);
        this.mWrapAdapter.getInnerAdapter().registerAdapterDataObserver(this.mDataObserver);
        this.mDataObserver.onChanged();
        if (this.mLoadMoreEnabled && this.mWrapAdapter.getFooterViewsCount() == 0) {
            this.mWrapAdapter.addFooterView(this.mFootView);
        }
    }

    private int findMax(int[] lastPositions) {
        int max = lastPositions[0];
        for (int value : lastPositions) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    public void setEmptyView(View emptyView) {
        this.mEmptyView = emptyView;
        this.mDataObserver.onChanged();
    }

    public void setRefreshing(boolean refreshing) {
        this.mRefreshing = refreshing;
    }

    public void refreshComplete(int pageSize) {
        this.mPageSize = pageSize;
        if (this.mRefreshing) {
            this.isNoMore = false;
            this.mRefreshing = false;
            if (this.mWrapAdapter.getInnerAdapter().getItemCount() < pageSize) {
                this.mFootView.setVisibility(8);
            }
        } else if (this.mLoadingData) {
            this.mLoadingData = false;
            this.mLoadMoreFooter.onComplete();
        }
    }

    public void setNoMore(boolean noMore) {
        this.mLoadingData = false;
        this.isNoMore = noMore;
        if (this.isNoMore) {
            this.mLoadMoreFooter.onNoMore();
        } else {
            this.mLoadMoreFooter.onComplete();
        }
    }

    public void setLoadMoreFooter(ILoadMoreFooter loadMoreFooter) {
        this.mLoadMoreFooter = loadMoreFooter;
        this.mFootView = loadMoreFooter.getFootView();
        this.mFootView.setVisibility(8);
    }

    public void setLoadMoreEnabled(boolean enabled) {
        if (this.mWrapAdapter == null) {
            throw new NullPointerException("mWrapAdapter cannot be null, please make sure the variable mWrapAdapter have been initialized.");
        }
        this.mLoadMoreEnabled = enabled;
        if (!enabled) {
            if (null != this.mWrapAdapter) {
                this.mWrapAdapter.removeFooterView();
            } else {
                this.mLoadMoreFooter.onReset();
            }
        }
    }

    public void setLoadingMoreProgressStyle(int style2) {
        if (this.mLoadMoreFooter != null && this.mLoadMoreFooter instanceof LoadingFooter) {
            ((LoadingFooter)this.mLoadMoreFooter).setProgressStyle(style2);
        }
    }

    public void setOnLoadMoreListener(OnLoadMoreListener listener) {
        this.mLoadMoreListener = listener;
    }

    public void setOnNetWorkErrorListener(final OnNetWorkErrorListener listener) {
        LoadingFooter loadingFooter = (LoadingFooter)this.mFootView;
        loadingFooter.setState(LoadingFooter.State.NetWorkError);
        loadingFooter.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LuRecyclerView.this.mLoadMoreFooter.onLoading();
                listener.reload();
            }
        });
    }

    public void setFooterViewHint(String loading, String noMore, String noNetWork) {
        if (this.mLoadMoreFooter != null && this.mLoadMoreFooter instanceof LoadingFooter) {
            LoadingFooter loadingFooter = (LoadingFooter)this.mLoadMoreFooter;
            loadingFooter.setLoadingHint(loading);
            loadingFooter.setNoMoreHint(noMore);
            loadingFooter.setNoNetWorkHint(noNetWork);
        }
    }

    public void setFooterViewColor(int indicatorColor, int hintColor, int backgroundColor) {
        if (this.mLoadMoreFooter != null && this.mLoadMoreFooter instanceof LoadingFooter) {
            LoadingFooter loadingFooter = (LoadingFooter)this.mLoadMoreFooter;
            loadingFooter.setIndicatorColor(ContextCompat.getColor((Context)this.getContext(), (int)indicatorColor));
            loadingFooter.setHintTextColor(hintColor);
            loadingFooter.setViewBackgroundColor(backgroundColor);
        }
    }

    public void setLScrollListener(LScrollListener listener) {
        this.mLScrollListener = listener;
    }

    public void onScrolled(int dx, int dy) {
        super.onScrolled(dx, dy);
        int firstVisibleItemPosition = 0;
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (this.layoutManagerType == null) {
            if (layoutManager instanceof LinearLayoutManager) {
                this.layoutManagerType = LayoutManagerType.LinearLayout;
            } else if (layoutManager instanceof GridLayoutManager) {
                this.layoutManagerType = LayoutManagerType.GridLayout;
            } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                this.layoutManagerType = LayoutManagerType.StaggeredGridLayout;
            } else {
                throw new RuntimeException("Unsupported LayoutManager used. Valid ones are LinearLayoutManager, GridLayoutManager and StaggeredGridLayoutManager");
            }
        }
        switch (this.layoutManagerType) {
            case LinearLayout: {
                firstVisibleItemPosition = ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
                this.lastVisibleItemPosition = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
                break;
            }
            case GridLayout: {
                firstVisibleItemPosition = ((GridLayoutManager)layoutManager).findFirstVisibleItemPosition();
                this.lastVisibleItemPosition = ((GridLayoutManager)layoutManager).findLastVisibleItemPosition();
                break;
            }
            case StaggeredGridLayout: {
                StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
                if (this.lastPositions == null) {
                    this.lastPositions = new int[staggeredGridLayoutManager.getSpanCount()];
                }
                staggeredGridLayoutManager.findLastVisibleItemPositions(this.lastPositions);
                this.lastVisibleItemPosition = this.findMax(this.lastPositions);
                staggeredGridLayoutManager.findFirstCompletelyVisibleItemPositions(this.lastPositions);
                firstVisibleItemPosition = this.findMax(this.lastPositions);
            }
        }
        this.calculateScrollUpOrDown(firstVisibleItemPosition, dy);
        this.mScrolledXDistance += dx;
        this.mScrolledYDistance += dy;
        this.mScrolledXDistance = this.mScrolledXDistance < 0 ? 0 : this.mScrolledXDistance;
        int n = this.mScrolledYDistance = this.mScrolledYDistance < 0 ? 0 : this.mScrolledYDistance;
        if (this.mIsScrollDown && dy == 0) {
            this.mScrolledYDistance = 0;
        }
        if (null != this.mLScrollListener) {
            this.mLScrollListener.onScrolled(this.mScrolledXDistance, this.mScrolledYDistance);
        }
        if (this.mLoadMoreListener != null && this.mLoadMoreEnabled) {
            int visibleItemCount = layoutManager.getChildCount();
            int totalItemCount = layoutManager.getItemCount();
            if (visibleItemCount > 0 && this.lastVisibleItemPosition >= totalItemCount - 1 && totalItemCount > visibleItemCount && !this.isNoMore && !this.mRefreshing) {
                this.mFootView.setVisibility(0);
                if (!this.mLoadingData) {
                    this.mLoadingData = true;
                    this.mLoadMoreFooter.onLoading();
                    this.mLoadMoreListener.onLoadMore();
                }
            }
        }
    }

    public void onScrollStateChanged(int state) {
        super.onScrollStateChanged(state);
        this.currentScrollState = state;
        if (this.mLScrollListener != null) {
            this.mLScrollListener.onScrollStateChanged(state);
        }
    }

    private void calculateScrollUpOrDown(int firstVisibleItemPosition, int dy) {
        if (null != this.mLScrollListener) {
            if (firstVisibleItemPosition == 0) {
                if (!this.mIsScrollDown) {
                    this.mIsScrollDown = true;
                    this.mLScrollListener.onScrollDown();
                }
            } else if (this.mDistance > 20 && this.mIsScrollDown) {
                this.mIsScrollDown = false;
                this.mLScrollListener.onScrollUp();
                this.mDistance = 0;
            } else if (this.mDistance < -20 && !this.mIsScrollDown) {
                this.mIsScrollDown = true;
                this.mLScrollListener.onScrollDown();
                this.mDistance = 0;
            }
        }
        if (this.mIsScrollDown && dy > 0 || !this.mIsScrollDown && dy < 0) {
            this.mDistance += dy;
        }
    }

    protected void onAttachedToWindow() {
        ViewParent p;
        super.onAttachedToWindow();
        AppBarLayout appBarLayout = null;
        for (p = this.getParent(); p != null && !(p instanceof CoordinatorLayout); p = p.getParent()) {
        }
        if (p instanceof CoordinatorLayout) {
            CoordinatorLayout coordinatorLayout = (CoordinatorLayout)p;
            int childCount = coordinatorLayout.getChildCount();
            for (int i = childCount - 1; i >= 0; --i) {
                View child = coordinatorLayout.getChildAt(i);
                if (!(child instanceof AppBarLayout)) continue;
                appBarLayout = (AppBarLayout)child;
                break;
            }
            if (appBarLayout != null) {
                appBarLayout.addOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)new AppBarStateChangeListener(){

                    @Override
                    public void onStateChanged(AppBarLayout appBarLayout, AppBarStateChangeListener.State state) {
                        LuRecyclerView.this.appbarState = state;
                    }
                });
            }
        }
    }

    public static enum LayoutManagerType {
        LinearLayout,
        StaggeredGridLayout,
        GridLayout;

    }

    public static interface LScrollListener {
        public void onScrollUp();

        public void onScrollDown();

        public void onScrolled(int var1, int var2);

        public void onScrollStateChanged(int var1);
    }

    private class DataObserver
    extends RecyclerView.AdapterDataObserver {
        private DataObserver() {
        }

        public void onChanged() {
            RecyclerView.Adapter adapter = LuRecyclerView.this.getAdapter();
            if (adapter instanceof LRecyclerViewAdapter) {
                LRecyclerViewAdapter lRecyclerViewAdapter = (LRecyclerViewAdapter)adapter;
                if (lRecyclerViewAdapter.getInnerAdapter() != null && LuRecyclerView.this.mEmptyView != null) {
                    int count = lRecyclerViewAdapter.getInnerAdapter().getItemCount();
                    if (count == 0) {
                        LuRecyclerView.this.mEmptyView.setVisibility(0);
                        LuRecyclerView.this.setVisibility(8);
                    } else {
                        LuRecyclerView.this.mEmptyView.setVisibility(8);
                        LuRecyclerView.this.setVisibility(0);
                    }
                }
            } else if (adapter != null && LuRecyclerView.this.mEmptyView != null) {
                if (adapter.getItemCount() == 0) {
                    LuRecyclerView.this.mEmptyView.setVisibility(0);
                    LuRecyclerView.this.setVisibility(8);
                } else {
                    LuRecyclerView.this.mEmptyView.setVisibility(8);
                    LuRecyclerView.this.setVisibility(0);
                }
            }
            if (LuRecyclerView.this.mWrapAdapter != null) {
                LuRecyclerView.this.mWrapAdapter.notifyDataSetChanged();
                if (LuRecyclerView.this.mWrapAdapter.getInnerAdapter().getItemCount() < LuRecyclerView.this.mPageSize) {
                    LuRecyclerView.this.mFootView.setVisibility(8);
                }
            }
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            LuRecyclerView.this.mWrapAdapter.notifyItemRangeChanged(positionStart + LuRecyclerView.this.mWrapAdapter.getHeaderViewsCount() + 1, itemCount);
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            LuRecyclerView.this.mWrapAdapter.notifyItemRangeInserted(positionStart + LuRecyclerView.this.mWrapAdapter.getHeaderViewsCount() + 1, itemCount);
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            LuRecyclerView.this.mWrapAdapter.notifyItemRangeRemoved(positionStart + LuRecyclerView.this.mWrapAdapter.getHeaderViewsCount() + 1, itemCount);
            if (LuRecyclerView.this.mWrapAdapter.getInnerAdapter().getItemCount() < LuRecyclerView.this.mPageSize) {
                LuRecyclerView.this.mFootView.setVisibility(8);
            }
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            int headerViewsCountCount = LuRecyclerView.this.mWrapAdapter.getHeaderViewsCount();
            LuRecyclerView.this.mWrapAdapter.notifyItemRangeChanged(fromPosition + headerViewsCountCount + 1, toPosition + headerViewsCountCount + 1 + itemCount);
        }
    }
}

