/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.progressindicator.indicators;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.view.animation.LinearInterpolator;
import com.github.jdsjlzx.progressindicator.Indicator;
import java.util.ArrayList;

public class BallPulseRiseIndicator
extends Indicator {
    private Camera mCamera = new Camera();
    private Matrix mMatrix = new Matrix();
    private float degress;

    @Override
    public void draw(Canvas canvas, Paint paint) {
        this.mMatrix.reset();
        this.mCamera.save();
        this.mCamera.rotateX(this.degress);
        this.mCamera.getMatrix(this.mMatrix);
        this.mCamera.restore();
        this.mMatrix.preTranslate((float)(-this.centerX()), (float)(-this.centerY()));
        this.mMatrix.postTranslate((float)this.centerX(), (float)this.centerY());
        canvas.concat(this.mMatrix);
        float radius = this.getWidth() / 10;
        canvas.drawCircle((float)(this.getWidth() / 4), radius * 2.0f, radius, paint);
        canvas.drawCircle((float)(this.getWidth() * 3 / 4), radius * 2.0f, radius, paint);
        canvas.drawCircle(radius, (float)this.getHeight() - 2.0f * radius, radius, paint);
        canvas.drawCircle((float)(this.getWidth() / 2), (float)this.getHeight() - 2.0f * radius, radius, paint);
        canvas.drawCircle((float)this.getWidth() - radius, (float)this.getHeight() - 2.0f * radius, radius, paint);
    }

    @Override
    public ArrayList<ValueAnimator> onCreateAnimators() {
        ArrayList<ValueAnimator> animators = new ArrayList<ValueAnimator>();
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 360.0f});
        this.addUpdateListener(animator, new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BallPulseRiseIndicator.this.degress = ((Float)animation.getAnimatedValue()).floatValue();
                BallPulseRiseIndicator.this.postInvalidate();
            }
        });
        animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        animator.setRepeatCount(-1);
        animator.setDuration(1500L);
        animators.add(animator);
        return animators;
    }
}

