/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.progressindicator.indicators;

import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.github.jdsjlzx.progressindicator.Indicator;
import java.util.ArrayList;

public class BallClipRotateMultipleIndicator
extends Indicator {
    float scaleFloat = 1.0f;
    float degrees;

    @Override
    public void draw(Canvas canvas, Paint paint) {
        paint.setStrokeWidth(3.0f);
        paint.setStyle(Paint.Style.STROKE);
        float circleSpacing = 12.0f;
        float x = this.getWidth() / 2;
        float y = this.getHeight() / 2;
        canvas.save();
        canvas.translate(x, y);
        canvas.scale(this.scaleFloat, this.scaleFloat);
        canvas.rotate(this.degrees);
        float[] bStartAngles = new float[]{135.0f, -45.0f};
        for (int i = 0; i < 2; ++i) {
            RectF rectF = new RectF(-x + circleSpacing, -y + circleSpacing, x - circleSpacing, y - circleSpacing);
            canvas.drawArc(rectF, bStartAngles[i], 90.0f, false, paint);
        }
        canvas.restore();
        canvas.translate(x, y);
        canvas.scale(this.scaleFloat, this.scaleFloat);
        canvas.rotate(-this.degrees);
        float[] sStartAngles = new float[]{225.0f, 45.0f};
        for (int i = 0; i < 2; ++i) {
            RectF rectF = new RectF(-x / 1.8f + circleSpacing, -y / 1.8f + circleSpacing, x / 1.8f - circleSpacing, y / 1.8f - circleSpacing);
            canvas.drawArc(rectF, sStartAngles[i], 90.0f, false, paint);
        }
    }

    @Override
    public ArrayList<ValueAnimator> onCreateAnimators() {
        ArrayList<ValueAnimator> animators = new ArrayList<ValueAnimator>();
        ValueAnimator scaleAnim = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.6f, 1.0f});
        scaleAnim.setDuration(1000L);
        scaleAnim.setRepeatCount(-1);
        this.addUpdateListener(scaleAnim, new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BallClipRotateMultipleIndicator.this.scaleFloat = ((Float)animation.getAnimatedValue()).floatValue();
                BallClipRotateMultipleIndicator.this.postInvalidate();
            }
        });
        ValueAnimator rotateAnim = ValueAnimator.ofFloat((float[])new float[]{0.0f, 180.0f, 360.0f});
        rotateAnim.setDuration(1000L);
        rotateAnim.setRepeatCount(-1);
        this.addUpdateListener(rotateAnim, new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BallClipRotateMultipleIndicator.this.degrees = ((Float)animation.getAnimatedValue()).floatValue();
                BallClipRotateMultipleIndicator.this.postInvalidate();
            }
        });
        animators.add(scaleAnim);
        animators.add(rotateAnim);
        return animators;
    }
}

