/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.recyclerview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PointF;
import android.os.Build;
import android.os.Parcelable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.LinearSmoothScroller;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.Interpolator;
import com.github.jdsjlzx.R;
import com.github.jdsjlzx.interfaces.Closeable;
import com.github.jdsjlzx.interfaces.OnSwipeMenuItemClickListener;
import com.github.jdsjlzx.interfaces.SwipeMenuCreator;
import com.github.jdsjlzx.recyclerview.LRecyclerViewAdapter;
import com.github.jdsjlzx.swipe.SwipeMenu;
import com.github.jdsjlzx.swipe.SwipeMenuAdapter;
import com.github.jdsjlzx.swipe.SwipeMenuLayout;
import com.github.jdsjlzx.swipe.touch.DefaultItemTouchHelper;
import com.github.jdsjlzx.swipe.touch.OnItemMoveListener;
import com.github.jdsjlzx.swipe.touch.OnItemMovementListener;
import com.github.jdsjlzx.util.ViewUtils;
import com.github.jdsjlzx.view.ArrowRefreshHeader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class LRecyclerView
extends RecyclerView {
    public static final boolean DEBUG = false;
    private boolean pullRefreshEnabled = true;
    private LScrollListener mLScrollListener;
    private ArrowRefreshHeader mRefreshHeader;
    private View mEmptyView;
    private final RecyclerView.AdapterDataObserver mDataObserver = new DataObserver();
    private float mLastY = -1.0f;
    private static final float DRAG_RATE = 3.0f;
    private LRecyclerViewAdapter mWrapAdapter;
    private boolean isNoMore = false;
    protected LayoutManagerType layoutManagerType;
    private int[] lastPositions;
    private int lastVisibleItemPosition;
    private int currentScrollState = 0;
    private static final int HIDE_THRESHOLD = 20;
    private int mDistance = 0;
    private boolean mIsScrollDown = true;
    private int mScrolledYDistance = 0;
    private int mScrolledXDistance = 0;
    public static final int LEFT_DIRECTION = 1;
    public static final int RIGHT_DIRECTION = -1;
    private static final int INVALID_POSITION = -1;
    private int mDownX;
    private int mDownY;
    private boolean isSwiebeEnable = true;
    protected ViewConfiguration mViewConfig;
    protected SwipeMenuLayout mOldSwipedLayout;
    protected int mOldTouchedPosition = -1;
    private SwipeMenuCreator mSwipeMenuCreator;
    private OnSwipeMenuItemClickListener mSwipeMenuItemClickListener;
    private DefaultItemTouchHelper mDefaultItemTouchHelper;
    private boolean isViewpagerMode = false;
    private float mTriggerOffset = 0.25f;
    private float mFlingFactor = 0.15f;
    private float mTouchSpan;
    private List<OnPageChangedListener> mOnPageChangedListeners;
    private int mSmoothScrollTargetPosition = -1;
    private int mPositionBeforeScroll = -1;
    private boolean mSinglePageFling;
    boolean mNeedAdjust;
    int mFisrtLeftWhenDragging;
    int mFirstTopWhenDragging;
    View mCurView;
    int mMaxLeftWhenDragging = Integer.MIN_VALUE;
    int mMinLeftWhenDragging = Integer.MAX_VALUE;
    int mMaxTopWhenDragging = Integer.MIN_VALUE;
    int mMinTopWhenDragging = Integer.MAX_VALUE;
    private int mPositionOnTouchDown = -1;
    private boolean mHasCalledOnPageChanged = true;
    private boolean reverseLayout = false;
    private int mRefreshHeaderHeight;
    private SwipeMenuCreator mDefaultMenuCreator = new SwipeMenuCreator(){

        @Override
        public void onCreateMenu(SwipeMenu swipeLeftMenu, SwipeMenu swipeRightMenu, int viewType) {
            if (LRecyclerView.this.mSwipeMenuCreator != null) {
                LRecyclerView.this.mSwipeMenuCreator.onCreateMenu(swipeLeftMenu, swipeRightMenu, viewType);
            }
        }
    };
    private OnSwipeMenuItemClickListener mDefaultMenuItemClickListener = new OnSwipeMenuItemClickListener(){

        @Override
        public void onItemClick(Closeable closeable, int adapterPosition, int menuPosition, int direction) {
            if (LRecyclerView.this.mSwipeMenuItemClickListener != null) {
                LRecyclerView.this.mSwipeMenuItemClickListener.onItemClick(closeable, adapterPosition, menuPosition, direction);
            }
        }
    };

    public LRecyclerView(Context context) {
        this(context, null);
    }

    public LRecyclerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LRecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mViewConfig = ViewConfiguration.get((Context)this.getContext());
        this.initAttrs(context, attrs, defStyle);
        this.setNestedScrollingEnabled(false);
    }

    private void initAttrs(Context context, AttributeSet attrs, int defStyle) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RecyclerViewPager, defStyle, 0);
        this.mFlingFactor = a.getFloat(R.styleable.RecyclerViewPager_rvp_flingFactor, 0.15f);
        this.mTriggerOffset = a.getFloat(R.styleable.RecyclerViewPager_rvp_triggerOffset, 0.25f);
        this.mSinglePageFling = a.getBoolean(R.styleable.RecyclerViewPager_rvp_singlePageFling, this.mSinglePageFling);
        a.recycle();
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        RecyclerView.Adapter oldAdapter = this.getAdapter();
        if (oldAdapter != null && this.mDataObserver != null) {
            oldAdapter.unregisterAdapterDataObserver(this.mDataObserver);
        }
        super.setAdapter(adapter);
        adapter.registerAdapterDataObserver(this.mDataObserver);
        this.mDataObserver.onChanged();
        this.mWrapAdapter = (LRecyclerViewAdapter)this.getAdapter();
        this.mRefreshHeader = this.mWrapAdapter.getRefreshHeader();
        if (this.mWrapAdapter.getInnerAdapter() instanceof SwipeMenuAdapter) {
            SwipeMenuAdapter menuAdapter = (SwipeMenuAdapter)this.mWrapAdapter.getInnerAdapter();
            menuAdapter.setSwipeMenuCreator(this.mDefaultMenuCreator);
            menuAdapter.setSwipeMenuItemClickListener(this.mDefaultMenuItemClickListener);
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mLastY == -1.0f) {
            this.mLastY = ev.getRawY();
        }
        switch (ev.getAction()) {
            case 0: {
                this.mLastY = ev.getRawY();
                if (this.mCurView == null) break;
                this.mMaxLeftWhenDragging = Math.max(this.mCurView.getLeft(), this.mMaxLeftWhenDragging);
                this.mMaxTopWhenDragging = Math.max(this.mCurView.getTop(), this.mMaxTopWhenDragging);
                this.mMinLeftWhenDragging = Math.min(this.mCurView.getLeft(), this.mMinLeftWhenDragging);
                this.mMinTopWhenDragging = Math.min(this.mCurView.getTop(), this.mMinTopWhenDragging);
                break;
            }
            case 2: {
                float deltaY = ev.getRawY() - this.mLastY;
                this.mLastY = ev.getRawY();
                if (this.isOnTop() && this.pullRefreshEnabled) {
                    this.mRefreshHeader.onMove(deltaY / 3.0f);
                    if (this.mRefreshHeader.getVisibleHeight() > 0 && this.mRefreshHeader.getState() < 2) {
                        return false;
                    }
                }
                if (!(this.mWrapAdapter.getInnerAdapter() instanceof SwipeMenuAdapter) || this.mOldSwipedLayout == null || !this.mOldSwipedLayout.isMenuOpen()) break;
                this.mOldSwipedLayout.smoothCloseMenu();
                break;
            }
            default: {
                this.mLastY = -1.0f;
                if (!this.isOnTop() || !this.pullRefreshEnabled || !this.mRefreshHeader.releaseAction() || this.mLScrollListener == null) break;
                this.mLScrollListener.onRefresh();
            }
        }
        return super.onTouchEvent(ev);
    }

    private int findMax(int[] lastPositions) {
        int max = lastPositions[0];
        for (int value : lastPositions) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    private int findMin(int[] firstPositions) {
        int min = firstPositions[0];
        for (int value : firstPositions) {
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    private boolean isOnTop() {
        return this.pullRefreshEnabled && this.mRefreshHeader.getParent() != null;
    }

    public void setEmptyView(View emptyView) {
        this.mEmptyView = emptyView;
    }

    public void refreshComplete() {
        this.mRefreshHeader.refreshComplete();
        this.setNoMore(false);
    }

    public void setNoMore(boolean noMore) {
        this.isNoMore = noMore;
    }

    public void setRefreshHeader(ArrowRefreshHeader refreshHeader) {
        this.mRefreshHeader = refreshHeader;
    }

    public void setPullRefreshEnabled(boolean enabled) {
        this.pullRefreshEnabled = enabled;
        if (this.mWrapAdapter != null) {
            this.mWrapAdapter.setPullRefreshEnabled(enabled);
        }
    }

    public void setRefreshProgressStyle(int style) {
        if (this.mRefreshHeader != null) {
            this.mRefreshHeader.setProgressStyle(style);
        }
    }

    public void setArrowImageView(int resId) {
        if (this.mRefreshHeader != null) {
            this.mRefreshHeader.setArrowImageView(resId);
        }
    }

    public void setLScrollListener(LScrollListener listener) {
        this.mLScrollListener = listener;
    }

    public void setRefreshing(boolean refreshing) {
        if (refreshing && this.pullRefreshEnabled && this.mLScrollListener != null) {
            this.mRefreshHeader.setState(2);
            this.mRefreshHeaderHeight = this.mRefreshHeader.getMeasuredHeight();
            this.mRefreshHeader.onMove(this.mRefreshHeaderHeight);
            this.mLScrollListener.onRefresh();
        }
    }

    public void forceToRefresh() {
        if (this.pullRefreshEnabled && this.mLScrollListener != null) {
            this.mRefreshHeader.setState(2);
            this.mRefreshHeader.onMove(this.mRefreshHeaderHeight);
            this.mLScrollListener.onRefresh();
        }
    }

    public void onScrolled(int dx, int dy) {
        super.onScrolled(dx, dy);
        if (null != this.mLScrollListener) {
            int firstVisibleItemPosition = 0;
            RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
            if (this.layoutManagerType == null) {
                if (layoutManager instanceof LinearLayoutManager) {
                    this.layoutManagerType = LayoutManagerType.LinearLayout;
                } else if (layoutManager instanceof GridLayoutManager) {
                    this.layoutManagerType = LayoutManagerType.GridLayout;
                } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                    this.layoutManagerType = LayoutManagerType.StaggeredGridLayout;
                } else {
                    throw new RuntimeException("Unsupported LayoutManager used. Valid ones are LinearLayoutManager, GridLayoutManager and StaggeredGridLayoutManager");
                }
            }
            switch (this.layoutManagerType) {
                case LinearLayout: {
                    firstVisibleItemPosition = ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
                    this.lastVisibleItemPosition = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
                    break;
                }
                case GridLayout: {
                    firstVisibleItemPosition = ((GridLayoutManager)layoutManager).findFirstVisibleItemPosition();
                    this.lastVisibleItemPosition = ((GridLayoutManager)layoutManager).findLastVisibleItemPosition();
                    break;
                }
                case StaggeredGridLayout: {
                    StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
                    if (this.lastPositions == null) {
                        this.lastPositions = new int[staggeredGridLayoutManager.getSpanCount()];
                    }
                    staggeredGridLayoutManager.findLastVisibleItemPositions(this.lastPositions);
                    this.lastVisibleItemPosition = this.findMax(this.lastPositions);
                    staggeredGridLayoutManager.findFirstCompletelyVisibleItemPositions(this.lastPositions);
                    firstVisibleItemPosition = this.findMax(this.lastPositions);
                }
            }
            this.calculateScrollUpOrDown(firstVisibleItemPosition, dy);
            this.mScrolledXDistance += dx;
            this.mScrolledYDistance += dy;
            this.mScrolledXDistance = this.mScrolledXDistance < 0 ? 0 : this.mScrolledXDistance;
            int n = this.mScrolledYDistance = this.mScrolledYDistance < 0 ? 0 : this.mScrolledYDistance;
            if (this.mIsScrollDown && dy == 0) {
                this.mScrolledYDistance = 0;
            }
            this.mLScrollListener.onScrolled(this.mScrolledXDistance, this.mScrolledYDistance);
        }
    }

    public void onScrollStateChanged(int state) {
        super.onScrollStateChanged(state);
        this.currentScrollState = state;
        if (!this.isViewpagerMode) {
            if (this.currentScrollState == 0 && this.mLScrollListener != null) {
                RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
                int visibleItemCount = layoutManager.getChildCount();
                int totalItemCount = layoutManager.getItemCount();
                if (visibleItemCount > 0 && this.lastVisibleItemPosition >= totalItemCount - 1 && totalItemCount > visibleItemCount && !this.isNoMore && !this.mIsScrollDown && this.mRefreshHeader.getState() < 2) {
                    this.mLScrollListener.onBottom();
                }
            }
        } else if (state == 1) {
            this.mNeedAdjust = true;
            View view = this.mCurView = this.getLayoutManager().canScrollHorizontally() ? ViewUtils.getCenterXChild(this) : ViewUtils.getCenterYChild(this);
            if (this.mCurView != null) {
                if (this.mHasCalledOnPageChanged) {
                    this.mPositionBeforeScroll = this.getChildLayoutPosition(this.mCurView);
                    this.mHasCalledOnPageChanged = false;
                }
                this.mFisrtLeftWhenDragging = this.mCurView.getLeft();
                this.mFirstTopWhenDragging = this.mCurView.getTop();
            } else {
                this.mPositionBeforeScroll = -1;
            }
            this.mTouchSpan = 0.0f;
        } else if (state == 2) {
            this.mNeedAdjust = false;
            this.mTouchSpan = this.mCurView != null ? (this.getLayoutManager().canScrollHorizontally() ? (float)(this.mCurView.getLeft() - this.mFisrtLeftWhenDragging) : (float)(this.mCurView.getTop() - this.mFirstTopWhenDragging)) : 0.0f;
            this.mCurView = null;
        } else if (state == 0) {
            if (this.mNeedAdjust) {
                int targetPosition;
                int n = targetPosition = this.getLayoutManager().canScrollHorizontally() ? ViewUtils.getCenterXChildPosition(this) : ViewUtils.getCenterYChildPosition(this);
                if (this.mCurView != null) {
                    targetPosition = this.getChildAdapterPosition(this.mCurView);
                    if (this.getLayoutManager().canScrollHorizontally()) {
                        int spanX = this.mCurView.getLeft() - this.mFisrtLeftWhenDragging;
                        if ((float)spanX > (float)this.mCurView.getWidth() * this.mTriggerOffset && this.mCurView.getLeft() >= this.mMaxLeftWhenDragging) {
                            targetPosition = !this.reverseLayout ? --targetPosition : ++targetPosition;
                        } else if ((float)spanX < (float)this.mCurView.getWidth() * -this.mTriggerOffset && this.mCurView.getLeft() <= this.mMinLeftWhenDragging) {
                            targetPosition = !this.reverseLayout ? ++targetPosition : --targetPosition;
                        }
                    } else {
                        int spanY = this.mCurView.getTop() - this.mFirstTopWhenDragging;
                        if ((float)spanY > (float)this.mCurView.getHeight() * this.mTriggerOffset && this.mCurView.getTop() >= this.mMaxTopWhenDragging) {
                            targetPosition = !this.reverseLayout ? --targetPosition : ++targetPosition;
                        } else if ((float)spanY < (float)this.mCurView.getHeight() * -this.mTriggerOffset && this.mCurView.getTop() <= this.mMinTopWhenDragging) {
                            targetPosition = !this.reverseLayout ? ++targetPosition : --targetPosition;
                        }
                    }
                }
                this.smoothScrollToPosition(this.safeTargetPosition(targetPosition, this.getItemCount()));
                this.mCurView = null;
            } else if (this.mSmoothScrollTargetPosition != this.mPositionBeforeScroll) {
                if (this.mOnPageChangedListeners != null) {
                    for (OnPageChangedListener onPageChangedListener : this.mOnPageChangedListeners) {
                        if (onPageChangedListener == null) continue;
                        onPageChangedListener.OnPageChanged(this.mPositionBeforeScroll, this.mSmoothScrollTargetPosition);
                    }
                }
                this.mHasCalledOnPageChanged = true;
                this.mPositionBeforeScroll = this.mSmoothScrollTargetPosition;
            }
            this.mMaxLeftWhenDragging = Integer.MIN_VALUE;
            this.mMinLeftWhenDragging = Integer.MAX_VALUE;
            this.mMaxTopWhenDragging = Integer.MIN_VALUE;
            this.mMinTopWhenDragging = Integer.MAX_VALUE;
        }
    }

    private void calculateScrollUpOrDown(int firstVisibleItemPosition, int dy) {
        if (firstVisibleItemPosition == 0) {
            if (!this.mIsScrollDown) {
                this.mIsScrollDown = true;
                this.mLScrollListener.onScrollDown();
            }
        } else if (this.mDistance > 20 && this.mIsScrollDown) {
            this.mIsScrollDown = false;
            this.mLScrollListener.onScrollUp();
            this.mDistance = 0;
        } else if (this.mDistance < -20 && !this.mIsScrollDown) {
            this.mIsScrollDown = true;
            this.mLScrollListener.onScrollDown();
            this.mDistance = 0;
        }
        if (this.mIsScrollDown && dy > 0 || !this.mIsScrollDown && dy < 0) {
            this.mDistance += dy;
        }
    }

    private void initializeItemTouchHelper() {
        if (this.mDefaultItemTouchHelper == null) {
            this.mDefaultItemTouchHelper = new DefaultItemTouchHelper();
            this.mDefaultItemTouchHelper.attachToRecyclerView(this);
        }
    }

    public void setOnItemMoveListener(OnItemMoveListener onItemMoveListener) {
        this.initializeItemTouchHelper();
        this.mDefaultItemTouchHelper.setOnItemMoveListener(onItemMoveListener);
    }

    public void setOnItemMovementListener(OnItemMovementListener onItemMovementListener) {
        this.initializeItemTouchHelper();
        this.mDefaultItemTouchHelper.setOnItemMovementListener(onItemMovementListener);
    }

    public void setLongPressDragEnabled(boolean canDrag) {
        this.initializeItemTouchHelper();
        this.mDefaultItemTouchHelper.setLongPressDragEnabled(canDrag);
    }

    public boolean isLongPressDragEnabled() {
        this.initializeItemTouchHelper();
        return this.mDefaultItemTouchHelper.isLongPressDragEnabled();
    }

    public void setItemViewSwipeEnabled(boolean canSwipe) {
        this.initializeItemTouchHelper();
        this.isSwiebeEnable = !canSwipe;
        this.mDefaultItemTouchHelper.setItemViewSwipeEnabled(canSwipe);
    }

    public boolean isItemViewSwipeEnabled() {
        this.initializeItemTouchHelper();
        return this.mDefaultItemTouchHelper.isItemViewSwipeEnabled();
    }

    public void startDrag(RecyclerView.ViewHolder viewHolder) {
        this.initializeItemTouchHelper();
        this.mDefaultItemTouchHelper.startDrag(viewHolder);
    }

    public void startSwipe(RecyclerView.ViewHolder viewHolder) {
        this.initializeItemTouchHelper();
        this.mDefaultItemTouchHelper.startSwipe(viewHolder);
    }

    public void setSwipeMenuCreator(SwipeMenuCreator swipeMenuCreator) {
        this.mSwipeMenuCreator = swipeMenuCreator;
    }

    public void setSwipeMenuItemClickListener(OnSwipeMenuItemClickListener swipeMenuItemClickListener) {
        this.mSwipeMenuItemClickListener = swipeMenuItemClickListener;
    }

    public void openLeftMenu(int position) {
        this.openMenu(position, 1, 200);
    }

    public void openLeftMenu(int position, int duration) {
        this.openMenu(position, 1, duration);
    }

    public void openRightMenu(int position) {
        this.openMenu(position, -1, 200);
    }

    public void openRightMenu(int position, int duration) {
        this.openMenu(position, -1, duration);
    }

    public void openMenu(int position, int direction, int duration) {
        View itemView;
        RecyclerView.ViewHolder vh;
        if (this.mOldSwipedLayout != null && this.mOldSwipedLayout.isMenuOpen()) {
            this.mOldSwipedLayout.smoothCloseMenu();
        }
        if ((vh = this.findViewHolderForAdapterPosition(position)) != null && (itemView = this.getSwipeMenuView(vh.itemView)) != null && itemView instanceof SwipeMenuLayout) {
            this.mOldSwipedLayout = (SwipeMenuLayout)itemView;
            if (direction == -1) {
                this.mOldTouchedPosition = position;
                this.mOldSwipedLayout.smoothOpenRightMenu(duration);
            } else if (direction == 1) {
                this.mOldTouchedPosition = position;
                this.mOldSwipedLayout.smoothOpenLeftMenu(duration);
            }
        }
    }

    private View getSwipeMenuView(View itemView) {
        if (itemView instanceof SwipeMenuLayout) {
            return itemView;
        }
        ArrayList<View> unvisited = new ArrayList<View>();
        unvisited.add(itemView);
        while (!unvisited.isEmpty()) {
            View child = (View)unvisited.remove(0);
            if (!(child instanceof ViewGroup)) continue;
            if (child instanceof SwipeMenuLayout) {
                return child;
            }
            ViewGroup group = (ViewGroup)child;
            int childCount = group.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                unvisited.add(group.getChildAt(i));
            }
        }
        return itemView;
    }

    public boolean onInterceptTouchEvent(MotionEvent e) {
        boolean isIntercepted = super.onInterceptTouchEvent(e);
        if (this.isSwiebeEnable) {
            if (e.getPointerCount() > 1) {
                return true;
            }
            int action = e.getAction();
            int x = (int)e.getX();
            int y = (int)e.getY();
            switch (action) {
                case 0: {
                    View itemView;
                    this.mDownX = x;
                    this.mDownY = y;
                    isIntercepted = false;
                    int touchingPosition = this.getChildAdapterPosition(this.findChildViewUnder(x, y));
                    if (touchingPosition != this.mOldTouchedPosition && this.mOldSwipedLayout != null && this.mOldSwipedLayout.isMenuOpen()) {
                        this.mOldSwipedLayout.smoothCloseMenu();
                        isIntercepted = true;
                    }
                    if (isIntercepted) {
                        this.mOldSwipedLayout = null;
                        this.mOldTouchedPosition = -1;
                        break;
                    }
                    RecyclerView.ViewHolder vh = this.findViewHolderForAdapterPosition(touchingPosition);
                    if (vh == null || (itemView = this.getSwipeMenuView(vh.itemView)) == null || !(itemView instanceof SwipeMenuLayout)) break;
                    this.mOldSwipedLayout = (SwipeMenuLayout)itemView;
                    this.mOldTouchedPosition = touchingPosition;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    isIntercepted = this.handleUnDown(x, y, isIntercepted);
                }
            }
        }
        return isIntercepted;
    }

    private boolean handleUnDown(int x, int y, boolean defaultValue) {
        int disX = this.mDownX - x;
        int disY = this.mDownY - y;
        if (Math.abs(disX) > this.mViewConfig.getScaledTouchSlop()) {
            defaultValue = false;
        }
        if (Math.abs(disY) < this.mViewConfig.getScaledTouchSlop() && Math.abs(disX) < this.mViewConfig.getScaledTouchSlop()) {
            defaultValue = false;
        }
        return defaultValue;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        try {
            Field fLayoutState = state.getClass().getDeclaredField("mLayoutState");
            fLayoutState.setAccessible(true);
            Object layoutState = fLayoutState.get(state);
            Field fAnchorOffset = layoutState.getClass().getDeclaredField("mAnchorOffset");
            Field fAnchorPosition = layoutState.getClass().getDeclaredField("mAnchorPosition");
            fAnchorPosition.setAccessible(true);
            fAnchorOffset.setAccessible(true);
            if (fAnchorOffset.getInt(layoutState) > 0) {
                fAnchorPosition.set(layoutState, fAnchorPosition.getInt(layoutState) - 1);
            } else if (fAnchorOffset.getInt(layoutState) < 0) {
                fAnchorPosition.set(layoutState, fAnchorPosition.getInt(layoutState) + 1);
            }
            fAnchorOffset.setInt(layoutState, 0);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        super.onRestoreInstanceState(state);
    }

    public void setLayoutManager(RecyclerView.LayoutManager layout2) {
        super.setLayoutManager(layout2);
        if (layout2 instanceof LinearLayoutManager) {
            this.reverseLayout = ((LinearLayoutManager)layout2).getReverseLayout();
        }
    }

    public boolean fling(int velocityX, int velocityY) {
        if (this.isViewpagerMode) {
            boolean flinging = super.fling((int)((float)velocityX * this.mFlingFactor), (int)((float)velocityY * this.mFlingFactor));
            if (flinging) {
                if (this.getLayoutManager().canScrollHorizontally()) {
                    this.adjustPositionX(velocityX);
                } else {
                    this.adjustPositionY(velocityY);
                }
            }
            return flinging;
        }
        return super.fling(velocityX, velocityY);
    }

    public void smoothScrollToPosition(int position) {
        this.mSmoothScrollTargetPosition = position;
        if (this.getLayoutManager() != null && this.getLayoutManager() instanceof LinearLayoutManager && this.isViewpagerMode) {
            LinearSmoothScroller linearSmoothScroller = new LinearSmoothScroller(this.getContext()){

                public PointF computeScrollVectorForPosition(int targetPosition) {
                    if (this.getLayoutManager() == null) {
                        return null;
                    }
                    return ((LinearLayoutManager)this.getLayoutManager()).computeScrollVectorForPosition(targetPosition);
                }

                protected void onTargetFound(View targetView, RecyclerView.State state, RecyclerView.SmoothScroller.Action action) {
                    if (this.getLayoutManager() == null) {
                        return;
                    }
                    int dx = this.calculateDxToMakeVisible(targetView, this.getHorizontalSnapPreference());
                    int dy = this.calculateDyToMakeVisible(targetView, this.getVerticalSnapPreference());
                    dx = dx > 0 ? (dx -= this.getLayoutManager().getLeftDecorationWidth(targetView)) : (dx += this.getLayoutManager().getRightDecorationWidth(targetView));
                    dy = dy > 0 ? (dy -= this.getLayoutManager().getTopDecorationHeight(targetView)) : (dy += this.getLayoutManager().getBottomDecorationHeight(targetView));
                    int distance = (int)Math.sqrt(dx * dx + dy * dy);
                    int time = this.calculateTimeForDeceleration(distance);
                    if (time > 0) {
                        action.update(-dx, -dy, time, (Interpolator)this.mDecelerateInterpolator);
                    }
                }
            };
            linearSmoothScroller.setTargetPosition(position);
            if (position == -1) {
                return;
            }
            this.getLayoutManager().startSmoothScroll((RecyclerView.SmoothScroller)linearSmoothScroller);
        } else {
            super.smoothScrollToPosition(position);
        }
    }

    public void scrollToPosition(int position) {
        this.mPositionBeforeScroll = this.getCurrentPosition();
        this.mSmoothScrollTargetPosition = position;
        super.scrollToPosition(position);
        if (this.isViewpagerMode) {
            this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    if (Build.VERSION.SDK_INT < 16) {
                        LRecyclerView.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        LRecyclerView.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                    if (LRecyclerView.this.mSmoothScrollTargetPosition >= 0 && LRecyclerView.this.mSmoothScrollTargetPosition < LRecyclerView.this.getItemCount() && LRecyclerView.this.mOnPageChangedListeners != null) {
                        for (OnPageChangedListener onPageChangedListener : LRecyclerView.this.mOnPageChangedListeners) {
                            if (onPageChangedListener == null) continue;
                            onPageChangedListener.OnPageChanged(LRecyclerView.this.mPositionBeforeScroll, LRecyclerView.this.getCurrentPosition());
                        }
                    }
                }
            });
        }
    }

    private int getItemCount() {
        return this.mWrapAdapter.getItemCount();
    }

    public int getCurrentPosition() {
        int curPosition = this.getLayoutManager().canScrollHorizontally() ? ViewUtils.getCenterXChildPosition(this) : ViewUtils.getCenterYChildPosition(this);
        if (curPosition < 0) {
            curPosition = this.mSmoothScrollTargetPosition;
        }
        return curPosition;
    }

    protected void adjustPositionX(int velocityX) {
        int childCount;
        if (this.reverseLayout) {
            velocityX *= -1;
        }
        if ((childCount = this.getChildCount()) > 0) {
            View centerXChild;
            int curPosition = ViewUtils.getCenterXChildPosition(this);
            int childWidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
            int flingCount = this.getFlingCount(velocityX, childWidth);
            int targetPosition = curPosition + flingCount;
            if (this.mSinglePageFling) {
                targetPosition = (flingCount = Math.max(-1, Math.min(1, flingCount))) == 0 ? curPosition : this.mPositionOnTouchDown + flingCount;
            }
            targetPosition = Math.max(targetPosition, 0);
            if (!((targetPosition = Math.min(targetPosition, this.getItemCount() - 1)) != curPosition || this.mSinglePageFling && this.mPositionOnTouchDown != curPosition || (centerXChild = ViewUtils.getCenterXChild(this)) == null)) {
                if (this.mTouchSpan > (float)centerXChild.getWidth() * this.mTriggerOffset * this.mTriggerOffset && targetPosition != 0) {
                    targetPosition = !this.reverseLayout ? --targetPosition : ++targetPosition;
                } else if (this.mTouchSpan < (float)centerXChild.getWidth() * -this.mTriggerOffset && targetPosition != this.getItemCount() - 1) {
                    targetPosition = !this.reverseLayout ? ++targetPosition : --targetPosition;
                }
            }
            this.smoothScrollToPosition(this.safeTargetPosition(targetPosition, this.getItemCount()));
        }
    }

    public void addOnPageChangedListener(OnPageChangedListener listener) {
        if (this.mOnPageChangedListeners == null) {
            this.mOnPageChangedListeners = new ArrayList<OnPageChangedListener>();
        }
        this.mOnPageChangedListeners.add(listener);
    }

    public void removeOnPageChangedListener(OnPageChangedListener listener) {
        if (this.mOnPageChangedListeners != null) {
            this.mOnPageChangedListeners.remove(listener);
        }
    }

    public void clearOnPageChangedListeners() {
        if (this.mOnPageChangedListeners != null) {
            this.mOnPageChangedListeners.clear();
        }
    }

    protected void adjustPositionY(int velocityY) {
        int childCount;
        if (this.reverseLayout) {
            velocityY *= -1;
        }
        if ((childCount = this.getChildCount()) > 0) {
            View centerYChild;
            int curPosition = ViewUtils.getCenterYChildPosition(this);
            int childHeight = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
            int flingCount = this.getFlingCount(velocityY, childHeight);
            int targetPosition = curPosition + flingCount;
            if (this.mSinglePageFling) {
                targetPosition = (flingCount = Math.max(-1, Math.min(1, flingCount))) == 0 ? curPosition : this.mPositionOnTouchDown + flingCount;
            }
            targetPosition = Math.max(targetPosition, 0);
            if (!((targetPosition = Math.min(targetPosition, this.getItemCount() - 1)) != curPosition || this.mSinglePageFling && this.mPositionOnTouchDown != curPosition || (centerYChild = ViewUtils.getCenterYChild(this)) == null)) {
                if (this.mTouchSpan > (float)centerYChild.getHeight() * this.mTriggerOffset && targetPosition != 0) {
                    targetPosition = !this.reverseLayout ? --targetPosition : ++targetPosition;
                } else if (this.mTouchSpan < (float)centerYChild.getHeight() * -this.mTriggerOffset && targetPosition != this.getItemCount() - 1) {
                    targetPosition = !this.reverseLayout ? ++targetPosition : --targetPosition;
                }
            }
            this.smoothScrollToPosition(this.safeTargetPosition(targetPosition, this.getItemCount()));
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.isViewpagerMode && ev.getAction() == 0 && this.getLayoutManager() != null) {
            this.mPositionOnTouchDown = this.getLayoutManager().canScrollHorizontally() ? ViewUtils.getCenterXChildPosition(this) : ViewUtils.getCenterYChildPosition(this);
        }
        return super.dispatchTouchEvent(ev);
    }

    private int getFlingCount(int velocity, int cellSize) {
        if (velocity == 0) {
            return 0;
        }
        int sign = velocity > 0 ? 1 : -1;
        return (int)((double)sign * Math.ceil((float)(velocity * sign) * this.mFlingFactor / (float)cellSize - this.mTriggerOffset));
    }

    private int safeTargetPosition(int position, int count) {
        if (position < 0) {
            return 0;
        }
        if (position >= count) {
            return count - 1;
        }
        return position;
    }

    public void setViewPagerMode(boolean isViewpagerMode) {
        this.isViewpagerMode = isViewpagerMode;
    }

    public static interface OnPageChangedListener {
        public void OnPageChanged(int var1, int var2);
    }

    public static enum LayoutManagerType {
        LinearLayout,
        StaggeredGridLayout,
        GridLayout;

    }

    public static interface LScrollListener {
        public void onRefresh();

        public void onScrollUp();

        public void onScrollDown();

        public void onBottom();

        public void onScrolled(int var1, int var2);
    }

    private class DataObserver
    extends RecyclerView.AdapterDataObserver {
        private DataObserver() {
        }

        public void onChanged() {
            RecyclerView.Adapter adapter = LRecyclerView.this.getAdapter();
            if (adapter instanceof LRecyclerViewAdapter) {
                LRecyclerViewAdapter headerAndFooterAdapter = (LRecyclerViewAdapter)adapter;
                if (headerAndFooterAdapter.getInnerAdapter() != null && LRecyclerView.this.mEmptyView != null) {
                    int count = headerAndFooterAdapter.getInnerAdapter().getItemCount();
                    if (count == 0) {
                        LRecyclerView.this.mEmptyView.setVisibility(0);
                        LRecyclerView.this.setVisibility(8);
                    } else {
                        LRecyclerView.this.mEmptyView.setVisibility(8);
                        LRecyclerView.this.setVisibility(0);
                    }
                }
            } else if (adapter != null && LRecyclerView.this.mEmptyView != null) {
                if (adapter.getItemCount() == 0) {
                    LRecyclerView.this.mEmptyView.setVisibility(0);
                    LRecyclerView.this.setVisibility(8);
                } else {
                    LRecyclerView.this.mEmptyView.setVisibility(8);
                    LRecyclerView.this.setVisibility(0);
                }
            }
        }
    }
}

