/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.view.View;
import com.github.jdsjlzx.interfaces.BaseRefreshHeader;

public class JellyView
extends View
implements BaseRefreshHeader {
    Path path;
    Paint paint;
    private int minimumHeight = 0;
    private int jellyHeight = 0;

    public JellyView(Context context) {
        super(context);
        this.init();
    }

    public JellyView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public JellyView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @TargetApi(value=21)
    public JellyView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        if (this.isInEditMode()) {
            return;
        }
        this.path = new Path();
        this.paint = new Paint();
        this.paint.setColor(this.getContext().getResources().getColor(17170459));
        this.paint.setAntiAlias(true);
    }

    public void setJellyColor(int jellyColor) {
        this.paint.setColor(jellyColor);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.path.reset();
        this.path.lineTo(0.0f, (float)this.minimumHeight);
        this.path.quadTo((float)(this.getMeasuredWidth() / 2), (float)(this.minimumHeight + this.jellyHeight), (float)this.getMeasuredWidth(), (float)this.minimumHeight);
        this.path.lineTo((float)this.getMeasuredWidth(), 0.0f);
        canvas.drawPath(this.path, this.paint);
    }

    public void setMinimumHeight(int minimumHeight) {
        this.minimumHeight = minimumHeight;
    }

    public void setJellyHeight(int ribbonHeight) {
        this.jellyHeight = ribbonHeight;
    }

    public int getMinimumHeight() {
        return this.minimumHeight;
    }

    public int getJellyHeight() {
        return this.jellyHeight;
    }

    @Override
    public void refreshComplete() {
    }

    @Override
    public void onMove(float delta) {
        this.jellyHeight += (int)delta;
        this.invalidate();
    }

    @Override
    public boolean releaseAction() {
        return false;
    }
}

