/*
 * Decompiled with CFR 0.152.
 */
package com.github.jdsjlzx.ItemDecoration;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.github.jdsjlzx.ItemDecoration.StickyHeaderAdapter;
import java.util.HashMap;
import java.util.Map;

public class StickyHeaderDecoration
extends RecyclerView.ItemDecoration {
    private Map<Long, RecyclerView.ViewHolder> mHeaderCache;
    private StickyHeaderAdapter mAdapter;
    private boolean mRenderInline;

    public StickyHeaderDecoration(StickyHeaderAdapter adapter) {
        this(adapter, false);
    }

    public StickyHeaderDecoration(StickyHeaderAdapter adapter, boolean renderInline) {
        this.mAdapter = adapter;
        this.mHeaderCache = new HashMap<Long, RecyclerView.ViewHolder>();
        this.mRenderInline = renderInline;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        int position = parent.getChildAdapterPosition(view);
        int headerHeight = 0;
        if (position != -1 && this.hasHeader(position)) {
            View header = this.getHeader((RecyclerView)parent, (int)position).itemView;
            headerHeight = this.getHeaderHeightForLayout(header);
        }
        outRect.set(0, headerHeight, 0, 0);
    }

    public void clearHeaderCache() {
        this.mHeaderCache.clear();
    }

    public View findHeaderViewUnder(float x, float y) {
        for (RecyclerView.ViewHolder holder : this.mHeaderCache.values()) {
            View child = holder.itemView;
            float translationX = ViewCompat.getTranslationX((View)child);
            float translationY = ViewCompat.getTranslationY((View)child);
            if (!(x >= (float)child.getLeft() + translationX) || !(x <= (float)child.getRight() + translationX) || !(y >= (float)child.getTop() + translationY) || !(y <= (float)child.getBottom() + translationY)) continue;
            return child;
        }
        return null;
    }

    private boolean hasHeader(int position) {
        if (position == 0) {
            return true;
        }
        int previous = position - 1;
        return this.mAdapter.getHeaderId(position) != this.mAdapter.getHeaderId(previous);
    }

    private RecyclerView.ViewHolder getHeader(RecyclerView parent, int position) {
        long key = this.mAdapter.getHeaderId(position);
        if (this.mHeaderCache.containsKey(key)) {
            return this.mHeaderCache.get(key);
        }
        Object holder = this.mAdapter.onCreateHeaderViewHolder((ViewGroup)parent);
        View header = ((RecyclerView.ViewHolder)holder).itemView;
        this.mAdapter.onBindHeaderViewHolder(holder, position);
        int widthSpec = View.MeasureSpec.makeMeasureSpec((int)parent.getWidth(), (int)0x40000000);
        int heightSpec = View.MeasureSpec.makeMeasureSpec((int)parent.getHeight(), (int)0);
        int childWidth = ViewGroup.getChildMeasureSpec((int)widthSpec, (int)(parent.getPaddingLeft() + parent.getPaddingRight()), (int)header.getLayoutParams().width);
        int childHeight = ViewGroup.getChildMeasureSpec((int)heightSpec, (int)(parent.getPaddingTop() + parent.getPaddingBottom()), (int)header.getLayoutParams().height);
        header.measure(childWidth, childHeight);
        header.layout(0, 0, header.getMeasuredWidth(), header.getMeasuredHeight());
        this.mHeaderCache.put(key, (RecyclerView.ViewHolder)holder);
        return holder;
    }

    public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
        int count = parent.getChildCount();
        for (int layoutPos = 0; layoutPos < count; ++layoutPos) {
            View child = parent.getChildAt(layoutPos);
            int adapterPos = parent.getChildAdapterPosition(child);
            if (adapterPos == -1 || layoutPos != 0 && !this.hasHeader(adapterPos)) continue;
            View header = this.getHeader((RecyclerView)parent, (int)adapterPos).itemView;
            c.save();
            int left = child.getLeft();
            int top = this.getHeaderTop(parent, child, header, adapterPos, layoutPos);
            c.translate((float)left, (float)top);
            header.setTranslationX((float)left);
            header.setTranslationY((float)top);
            header.draw(c);
            c.restore();
        }
    }

    private int getHeaderTop(RecyclerView parent, View child, View header, int adapterPos, int layoutPos) {
        int headerHeight = this.getHeaderHeightForLayout(header);
        int top = (int)child.getY() - headerHeight;
        if (layoutPos == 0) {
            int count = parent.getChildCount();
            long currentId = this.mAdapter.getHeaderId(adapterPos);
            for (int i = 1; i < count; ++i) {
                long nextId;
                int adapterPosHere = parent.getChildAdapterPosition(parent.getChildAt(i));
                if (adapterPosHere == -1 || (nextId = this.mAdapter.getHeaderId(adapterPosHere)) == currentId) continue;
                View next = parent.getChildAt(i);
                int offset = (int)next.getY() - (headerHeight + this.getHeader((RecyclerView)parent, (int)adapterPosHere).itemView.getHeight());
                if (offset >= 0) break;
                return offset;
            }
            top = Math.max(0, top);
        }
        return top;
    }

    private int getHeaderHeightForLayout(View header) {
        return this.mRenderInline ? 0 : header.getHeight();
    }
}

