/*
 * Decompiled with CFR 0.152.
 */
package com.cundong.recyclerview.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.cundong.recyclerview.R;
import com.cundong.recyclerview.progressindicator.AVLoadingIndicatorView;

public class LoadingFooter
extends RelativeLayout {
    protected State mState = State.Normal;
    private View mLoadingView;
    private View mNetworkErrorView;
    private View mTheEndView;
    private AVLoadingIndicatorView mLoadingProgress;
    private TextView mLoadingText;

    public LoadingFooter(Context context) {
        super(context);
        this.init(context);
    }

    public LoadingFooter(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public LoadingFooter(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public void init(Context context) {
        LoadingFooter.inflate((Context)context, (int)R.layout.layout_recyclerview_list_footer, (ViewGroup)this);
        this.setOnClickListener(null);
        this.setState(State.Normal, true);
    }

    public State getState() {
        return this.mState;
    }

    public void setState(State status) {
        this.setState(status, true);
    }

    public void setState(State status, boolean showView) {
        if (this.mState == status) {
            return;
        }
        this.mState = status;
        switch (status) {
            case Normal: {
                this.setOnClickListener(null);
                if (this.mLoadingView != null) {
                    this.mLoadingView.setVisibility(8);
                }
                if (this.mTheEndView != null) {
                    this.mTheEndView.setVisibility(8);
                }
                if (this.mNetworkErrorView == null) break;
                this.mNetworkErrorView.setVisibility(8);
                break;
            }
            case Loading: {
                this.setOnClickListener(null);
                if (this.mTheEndView != null) {
                    this.mTheEndView.setVisibility(8);
                }
                if (this.mNetworkErrorView != null) {
                    this.mNetworkErrorView.setVisibility(8);
                }
                if (this.mLoadingView == null) {
                    ViewStub viewStub = (ViewStub)this.findViewById(R.id.loading_viewstub);
                    this.mLoadingView = viewStub.inflate();
                    this.mLoadingProgress = (AVLoadingIndicatorView)this.mLoadingView.findViewById(R.id.loading_progress);
                    this.mLoadingText = (TextView)this.mLoadingView.findViewById(R.id.loading_text);
                } else {
                    this.mLoadingView.setVisibility(0);
                }
                this.mLoadingView.setVisibility(showView ? 0 : 8);
                this.mLoadingProgress.setVisibility(0);
                this.mLoadingText.setText(R.string.list_footer_loading);
                break;
            }
            case TheEnd: {
                this.setOnClickListener(null);
                if (this.mLoadingView != null) {
                    this.mLoadingView.setVisibility(8);
                }
                if (this.mNetworkErrorView != null) {
                    this.mNetworkErrorView.setVisibility(8);
                }
                if (this.mTheEndView == null) {
                    ViewStub viewStub = (ViewStub)this.findViewById(R.id.end_viewstub);
                    this.mTheEndView = viewStub.inflate();
                } else {
                    this.mTheEndView.setVisibility(0);
                }
                this.mTheEndView.setVisibility(showView ? 0 : 8);
                break;
            }
            case NetWorkError: {
                if (this.mLoadingView != null) {
                    this.mLoadingView.setVisibility(8);
                }
                if (this.mTheEndView != null) {
                    this.mTheEndView.setVisibility(8);
                }
                if (this.mNetworkErrorView == null) {
                    ViewStub viewStub = (ViewStub)this.findViewById(R.id.network_error_viewstub);
                    this.mNetworkErrorView = viewStub.inflate();
                } else {
                    this.mNetworkErrorView.setVisibility(0);
                }
                this.mNetworkErrorView.setVisibility(showView ? 0 : 8);
                break;
            }
        }
    }

    public static enum State {
        Normal,
        TheEnd,
        Loading,
        NetWorkError;

    }
}

