/*
 * Decompiled with CFR 0.152.
 */
package com.cundong.recyclerview.util;

import android.app.Activity;
import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.cundong.recyclerview.HeaderAndFooterRecyclerViewAdapter;
import com.cundong.recyclerview.view.LoadingFooter;

public class RecyclerViewStateUtils {
    public static void setFooterViewState(Activity instance, RecyclerView recyclerView, int pageSize, LoadingFooter.State state, View.OnClickListener errorListener) {
        if (instance == null || instance.isFinishing()) {
            return;
        }
        RecyclerView.Adapter outerAdapter = recyclerView.getAdapter();
        if (outerAdapter == null || !(outerAdapter instanceof HeaderAndFooterRecyclerViewAdapter)) {
            return;
        }
        HeaderAndFooterRecyclerViewAdapter headerAndFooterAdapter = (HeaderAndFooterRecyclerViewAdapter)outerAdapter;
        if (headerAndFooterAdapter.getInnerAdapter().getItemCount() < pageSize) {
            return;
        }
        if (headerAndFooterAdapter.getFooterViewsCount() > 0) {
            LoadingFooter footerView = (LoadingFooter)headerAndFooterAdapter.getFooterView();
            footerView.setState(state);
            if (state == LoadingFooter.State.NetWorkError) {
                footerView.setOnClickListener(errorListener);
            }
            recyclerView.scrollToPosition(headerAndFooterAdapter.getItemCount() - 1);
        } else {
            LoadingFooter footerView = new LoadingFooter((Context)instance);
            footerView.setState(state);
            if (state == LoadingFooter.State.NetWorkError) {
                footerView.setOnClickListener(errorListener);
            }
            headerAndFooterAdapter.addFooterView((View)footerView);
            recyclerView.scrollToPosition(headerAndFooterAdapter.getItemCount() - 1);
        }
    }

    public static void setFooterViewState2(Activity instance, RecyclerView recyclerView, int pageSize, LoadingFooter.State state, View.OnClickListener errorListener) {
        if (instance == null || instance.isFinishing()) {
            return;
        }
        RecyclerView.Adapter outerAdapter = recyclerView.getAdapter();
        if (outerAdapter == null || !(outerAdapter instanceof HeaderAndFooterRecyclerViewAdapter)) {
            return;
        }
        HeaderAndFooterRecyclerViewAdapter headerAndFooterAdapter = (HeaderAndFooterRecyclerViewAdapter)outerAdapter;
        if (headerAndFooterAdapter.getFooterViewsCount() > 0) {
            LoadingFooter footerView = (LoadingFooter)headerAndFooterAdapter.getFooterView();
            footerView.setState(state);
            if (state == LoadingFooter.State.NetWorkError) {
                footerView.setOnClickListener(errorListener);
            }
            recyclerView.scrollToPosition(0);
        } else {
            LoadingFooter footerView = new LoadingFooter((Context)instance);
            footerView.setState(state);
            if (state == LoadingFooter.State.NetWorkError) {
                footerView.setOnClickListener(errorListener);
            }
            headerAndFooterAdapter.addFooterView((View)footerView);
            recyclerView.scrollToPosition(0);
        }
    }

    public static LoadingFooter.State getFooterViewState(RecyclerView recyclerView) {
        RecyclerView.Adapter outerAdapter = recyclerView.getAdapter();
        if (outerAdapter != null && outerAdapter instanceof HeaderAndFooterRecyclerViewAdapter && ((HeaderAndFooterRecyclerViewAdapter)outerAdapter).getFooterViewsCount() > 0) {
            LoadingFooter footerView = (LoadingFooter)((HeaderAndFooterRecyclerViewAdapter)outerAdapter).getFooterView();
            return footerView.getState();
        }
        return LoadingFooter.State.Normal;
    }

    public static void setFooterViewState(RecyclerView recyclerView, LoadingFooter.State state) {
        RecyclerView.Adapter outerAdapter = recyclerView.getAdapter();
        if (outerAdapter != null && outerAdapter instanceof HeaderAndFooterRecyclerViewAdapter && ((HeaderAndFooterRecyclerViewAdapter)outerAdapter).getFooterViewsCount() > 0) {
            LoadingFooter footerView = (LoadingFooter)((HeaderAndFooterRecyclerViewAdapter)outerAdapter).getFooterView();
            footerView.setState(state);
        }
    }
}

