/*
 * Decompiled with CFR 0.152.
 */
package com.cundong.recyclerview;

import android.content.Context;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;
import android.view.ViewGroup;
import com.cundong.recyclerview.interfaces.OnItemClickLitener;
import com.cundong.recyclerview.view.ArrowRefreshHeader;
import java.util.ArrayList;
import java.util.List;

public class HeaderAndFooterRecyclerViewAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int TYPE_REFRESH_HEADER = 10000;
    private static final int TYPE_NORMAL = 0;
    private static final int TYPE_FOOTER_VIEW = 10001;
    private static final int HEADER_INIT_INDEX = 10002;
    private static List<Integer> mHeaderTypes = new ArrayList<Integer>();
    private boolean pullRefreshEnabled = true;
    private int mRefreshProgressStyle = -1;
    private ArrowRefreshHeader mRefreshHeader;
    private RecyclerView.Adapter<RecyclerView.ViewHolder> mInnerAdapter;
    private ArrayList<View> mHeaderViews = new ArrayList();
    private ArrayList<View> mFooterViews = new ArrayList();
    private Context mContext;
    private OnItemClickLitener mOnItemClickLitener;
    private RecyclerView.AdapterDataObserver mDataObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            super.onChanged();
            HeaderAndFooterRecyclerViewAdapter.this.notifyDataSetChanged();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            HeaderAndFooterRecyclerViewAdapter.this.notifyItemRangeChanged(positionStart + HeaderAndFooterRecyclerViewAdapter.this.getHeaderViewsCount() + 1, itemCount);
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            HeaderAndFooterRecyclerViewAdapter.this.notifyItemRangeInserted(positionStart + HeaderAndFooterRecyclerViewAdapter.this.getHeaderViewsCount() + 1, itemCount);
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            HeaderAndFooterRecyclerViewAdapter.this.notifyItemRangeRemoved(positionStart + HeaderAndFooterRecyclerViewAdapter.this.getHeaderViewsCount() + 1, itemCount);
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            int headerViewsCountCount = HeaderAndFooterRecyclerViewAdapter.this.getHeaderViewsCount();
            HeaderAndFooterRecyclerViewAdapter.this.notifyItemRangeChanged(fromPosition + headerViewsCountCount + 1, toPosition + headerViewsCountCount + 1 + itemCount);
        }
    };

    public HeaderAndFooterRecyclerViewAdapter(Context context, RecyclerView.Adapter innerAdapter) {
        this.mContext = context;
        this.setRefreshHeader();
        this.setAdapter((RecyclerView.Adapter<RecyclerView.ViewHolder>)innerAdapter);
    }

    public void setRefreshHeader() {
        if (this.pullRefreshEnabled) {
            ArrowRefreshHeader refreshHeader = new ArrowRefreshHeader(this.mContext);
            refreshHeader.setProgressStyle(this.mRefreshProgressStyle);
            this.mRefreshHeader = refreshHeader;
        }
    }

    public ArrowRefreshHeader getRefreshHeader() {
        return this.mRefreshHeader;
    }

    public void setAdapter(RecyclerView.Adapter<RecyclerView.ViewHolder> adapter) {
        if (adapter != null && !(adapter instanceof RecyclerView.Adapter)) {
            throw new RuntimeException("your adapter must be a RecyclerView.Adapter");
        }
        if (this.mInnerAdapter != null) {
            this.notifyItemRangeRemoved(this.getHeaderViewsCount(), this.mInnerAdapter.getItemCount());
            this.mInnerAdapter.unregisterAdapterDataObserver(this.mDataObserver);
        }
        this.mInnerAdapter = adapter;
        this.mInnerAdapter.registerAdapterDataObserver(this.mDataObserver);
        this.notifyItemRangeInserted(this.getHeaderViewsCount(), this.mInnerAdapter.getItemCount());
    }

    public RecyclerView.Adapter getInnerAdapter() {
        return this.mInnerAdapter;
    }

    public void addHeaderView(View view) {
        if (view == null) {
            throw new RuntimeException("header is null");
        }
        mHeaderTypes.add(10002 + this.mHeaderViews.size());
        this.mHeaderViews.add(view);
    }

    public void addFooterView(View footer) {
        if (footer == null) {
            throw new RuntimeException("footer is null");
        }
        this.mFooterViews.add(footer);
        this.notifyDataSetChanged();
    }

    private View getHeaderViewByType(int itemType) {
        if (!this.isHeaderType(itemType)) {
            return null;
        }
        return this.mHeaderViews.get(itemType - 10002);
    }

    private boolean isHeaderType(int itemViewType) {
        return this.mHeaderViews.size() > 0 && mHeaderTypes.contains(itemViewType);
    }

    public View getFooterView() {
        return this.getFooterViewsCount() > 0 ? this.mFooterViews.get(0) : null;
    }

    public View getHeaderView() {
        return this.getHeaderViewsCount() > 0 ? this.mHeaderViews.get(0) : null;
    }

    public ArrayList<View> getHeaderViews() {
        return this.mHeaderViews;
    }

    public void removeHeaderView(View view) {
        this.mHeaderViews.remove(view);
        this.notifyDataSetChanged();
    }

    public void removeFooterView(View view) {
        this.mFooterViews.remove(view);
        this.notifyDataSetChanged();
    }

    public int getHeaderViewsCount() {
        return this.mHeaderViews.size();
    }

    public int getFooterViewsCount() {
        return this.mFooterViews.size();
    }

    public boolean isHeader(int position) {
        return position >= 1 && position < this.mHeaderViews.size() + 1;
    }

    public boolean isRefreshHeader(int position) {
        return position == 0;
    }

    public boolean isFooter(int position) {
        int lastPosition = this.getItemCount() - 1;
        return this.getFooterViewsCount() > 0 && position == lastPosition;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 10000) {
            return new ViewHolder((View)this.mRefreshHeader);
        }
        if (this.isHeaderType(viewType)) {
            return new ViewHolder(this.getHeaderViewByType(viewType));
        }
        if (viewType == 10001) {
            return new ViewHolder(this.mFooterViews.get(0));
        }
        return this.mInnerAdapter.onCreateViewHolder(parent, viewType);
    }

    public void onBindViewHolder(final RecyclerView.ViewHolder holder, int position) {
        int adapterCount;
        if (this.isHeader(position) || this.isRefreshHeader(position)) {
            return;
        }
        final int adjPosition = position - (this.getHeaderViewsCount() + 1);
        if (this.mInnerAdapter != null && adjPosition < (adapterCount = this.mInnerAdapter.getItemCount())) {
            this.mInnerAdapter.onBindViewHolder(holder, adjPosition);
            if (this.mOnItemClickLitener != null) {
                holder.itemView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        HeaderAndFooterRecyclerViewAdapter.this.mOnItemClickLitener.onItemClick(holder.itemView, adjPosition);
                    }
                });
                holder.itemView.setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View v) {
                        HeaderAndFooterRecyclerViewAdapter.this.mOnItemClickLitener.onItemLongClick(holder.itemView, adjPosition);
                        return false;
                    }
                });
            }
            return;
        }
    }

    public int getItemCount() {
        if (this.mInnerAdapter != null) {
            return this.getHeaderViewsCount() + this.getFooterViewsCount() + this.mInnerAdapter.getItemCount() + 1;
        }
        return this.getHeaderViewsCount() + this.getFooterViewsCount() + 1;
    }

    public int getItemViewType(int position) {
        int adapterCount;
        int adjPosition = position - (this.getHeaderViewsCount() + 1);
        if (this.isRefreshHeader(position)) {
            return 10000;
        }
        if (this.isHeader(position)) {
            return mHeaderTypes.get(--position);
        }
        if (this.isFooter(position)) {
            return 10001;
        }
        if (this.mInnerAdapter != null && adjPosition < (adapterCount = this.mInnerAdapter.getItemCount())) {
            return this.mInnerAdapter.getItemViewType(adjPosition);
        }
        return 0;
    }

    public long getItemId(int position) {
        int adapterCount;
        int adjPosition;
        if (this.mInnerAdapter != null && position >= this.getHeaderViewsCount() && (adjPosition = position - this.getHeaderViewsCount()) < (adapterCount = this.mInnerAdapter.getItemCount())) {
            return this.mInnerAdapter.getItemId(adjPosition);
        }
        return -1L;
    }

    public void setOnItemClickLitener(OnItemClickLitener mOnItemClickLitener) {
        this.mOnItemClickLitener = mOnItemClickLitener;
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        RecyclerView.LayoutManager manager = recyclerView.getLayoutManager();
        if (manager instanceof GridLayoutManager) {
            final GridLayoutManager gridManager = (GridLayoutManager)manager;
            gridManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    return HeaderAndFooterRecyclerViewAdapter.this.isHeader(position) || HeaderAndFooterRecyclerViewAdapter.this.isFooter(position) || HeaderAndFooterRecyclerViewAdapter.this.isRefreshHeader(position) ? gridManager.getSpanCount() : 1;
                }
            });
        }
        this.mInnerAdapter.onAttachedToRecyclerView(recyclerView);
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        this.mInnerAdapter.onDetachedFromRecyclerView(recyclerView);
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        super.onViewAttachedToWindow(holder);
        ViewGroup.LayoutParams lp = holder.itemView.getLayoutParams();
        if (lp != null && lp instanceof StaggeredGridLayoutManager.LayoutParams && (this.isHeader(holder.getLayoutPosition()) || this.isRefreshHeader(holder.getLayoutPosition()) || this.isFooter(holder.getLayoutPosition()))) {
            StaggeredGridLayoutManager.LayoutParams p = (StaggeredGridLayoutManager.LayoutParams)lp;
            p.setFullSpan(true);
        }
        this.mInnerAdapter.onViewAttachedToWindow(holder);
    }

    public void onViewDetachedFromWindow(RecyclerView.ViewHolder holder) {
        this.mInnerAdapter.onViewDetachedFromWindow(holder);
    }

    public void onViewRecycled(RecyclerView.ViewHolder holder) {
        this.mInnerAdapter.onViewRecycled(holder);
    }

    public boolean onFailedToRecycleView(RecyclerView.ViewHolder holder) {
        return this.mInnerAdapter.onFailedToRecycleView(holder);
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        public ViewHolder(View itemView) {
            super(itemView);
        }
    }
}

