/*
 * Decompiled with CFR 0.152.
 */
package com.jdpxiaoming.ffmpeg_cmd;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import com.jdpxiaoming.ffmpeg_cmd.FFmepgTask;
import com.jdpxiaoming.ffmpeg_cmd.FFmpegCmd;
import com.jdpxiaoming.ffmpeg_cmd.FLog;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class FFmpegUtil
implements Handler.Callback {
    private static final String TAG = "FFmpegUtil";
    private static volatile FFmpegUtil mInstance;
    private static final int MSG_ON_START = 1;
    private static final int MSG_ON_FAILURE = 2;
    private static final int MSG_ON_PROGRESS = 3;
    private static final int MSG_ON_COMPLETE = 4;
    private static final int MSG_ON_CANCEL_FINISH = 5;
    private static final int MSG_ON_ERROR = 257;
    private Handler mHandler;
    private onCallBack mCallbackListener;
    private LinkedBlockingQueue<FFmepgTask> mAsynTaskQueue = new LinkedBlockingQueue();
    private ExecutorService mThreadPoolService = Executors.newFixedThreadPool(1);
    private boolean isRunning = false;
    private FFmepgTask mCurrentTask = null;
    private Object mLock = null;
    private Runnable mReadThread = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                if (!FFmpegUtil.this.isRunning) break;
                try {
                    Object object = FFmpegUtil.this.mLock;
                    synchronized (object) {
                        FFmpegUtil.this.mCurrentTask = (FFmepgTask)FFmpegUtil.this.mAsynTaskQueue.take();
                        if (null != FFmpegUtil.this.mCurrentTask) {
                            FFmpegUtil.this.exec(FFmpegUtil.this.mCurrentTask.getCmds(), FFmpegUtil.this.mCurrentTask.getDuration(), ((FFmpegUtil)FFmpegUtil.this).mCurrentTask.callBacklistener);
                        }
                        FFmpegUtil.this.mLock.wait();
                        continue;
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            FLog.e(FFmpegUtil.TAG, "mReadThread stop isRunning is false !");
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FFmpegUtil getInstance() {
        if (null != mInstance) return mInstance;
        Class<FFmpegUtil> clazz = FFmpegUtil.class;
        synchronized (FFmpegUtil.class) {
            if (null != mInstance) return mInstance;
            mInstance = new FFmpegUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private FFmpegUtil() {
        if (null == this.mHandler) {
            this.mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
        }
        this.mLock = new Object();
        this.isRunning = true;
        this.mThreadPoolService.execute(this.mReadThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTask() {
        this.isRunning = false;
        this.mAsynTaskQueue.clear();
        Object object = this.mLock;
        synchronized (object) {
            this.mLock.notifyAll();
        }
        FFmpegCmd.exit();
    }

    public void onDestroy() {
        this.isRunning = false;
        this.mThreadPoolService.shutdown();
        try {
            if (!this.mThreadPoolService.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                this.mThreadPoolService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void enQueueTask(String[] cmds, long duration, onCallBack listener) {
        Log.e((String)TAG, (String)"enQueueTask()");
        long id = SystemClock.currentThreadTimeMillis();
        FFmepgTask task = new FFmepgTask(id, duration, cmds, listener);
        this.mAsynTaskQueue.add(task);
        if (!this.isRunning) {
            this.isRunning = true;
            this.mThreadPoolService.execute(this.mReadThread);
        }
    }

    private void exec(String[] cmds, long duration, onCallBack listener) {
        FLog.e(TAG, "exec() ~FFmpegCmd.exec..... !");
        this.mCallbackListener = listener;
        FFmpegCmd.exec(cmds, duration, new FFmpegCmd.OnCmdExecListener(){

            @Override
            public void onSuccess() {
                FLog.i(FFmpegUtil.TAG, " onSuccess # ");
                if (null != FFmpegUtil.this.mHandler) {
                    FFmpegUtil.this.mHandler.sendEmptyMessage(1);
                }
            }

            @Override
            public void onFailure() {
                FLog.e(FFmpegUtil.TAG, " onFailure # ");
                if (null != FFmpegUtil.this.mHandler) {
                    FFmpegUtil.this.mHandler.sendEmptyMessage(2);
                }
            }

            @Override
            public void onComplete() {
                FLog.e(FFmpegUtil.TAG, " onComplete #mHandler~ ");
                if (null != FFmpegUtil.this.mHandler) {
                    FFmpegUtil.this.mHandler.sendEmptyMessage(4);
                }
            }

            @Override
            public void onProgress(float progress) {
                FLog.i(FFmpegUtil.TAG, " onProgress # ");
                if (null != FFmpegUtil.this.mHandler) {
                    FFmpegUtil.this.mHandler.sendMessage(FFmpegUtil.this.mHandler.obtainMessage(3, (Object)Float.valueOf(progress)));
                }
            }

            @Override
            public void onCancelFinish() {
                FLog.e(FFmpegUtil.TAG, " onCancelFinish #mHandler~ ");
                if (null != FFmpegUtil.this.mHandler) {
                    FFmpegUtil.this.mHandler.sendEmptyMessage(5);
                }
            }
        });
    }

    private void exec(String[] cmds, onCallBack listener) {
        this.exec(cmds, 0L, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            default: {
                FLog.i(TAG, " MSG_ON_START # ");
                if (null == this.mCallbackListener) break;
                this.mCallbackListener.onStart();
                break;
            }
            case 2: {
                FLog.i(TAG, " MSG_ON_FAILURE # ");
                Object object = this.mLock;
                synchronized (object) {
                    if (null != this.mCallbackListener) {
                        this.mCallbackListener.onFailure();
                    }
                    this.mLock.notifyAll();
                    break;
                }
            }
            case 3: {
                float currentTime = ((Float)msg.obj).floatValue();
                FLog.i(TAG, " onProgress # " + currentTime);
                if (null == this.mCallbackListener) break;
                this.mCallbackListener.onProgress(currentTime);
                break;
            }
            case 4: {
                FLog.i(TAG, " MSG_ON_COMPLETE # ");
                Object object = this.mLock;
                synchronized (object) {
                    if (null != this.mCallbackListener) {
                        this.mCallbackListener.onComplete();
                    }
                    this.mLock.notifyAll();
                    break;
                }
            }
            case 5: {
                FLog.i(TAG, " MSG_ON_COMPLETE # ");
                Object object = this.mLock;
                synchronized (object) {
                    this.mLock.notifyAll();
                    break;
                }
            }
        }
        return true;
    }

    public static interface onCallBack {
        public void onStart();

        public void onFailure();

        public void onComplete();

        public void onProgress(float var1);
    }
}

