/*
 * Decompiled with CFR 0.152.
 */
package com.jdpxiaoming.ffmpeg_cmd;

import android.util.Log;
import java.util.ArrayList;

public class FFmpegFactory {
    public static int screenWidth = 1280;
    public static int screenHeight = 720;
    public static int cameraWidth = 640;
    public static int cameraHeight = 360;
    public static int recodeWidth = 640;
    public static int recodeHeight = 360;
    public static int titlePicWidth = 200;
    public static int titlePicHeight = 100;
    public static int titleDuration = 3;

    public static String[] buildFlv2Mp4(String inputPath, String outputPath) {
        String[] commands = new String[]{"ffmpeg", "-i", inputPath, "-vcodec", "copy", "-acodec", "aac", outputPath};
        return commands;
    }

    public static String[] buildRtsp2Mp4(String inputPath, String outputPath) {
        String[] commands = new String[]{"ffmpeg", "-rtsp_transport", "tcp", "-i", inputPath, "-vcodec", "copy", "-tag:v", "hvc1", "-acodec", "aac", "-f", "mp4", "-y", outputPath};
        return commands;
    }

    public static String[] scaleVideo(String inputPath, String outputPath, int width, int height) {
        String[] commands = new String[]{"ffmpeg", "-i", inputPath, "-vf", "scale=" + width + ":" + height, outputPath};
        return commands;
    }

    public static String[] cutVideoGif(String inputPath, String outputPath, String duration, String fps, String wh) {
        String[] commands = new String[]{"ffmpeg", "-ss", "00:00:00", "-t", duration, "-i", inputPath, "-s", wh, "-r", fps, outputPath};
        return commands;
    }

    public static String[] cutVideoGif(String inputPath, String outputPath, String duration) {
        String[] commands = new String[]{"ffmpeg", "-ss", "00:00:00", "-t", duration, "-i", inputPath, outputPath};
        return commands;
    }

    public static String[] cutVideoTime(String path, int startTime, int endTime, String output) {
        int startM = startTime / 1000;
        int endM = (endTime - startTime) / 1000;
        String startStr = startM < 10 ? "00:00:0" + startM : "00:00:" + startM;
        String endStr = endM < 10 ? "00:00:0" + endM : "00:00:" + endM;
        String[] commands = new String[]{"ffmpeg", "-i", path, "-vcodec", "copy", "-acodec", "copy", "-ss", startStr, "-t", endStr, output};
        return commands;
    }

    public static String[] addWaterMark(String imageUrl, String videoUrl, String outputUrl) {
        String[] commands = new String[]{"ffmpeg", "-i", videoUrl, "-i", imageUrl, "-filter_complex", "overlay=(main_w-overlay_w)/2:(main_h-overlay_h)/2", "-y", outputUrl};
        return commands;
    }

    public static String[] addImageMark(String videoUrl, String imageUrl, String outputUrl) {
        String[] commands = new String[]{"ffmpeg", "-i", videoUrl, "-i", imageUrl, "-filter_complex", "[1:v]scale=" + screenWidth + ":" + screenHeight + "[s];[0:v][s]overlay=0:0", "-y", outputUrl};
        return commands;
    }

    public static String[] addImageMark(String videoUrl, String imageUrl, String outputUrl, int width, int height) {
        String[] commands = new String[]{"ffmpeg", "-i", videoUrl, "-i", imageUrl, "-filter_complex", "[1:v]scale=" + width + ":" + height + "[s];[0:v][s]overlay=0:0", "-y", outputUrl};
        return commands;
    }

    public static String[] addMusic(String videoUrl, String musicUrl, String outputUrl) {
        String[] commands = new String[]{"ffmpeg", "-i", videoUrl, "-i", musicUrl, "-y", outputUrl};
        return commands;
    }

    public static String[] addTextMark(String videoUrl, String imageUrl, String outputUrl) {
        ArrayList<String> _commands = new ArrayList<String>();
        _commands.add("ffmpeg");
        _commands.add("-i");
        _commands.add(videoUrl);
        _commands.add("-i");
        _commands.add(imageUrl);
        _commands.add("-filter_complex");
        _commands.add("overlay=(main_w-overlay_w)/2:(main_h-overlay_h)/2");
        _commands.add("-y");
        _commands.add(outputUrl);
        String[] commands = new String[_commands.size()];
        for (int i = 0; i < _commands.size(); ++i) {
            commands[i] = (String)_commands.get(i);
        }
        return commands;
    }

    public static String[] concatVideo(String _filePath, String _outPath) {
        ArrayList<String> _commands = new ArrayList<String>();
        _commands.add("ffmpeg");
        _commands.add("-f");
        _commands.add("concat");
        _commands.add("-i");
        _commands.add(_filePath);
        _commands.add("-c");
        _commands.add("copy");
        _commands.add(_outPath);
        String[] commands = new String[_commands.size()];
        String _pr = "";
        for (int i = 0; i < _commands.size(); ++i) {
            commands[i] = (String)_commands.get(i);
            _pr = _pr + commands[i];
        }
        Log.d((String)"LOGCAT", (String)("ffmpeg command:" + _pr + "-" + commands.length));
        return commands;
    }

    public static String[] image2mov(String imageUrl, String _t, String outputUrl) {
        ArrayList<String> _commands = new ArrayList<String>();
        _commands.add("ffmpeg");
        String _type = imageUrl.substring(imageUrl.length() - 3);
        if (_type.equals("gif")) {
            _commands.add("-ignore_loop");
            _commands.add("0");
        } else {
            _commands.add("-loop");
            _commands.add("1");
        }
        _commands.add("-i");
        _commands.add(imageUrl);
        _commands.add("-r");
        _commands.add("25");
        _commands.add("-b");
        _commands.add("200k");
        _commands.add("-s");
        _commands.add("640x360");
        _commands.add("-t");
        _commands.add(_t);
        _commands.add("-y");
        _commands.add(outputUrl);
        String[] commands = new String[_commands.size()];
        String _pr = "";
        for (int i = 0; i < _commands.size(); ++i) {
            commands[i] = (String)_commands.get(i);
            _pr = _pr + commands[i];
        }
        Log.d((String)"LOGCAT", (String)("ffmpeg command:" + _pr + "-" + commands.length));
        return commands;
    }

    public static String[] makeVideo(String textImageUrl, String imageUrl, String musicUrl, String videoUrl, String outputUrl, int _duration) {
        ArrayList<String> _commands = new ArrayList<String>();
        _commands.add("ffmpeg");
        _commands.add("-i");
        _commands.add(videoUrl);
        if (!textImageUrl.equals("") || !imageUrl.equals("")) {
            if (!imageUrl.equals("")) {
                _commands.add("-ignore_loop");
                _commands.add("0");
                _commands.add("-i");
                _commands.add(imageUrl);
            }
            if (!textImageUrl.equals("")) {
                _commands.add("-i");
                _commands.add(textImageUrl);
            }
            _commands.add("-filter_complex");
            if (textImageUrl.equals("")) {
                _commands.add("[1:v]scale=" + screenWidth + ":" + screenHeight + "[s];[0:v][s]overlay=0:0");
            } else if (imageUrl.equals("")) {
                _commands.add("overlay=x='if(lte(t," + titleDuration + "),(main_w-overlay_w)/2,NAN )':(main_h-overlay_h)/2");
            } else {
                _commands.add("[1:v]scale=" + screenWidth + ":" + screenHeight + "[img1];[2:v]scale=" + titlePicWidth + ":" + titlePicHeight + "[img2];[0:v][img1]overlay=0:0[bkg];[bkg][img2]overlay=x='if(lte(t," + titleDuration + "),(main_w-overlay_w)/2,NAN )':(main_h-overlay_h)/2");
            }
        }
        if (!musicUrl.equals("")) {
            _commands.add("-i");
            _commands.add(musicUrl);
        }
        _commands.add("-r");
        _commands.add("25");
        _commands.add("-b");
        _commands.add("1000k");
        _commands.add("-s");
        _commands.add("640x360");
        _commands.add("-ss");
        _commands.add("00:00:00");
        _commands.add("-t");
        _commands.add("" + _duration);
        _commands.add(outputUrl);
        String[] commands = new String[_commands.size()];
        String _pr = "";
        for (int i = 0; i < _commands.size(); ++i) {
            commands[i] = (String)_commands.get(i);
            _pr = _pr + commands[i];
        }
        Log.d((String)"LOGCAT", (String)("ffmpeg command:" + _pr + commands.length));
        return commands;
    }
}

