/*
 * Decompiled with CFR 0.152.
 */
package com.like;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.like.Icon;
import com.like.IconType;
import com.like.view.R;
import java.util.ArrayList;
import java.util.List;

public class Utils {
    public static double mapValueFromRangeToRange(double value, double fromLow, double fromHigh, double toLow, double toHigh) {
        return toLow + (value - fromLow) / (fromHigh - fromLow) * (toHigh - toLow);
    }

    public static double clamp(double value, double low, double high) {
        return Math.min(Math.max(value, low), high);
    }

    public static List<Icon> getIcons() {
        ArrayList<Icon> icons = new ArrayList<Icon>();
        icons.add(new Icon(R.drawable.heart_on, R.drawable.heart_off, IconType.Heart));
        icons.add(new Icon(R.drawable.star_on, R.drawable.star_off, IconType.Star));
        icons.add(new Icon(R.drawable.thumb_on, R.drawable.thumb_off, IconType.Thumb));
        return icons;
    }

    public static Drawable resizeDrawable(Context context, Drawable drawable2, int width, int height) {
        Bitmap bitmap = ((BitmapDrawable)drawable2).getBitmap();
        BitmapDrawable newDrawable = new BitmapDrawable(context.getResources(), Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)true));
        return newDrawable;
    }

    public static float dipToPixels(Context context, float dipValue) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return TypedValue.applyDimension((int)1, (float)dipValue, (DisplayMetrics)metrics);
    }
}

