/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import org.immutables.value.internal.;
import org.immutables.value.internal.$guava$.base.$Optional;
import org.immutables.value.internal.$guava$.base.$Preconditions;
import org.immutables.value.internal.$guava$.base.$Verify;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;

public class $IncludeMirror
implements .processor..ValueMirrors.Include {
    public static final String QUALIFIED_NAME = "org.immutables.value.Value.Include";
    public static final String MIRROR_QUALIFIED_NAME = "org.immutables.value.internal.$processor$.meta.ValueMirrors.$Include";
    private final AnnotationMirror annotationMirror;
    private final TypeMirror[] value;
    private final String[] valueName;

    public static String mirrorQualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String qualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String simpleName() {
        return "Include";
    }

    public static boolean isPresent(Element annotatedElement) {
        for (AnnotationMirror annotationMirror : annotatedElement.getAnnotationMirrors()) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return true;
        }
        return false;
    }

    public static $Optional<$IncludeMirror> find(Element element) {
        return $IncludeMirror.find(element.getAnnotationMirrors());
    }

    public static $Optional<$IncludeMirror> find(Iterable<? extends AnnotationMirror> mirrors) {
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return $Optional.of(new $IncludeMirror(annotationMirror));
        }
        return $Optional.absent();
    }

    public static $ImmutableList<$IncludeMirror> fromAll(Iterable<? extends AnnotationMirror> mirrors) {
        $ImmutableList.Builder builder = $ImmutableList.builder();
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            $Preconditions.checkState(element.getQualifiedName().contentEquals(QUALIFIED_NAME), "Supplied mirrors should all be of this annotation type");
            builder.add(new $IncludeMirror(annotationMirror));
        }
        return builder.build();
    }

    public static $IncludeMirror from(TypeElement element) {
        return new $IncludeMirror(element);
    }

    public static $Optional<$IncludeMirror> from(AnnotationMirror mirror) {
        return $IncludeMirror.find(Collections.singleton(mirror));
    }

    private $IncludeMirror(TypeElement defaultAnnotationElement) {
        $Preconditions.checkArgument(defaultAnnotationElement.getQualifiedName().contentEquals(QUALIFIED_NAME) || defaultAnnotationElement.getQualifiedName().contentEquals(MIRROR_QUALIFIED_NAME));
        this.annotationMirror = null;
        TypeMirror[] value = null;
        String[] valueName = null;
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(defaultAnnotationElement.getEnclosedElements())) {
            String name$ = attributeElement$.getSimpleName().toString();
            if (!"value".equals(name$)) continue;
            AnnotationValue annotationValue$ = attributeElement$.getDefaultValue();
            if (annotationValue$ == null) {
                throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Include");
            }
            ValueExtractor valueExtractor$ = new ValueExtractor();
            annotationValue$.accept(valueExtractor$, null);
            value = valueExtractor$.get();
            valueName = valueExtractor$.name();
        }
        this.value = $Preconditions.checkNotNull(value, "default attribute 'value'");
        this.valueName = $Preconditions.checkNotNull(valueName, "default attribute 'value'");
    }

    private $IncludeMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
        TypeMirror[] value = null;
        String[] valueName = null;
        Map<? extends ExecutableElement, ? extends AnnotationValue> attributeValues$ = annotationMirror.getElementValues();
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(annotationMirror.getAnnotationType().asElement().getEnclosedElements())) {
            String name$ = attributeElement$.getSimpleName().toString();
            if (!"value".equals(name$)) continue;
            AnnotationValue annotationValue$ = attributeValues$.get(attributeElement$);
            if (annotationValue$ == null) {
                annotationValue$ = attributeElement$.getDefaultValue();
            }
            if (annotationValue$ == null) {
                throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'value' attribute of @Include");
            }
            ValueExtractor valueExtractor$ = new ValueExtractor();
            annotationValue$.accept(valueExtractor$, null);
            value = valueExtractor$.get();
            valueName = valueExtractor$.name();
        }
        this.value = $Preconditions.checkNotNull(value, "value for 'value'");
        this.valueName = $Preconditions.checkNotNull(valueName, "Value for 'value'");
    }

    public String[] valueName() {
        return (String[])this.valueName.clone();
    }

    public TypeMirror[] valueMirror() {
        return (TypeMirror[])this.value.clone();
    }

    @Override
    @Deprecated
    public Class<?>[] value() {
        throw new UnsupportedOperationException("Use 'valueMirror()' or 'valueName()'");
    }

    public AnnotationMirror getAnnotationMirror() {
        $Preconditions.checkState(this.annotationMirror != null, "this is default mirror without originating AnnotationMirror");
        return this.annotationMirror;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return .processor..ValueMirrors.Include.class;
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        return h2 += 127 * "value".hashCode() ^ Arrays.hashCode(this.valueName);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof $IncludeMirror) {
            $IncludeMirror otherMirror = ($IncludeMirror)other;
            return Arrays.equals(this.valueName, otherMirror.valueName);
        }
        return false;
    }

    @Override
    public String toString() {
        return "IncludeMirror:" + this.annotationMirror;
    }

    private static class ValueExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        TypeMirror[] values;
        int position;

        private ValueExtractor() {
        }

        @Override
        public Void visitType(TypeMirror value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new TypeMirror[array.size()];
            $Verify.verify(this.position == 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        TypeMirror[] get() {
            return this.values;
        }

        public String[] name() {
            String[] names = new String[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                names[i] = this.values[i].toString();
            }
            return names;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'value' in @org.immutables.value.Value.Include");
        }
    }
}

