/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.github.jcustenborder.kafka.connect.utils.templates.Notes;
import com.github.jcustenborder.kafka.connect.utils.templates.Plugin;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.kafka.connect.source.SourceRecord;
import org.immutables.value.Generated;
import shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shaded.com.fasterxml.jackson.annotation.JsonCreator;
import shaded.com.fasterxml.jackson.annotation.JsonProperty;
import shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Plugin.SourceConnectorExample", generator="Immutables")
@Immutable
public final class ImmutableSourceConnectorExample
implements Plugin.SourceConnectorExample {
    @Nullable
    private final String warning;
    @Nullable
    private final String tip;
    @Nullable
    private final String important;
    @Nullable
    private final String danger;
    @Nullable
    private final String note;
    @Nullable
    private final String title;
    @Nullable
    private final String description;
    @Nullable
    private final String icon;
    @Nullable
    private final String introduction;
    private final String name;
    private final Map<String, String> config;
    private final Map<String, Map<String, String>> transformations;
    @Nullable
    private final SourceRecord output;

    private ImmutableSourceConnectorExample(@Nullable String warning, @Nullable String tip, @Nullable String important, @Nullable String danger, @Nullable String note, @Nullable String title, @Nullable String description, @Nullable String icon, @Nullable String introduction, String name, Map<String, String> config, Map<String, Map<String, String>> transformations, @Nullable SourceRecord output) {
        this.warning = warning;
        this.tip = tip;
        this.important = important;
        this.danger = danger;
        this.note = note;
        this.title = title;
        this.description = description;
        this.icon = icon;
        this.introduction = introduction;
        this.name = name;
        this.config = config;
        this.transformations = transformations;
        this.output = output;
    }

    @Override
    @JsonProperty(value="warning")
    @Nullable
    public String getWarning() {
        return this.warning;
    }

    @Override
    @JsonProperty(value="tip")
    @Nullable
    public String getTip() {
        return this.tip;
    }

    @Override
    @JsonProperty(value="important")
    @Nullable
    public String getImportant() {
        return this.important;
    }

    @Override
    @JsonProperty(value="danger")
    @Nullable
    public String getDanger() {
        return this.danger;
    }

    @Override
    @JsonProperty(value="note")
    @Nullable
    public String getNote() {
        return this.note;
    }

    @Override
    @JsonProperty(value="title")
    @Nullable
    public String getTitle() {
        return this.title;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="icon")
    @Nullable
    public String getIcon() {
        return this.icon;
    }

    @Override
    @JsonProperty(value="introduction")
    @Nullable
    public String getIntroduction() {
        return this.introduction;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="config")
    public Map<String, String> getConfig() {
        return this.config;
    }

    @Override
    @JsonProperty(value="transformations")
    public Map<String, Map<String, String>> transformations() {
        return this.transformations;
    }

    @Override
    @JsonProperty(value="output")
    @Nullable
    public SourceRecord getOutput() {
        return this.output;
    }

    public final ImmutableSourceConnectorExample withWarning(@Nullable String value) {
        if (Objects.equals(this.warning, value)) {
            return this;
        }
        return new ImmutableSourceConnectorExample(value, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.name, this.config, this.transformations, this.output);
    }

    public final ImmutableSourceConnectorExample withTip(@Nullable String value) {
        if (Objects.equals(this.tip, value)) {
            return this;
        }
        return new ImmutableSourceConnectorExample(this.warning, value, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.name, this.config, this.transformations, this.output);
    }

    public final ImmutableSourceConnectorExample withImportant(@Nullable String value) {
        if (Objects.equals(this.important, value)) {
            return this;
        }
        return new ImmutableSourceConnectorExample(this.warning, this.tip, value, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.name, this.config, this.transformations, this.output);
    }

    public final ImmutableSourceConnectorExample withDanger(@Nullable String value) {
        if (Objects.equals(this.danger, value)) {
            return this;
        }
        return new ImmutableSourceConnectorExample(this.warning, this.tip, this.important, value, this.note, this.title, this.description, this.icon, this.introduction, this.name, this.config, this.transformations, this.output);
    }

    public final ImmutableSourceConnectorExample withNote(@Nullable String value) {
        if (Objects.equals(this.note, value)) {
            return this;
        }
        return new ImmutableSourceConnectorExample(this.warning, this.tip, this.important, this.danger, value, this.title, this.description, this.icon, this.introduction, this.name, this.config, this.transformations, this.output);
    }

    public final ImmutableSourceConnectorExample withTitle(@Nullable String value) {
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutableSourceConnectorExample(this.warning, this.tip, this.important, this.danger, this.note, value, this.description, this.icon, this.introduction, this.name, this.config, this.transformations, this.output);
    }

    public final ImmutableSourceConnectorExample withDescription(@Nullable String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableSourceConnectorExample(this.warning, this.tip, this.important, this.danger, this.note, this.title, value, this.icon, this.introduction, this.name, this.config, this.transformations, this.output);
    }

    public final ImmutableSourceConnectorExample withIcon(@Nullable String value) {
        if (Objects.equals(this.icon, value)) {
            return this;
        }
        return new ImmutableSourceConnectorExample(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, value, this.introduction, this.name, this.config, this.transformations, this.output);
    }

    public final ImmutableSourceConnectorExample withIntroduction(@Nullable String value) {
        if (Objects.equals(this.introduction, value)) {
            return this;
        }
        return new ImmutableSourceConnectorExample(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, value, this.name, this.config, this.transformations, this.output);
    }

    public final ImmutableSourceConnectorExample withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableSourceConnectorExample(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, newValue, this.config, this.transformations, this.output);
    }

    public final ImmutableSourceConnectorExample withConfig(Map<String, ? extends String> entries) {
        if (this.config == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableSourceConnectorExample.createUnmodifiableMap(true, false, entries);
        return new ImmutableSourceConnectorExample(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.name, newValue, this.transformations, this.output);
    }

    public final ImmutableSourceConnectorExample withTransformations(Map<String, ? extends Map<String, String>> entries) {
        if (this.transformations == entries) {
            return this;
        }
        Map<String, Map<String, String>> newValue = ImmutableSourceConnectorExample.createUnmodifiableMap(true, false, entries);
        return new ImmutableSourceConnectorExample(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.name, this.config, newValue, this.output);
    }

    public final ImmutableSourceConnectorExample withOutput(@Nullable SourceRecord value) {
        if (this.output == value) {
            return this;
        }
        return new ImmutableSourceConnectorExample(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.name, this.config, this.transformations, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSourceConnectorExample && this.equalTo((ImmutableSourceConnectorExample)another);
    }

    private boolean equalTo(ImmutableSourceConnectorExample another) {
        return Objects.equals(this.warning, another.warning) && Objects.equals(this.tip, another.tip) && Objects.equals(this.important, another.important) && Objects.equals(this.danger, another.danger) && Objects.equals(this.note, another.note) && Objects.equals(this.title, another.title) && Objects.equals(this.description, another.description) && Objects.equals(this.icon, another.icon) && Objects.equals(this.introduction, another.introduction) && this.name.equals(another.name) && this.config.equals(another.config) && this.transformations.equals(another.transformations) && Objects.equals(this.output, another.output);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.warning);
        h2 += (h2 << 5) + Objects.hashCode(this.tip);
        h2 += (h2 << 5) + Objects.hashCode(this.important);
        h2 += (h2 << 5) + Objects.hashCode(this.danger);
        h2 += (h2 << 5) + Objects.hashCode(this.note);
        h2 += (h2 << 5) + Objects.hashCode(this.title);
        h2 += (h2 << 5) + Objects.hashCode(this.description);
        h2 += (h2 << 5) + Objects.hashCode(this.icon);
        h2 += (h2 << 5) + Objects.hashCode(this.introduction);
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.config.hashCode();
        h2 += (h2 << 5) + this.transformations.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.output);
        return h2;
    }

    public String toString() {
        return "SourceConnectorExample{warning=" + this.warning + ", tip=" + this.tip + ", important=" + this.important + ", danger=" + this.danger + ", note=" + this.note + ", title=" + this.title + ", description=" + this.description + ", icon=" + this.icon + ", introduction=" + this.introduction + ", name=" + this.name + ", config=" + this.config + ", transformations=" + this.transformations + ", output=" + this.output + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSourceConnectorExample fromJson(Json json) {
        Builder builder = ImmutableSourceConnectorExample.builder();
        if (json.warning != null) {
            builder.warning(json.warning);
        }
        if (json.tip != null) {
            builder.tip(json.tip);
        }
        if (json.important != null) {
            builder.important(json.important);
        }
        if (json.danger != null) {
            builder.danger(json.danger);
        }
        if (json.note != null) {
            builder.note(json.note);
        }
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.icon != null) {
            builder.icon(json.icon);
        }
        if (json.introduction != null) {
            builder.introduction(json.introduction);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.config != null) {
            builder.putAllConfig(json.config);
        }
        if (json.transformations != null) {
            builder.putAllTransformations(json.transformations);
        }
        if (json.output != null) {
            builder.output(json.output);
        }
        return builder.build();
    }

    public static ImmutableSourceConnectorExample copyOf(Plugin.SourceConnectorExample instance) {
        if (instance instanceof ImmutableSourceConnectorExample) {
            return (ImmutableSourceConnectorExample)instance;
        }
        return ImmutableSourceConnectorExample.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="Plugin.SourceConnectorExample", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String warning;
        @Nullable
        private String tip;
        @Nullable
        private String important;
        @Nullable
        private String danger;
        @Nullable
        private String note;
        @Nullable
        private String title;
        @Nullable
        private String description;
        @Nullable
        private String icon;
        @Nullable
        private String introduction;
        @Nullable
        private String name;
        private Map<String, String> config = new LinkedHashMap<String, String>();
        private Map<String, Map<String, String>> transformations = new LinkedHashMap<String, Map<String, String>>();
        @Nullable
        private SourceRecord output;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Notes instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Plugin.ConnectorExample instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Plugin.Example instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Plugin.SourceConnectorExample instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SourceRecord outputValue;
            Notes instance;
            if (object instanceof Notes) {
                String introductionValue;
                String titleValue;
                String dangerValue;
                String tipValue;
                String warningValue;
                String descriptionValue;
                String iconValue;
                String noteValue;
                instance = (Notes)object;
                String importantValue = instance.getImportant();
                if (importantValue != null) {
                    this.important(importantValue);
                }
                if ((noteValue = instance.getNote()) != null) {
                    this.note(noteValue);
                }
                if ((iconValue = instance.getIcon()) != null) {
                    this.icon(iconValue);
                }
                if ((descriptionValue = instance.getDescription()) != null) {
                    this.description(descriptionValue);
                }
                if ((warningValue = instance.getWarning()) != null) {
                    this.warning(warningValue);
                }
                if ((tipValue = instance.getTip()) != null) {
                    this.tip(tipValue);
                }
                if ((dangerValue = instance.getDanger()) != null) {
                    this.danger(dangerValue);
                }
                if ((titleValue = instance.getTitle()) != null) {
                    this.title(titleValue);
                }
                if ((introductionValue = instance.getIntroduction()) != null) {
                    this.introduction(introductionValue);
                }
            }
            if (object instanceof Plugin.ConnectorExample) {
                instance = (Plugin.ConnectorExample)object;
                this.putAllTransformations(instance.transformations());
            }
            if (object instanceof Plugin.Example) {
                instance = (Plugin.Example)object;
                this.name(instance.getName());
                this.putAllConfig(instance.getConfig());
            }
            if (object instanceof Plugin.SourceConnectorExample && (outputValue = (instance = (Plugin.SourceConnectorExample)object).getOutput()) != null) {
                this.output(outputValue);
            }
        }

        @JsonProperty(value="warning")
        @CanIgnoreReturnValue
        public final Builder warning(@Nullable String warning) {
            this.warning = warning;
            return this;
        }

        @JsonProperty(value="tip")
        @CanIgnoreReturnValue
        public final Builder tip(@Nullable String tip) {
            this.tip = tip;
            return this;
        }

        @JsonProperty(value="important")
        @CanIgnoreReturnValue
        public final Builder important(@Nullable String important) {
            this.important = important;
            return this;
        }

        @JsonProperty(value="danger")
        @CanIgnoreReturnValue
        public final Builder danger(@Nullable String danger) {
            this.danger = danger;
            return this;
        }

        @JsonProperty(value="note")
        @CanIgnoreReturnValue
        public final Builder note(@Nullable String note) {
            this.note = note;
            return this;
        }

        @JsonProperty(value="title")
        @CanIgnoreReturnValue
        public final Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="icon")
        @CanIgnoreReturnValue
        public final Builder icon(@Nullable String icon) {
            this.icon = icon;
            return this;
        }

        @JsonProperty(value="introduction")
        @CanIgnoreReturnValue
        public final Builder introduction(@Nullable String introduction) {
            this.introduction = introduction;
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putConfig(String key, String value) {
            this.config.put(Objects.requireNonNull(key, "config key"), Objects.requireNonNull(value, "config value"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putConfig(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.config.put(Objects.requireNonNull(k, "config key"), Objects.requireNonNull(v, "config value"));
            return this;
        }

        @JsonProperty(value="config")
        @CanIgnoreReturnValue
        public final Builder config(Map<String, ? extends String> entries) {
            this.config.clear();
            return this.putAllConfig(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllConfig(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.config.put(Objects.requireNonNull(k, "config key"), Objects.requireNonNull(v, "config value"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putTransformations(String key, Map<String, String> value) {
            this.transformations.put(Objects.requireNonNull(key, "transformations key"), Objects.requireNonNull(value, "transformations value"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putTransformations(Map.Entry<String, ? extends Map<String, String>> entry) {
            String k = entry.getKey();
            Map<String, String> v = entry.getValue();
            this.transformations.put(Objects.requireNonNull(k, "transformations key"), Objects.requireNonNull(v, "transformations value"));
            return this;
        }

        @JsonProperty(value="transformations")
        @CanIgnoreReturnValue
        public final Builder transformations(Map<String, ? extends Map<String, String>> entries) {
            this.transformations.clear();
            return this.putAllTransformations(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllTransformations(Map<String, ? extends Map<String, String>> entries) {
            for (Map.Entry<String, ? extends Map<String, String>> e : entries.entrySet()) {
                String k = e.getKey();
                Map<String, String> v = e.getValue();
                this.transformations.put(Objects.requireNonNull(k, "transformations key"), Objects.requireNonNull(v, "transformations value"));
            }
            return this;
        }

        @JsonProperty(value="output")
        @CanIgnoreReturnValue
        public final Builder output(@Nullable SourceRecord output) {
            this.output = output;
            return this;
        }

        public ImmutableSourceConnectorExample build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSourceConnectorExample(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.name, ImmutableSourceConnectorExample.createUnmodifiableMap(false, false, this.config), ImmutableSourceConnectorExample.createUnmodifiableMap(false, false, this.transformations), this.output);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build SourceConnectorExample, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Plugin.SourceConnectorExample", generator="Immutables")
    static final class Json
    implements Plugin.SourceConnectorExample {
        @Nullable
        String warning;
        @Nullable
        String tip;
        @Nullable
        String important;
        @Nullable
        String danger;
        @Nullable
        String note;
        @Nullable
        String title;
        @Nullable
        String description;
        @Nullable
        String icon;
        @Nullable
        String introduction;
        @Nullable
        String name;
        @Nullable
        Map<String, String> config = Collections.emptyMap();
        @Nullable
        Map<String, Map<String, String>> transformations = Collections.emptyMap();
        @Nullable
        SourceRecord output;

        Json() {
        }

        @JsonProperty(value="warning")
        public void setWarning(@Nullable String warning) {
            this.warning = warning;
        }

        @JsonProperty(value="tip")
        public void setTip(@Nullable String tip) {
            this.tip = tip;
        }

        @JsonProperty(value="important")
        public void setImportant(@Nullable String important) {
            this.important = important;
        }

        @JsonProperty(value="danger")
        public void setDanger(@Nullable String danger) {
            this.danger = danger;
        }

        @JsonProperty(value="note")
        public void setNote(@Nullable String note) {
            this.note = note;
        }

        @JsonProperty(value="title")
        public void setTitle(@Nullable String title) {
            this.title = title;
        }

        @JsonProperty(value="description")
        public void setDescription(@Nullable String description) {
            this.description = description;
        }

        @JsonProperty(value="icon")
        public void setIcon(@Nullable String icon) {
            this.icon = icon;
        }

        @JsonProperty(value="introduction")
        public void setIntroduction(@Nullable String introduction) {
            this.introduction = introduction;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="config")
        public void setConfig(Map<String, String> config) {
            this.config = config;
        }

        @JsonProperty(value="transformations")
        public void setTransformations(Map<String, Map<String, String>> transformations) {
            this.transformations = transformations;
        }

        @JsonProperty(value="output")
        public void setOutput(@Nullable SourceRecord output) {
            this.output = output;
        }

        @Override
        public String getWarning() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTip() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getImportant() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDanger() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getNote() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIcon() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIntroduction() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Map<String, String>> transformations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SourceRecord getOutput() {
            throw new UnsupportedOperationException();
        }
    }
}

