/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.jackson;

import com.github.jcustenborder.kafka.connect.utils.jackson.KeyValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.fasterxml.jackson.annotation.JsonProperty;
import shaded.com.fasterxml.jackson.core.JsonGenerator;
import shaded.com.fasterxml.jackson.core.JsonParser;
import shaded.com.fasterxml.jackson.core.JsonProcessingException;
import shaded.com.fasterxml.jackson.databind.DeserializationContext;
import shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import shaded.com.fasterxml.jackson.databind.JsonSerializer;
import shaded.com.fasterxml.jackson.databind.SerializerProvider;
import shaded.com.fasterxml.jackson.databind.module.SimpleModule;

public class StructSerializationModule
extends SimpleModule {
    private static final Logger log = LoggerFactory.getLogger(StructSerializationModule.class);

    public StructSerializationModule() {
        this.addSerializer(Struct.class, new Serializer());
        this.addDeserializer(Struct.class, new Deserializer());
    }

    static class Deserializer
    extends JsonDeserializer<Struct> {
        Deserializer() {
        }

        @Override
        public Struct deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Storage storage = jsonParser.readValueAs(Storage.class);
            return storage.build();
        }
    }

    static class Serializer
    extends JsonSerializer<Struct> {
        Serializer() {
        }

        @Override
        public void serialize(Struct struct, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            struct.validate();
            Storage result = new Storage();
            result.schema = struct.schema();
            result.fieldValues = new ArrayList<KeyValue>();
            for (Field field : struct.schema().fields()) {
                log.trace("serialize() - Processing field '{}'", (Object)field.name());
                KeyValue keyValue = new KeyValue();
                keyValue.name = field.name();
                keyValue.schema = field.schema();
                keyValue.value(struct.get(field));
                result.fieldValues.add(keyValue);
            }
            jsonGenerator.writeObject(result);
        }
    }

    public static class Storage {
        @JsonProperty(value="schema")
        public Schema schema;
        @JsonProperty(value="fieldValues")
        public List<KeyValue> fieldValues;

        public Struct build() {
            log.trace("build() - Creating struct for {}", (Object)this.schema);
            Struct struct = new Struct(this.schema);
            for (KeyValue keyValue : this.fieldValues) {
                log.trace("build() - Setting field value for '{}'", (Object)keyValue.name);
                struct.put(keyValue.name, keyValue.value());
            }
            struct.validate();
            return struct;
        }
    }
}

