/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.jackson;

import com.github.jcustenborder.kafka.connect.utils.jackson.ValueHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.source.SourceRecord;
import shaded.com.fasterxml.jackson.core.JsonGenerator;
import shaded.com.fasterxml.jackson.core.JsonParser;
import shaded.com.fasterxml.jackson.core.JsonProcessingException;
import shaded.com.fasterxml.jackson.databind.DeserializationContext;
import shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import shaded.com.fasterxml.jackson.databind.JsonSerializer;
import shaded.com.fasterxml.jackson.databind.SerializerProvider;
import shaded.com.fasterxml.jackson.databind.module.SimpleModule;

public class SourceRecordSerializationModule
extends SimpleModule {
    public SourceRecordSerializationModule() {
        this.addSerializer(SourceRecord.class, new Serializer());
        this.addDeserializer(SourceRecord.class, new Deserializer());
    }

    static class Deserializer
    extends JsonDeserializer<SourceRecord> {
        Deserializer() {
        }

        @Override
        public SourceRecord deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Storage storage = jsonParser.readValueAs(Storage.class);
            return storage.build();
        }
    }

    static class Serializer
    extends JsonSerializer<SourceRecord> {
        Serializer() {
        }

        @Override
        public void serialize(SourceRecord record, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            Storage storage = new Storage();
            storage.sourcePartition = record.sourcePartition();
            storage.sourceOffset = record.sourceOffset();
            storage.topic = record.topic();
            storage.kafkaPartition = record.kafkaPartition();
            storage.keySchema = record.keySchema();
            storage.key = record.key();
            storage.valueSchema = record.valueSchema();
            storage.value = record.value();
            storage.timestamp = record.timestamp();
            if (null != record.headers()) {
                ArrayList<Header> headers = new ArrayList<Header>();
                for (Header header : record.headers()) {
                    headers.add(header);
                }
                storage.headers = headers;
            }
            jsonGenerator.writeObject(storage);
        }
    }

    public static class Storage {
        public Map<String, ?> sourcePartition;
        public Map<String, ?> sourceOffset;
        public String topic;
        public Integer kafkaPartition;
        public Schema keySchema;
        public Object key;
        public Schema valueSchema;
        public Object value;
        public Long timestamp;
        public List<Header> headers;

        public Object value() {
            if (this.valueSchema != null) {
                return ValueHelper.value(this.valueSchema, this.value);
            }
            return this.value;
        }

        public Object key() {
            if (this.keySchema != null) {
                return ValueHelper.value(this.keySchema, this.key);
            }
            return this.key;
        }

        public SourceRecord build() {
            return new SourceRecord(this.sourcePartition, this.sourceOffset, this.topic, this.kafkaPartition, this.keySchema, this.key(), this.valueSchema, this.value(), this.timestamp, this.headers);
        }
    }
}

