/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.jackson;

import java.io.IOException;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.types.Password;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.fasterxml.jackson.core.JsonGenerator;
import shaded.com.fasterxml.jackson.core.JsonParser;
import shaded.com.fasterxml.jackson.core.JsonProcessingException;
import shaded.com.fasterxml.jackson.databind.DeserializationContext;
import shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import shaded.com.fasterxml.jackson.databind.JsonSerializer;
import shaded.com.fasterxml.jackson.databind.SerializerProvider;
import shaded.com.fasterxml.jackson.databind.module.SimpleModule;

public class ConfigDefSerializationModule
extends SimpleModule {
    private static final Logger log = LoggerFactory.getLogger(ConfigDefSerializationModule.class);

    public ConfigDefSerializationModule() {
        this.addSerializer(Password.class, new Serializer());
        this.addDeserializer(Password.class, new Deserializer());
        this.addSerializer(ConfigDef.Validator.class, new JsonSerializer<ConfigDef.Validator>(){

            @Override
            public void serialize(ConfigDef.Validator validator, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeString(validator.toString());
            }
        });
    }

    static class Deserializer
    extends JsonDeserializer<Password> {
        Deserializer() {
        }

        @Override
        public Password deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            String text = jsonParser.readValueAs(String.class);
            return new Password(text);
        }
    }

    static class Serializer
    extends JsonSerializer<Password> {
        Serializer() {
        }

        @Override
        public void serialize(Password password, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            jsonGenerator.writeString(password.toString());
        }
    }
}

