/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.data;

import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.google.common.base.Preconditions;

public class SourceRecordConcurrentLinkedDeque
extends ConcurrentLinkedDeque<SourceRecord> {
    private static final Logger log = LoggerFactory.getLogger(SourceRecordConcurrentLinkedDeque.class);
    private final int batchSize;
    private final int timeout;

    public SourceRecordConcurrentLinkedDeque(int batchSize, int timeout) {
        this.batchSize = batchSize;
        this.timeout = timeout;
    }

    public SourceRecordConcurrentLinkedDeque() {
        this(1024, 0);
    }

    public boolean drain(List<SourceRecord> records) throws InterruptedException {
        return this.drain(records, this.timeout);
    }

    public boolean drain(List<SourceRecord> records, int timeout) throws InterruptedException {
        Preconditions.checkNotNull(records, "records cannot be null");
        Preconditions.checkArgument(timeout >= 0, "timeout should be greater than or equal to 0.");
        if (log.isDebugEnabled()) {
            log.debug("determining size for this run. batchSize={}, records.size()={}", (Object)this.batchSize, (Object)records.size());
        }
        int count = Math.min(this.batchSize, this.size());
        if (log.isDebugEnabled()) {
            log.debug("Draining {} record(s).", (Object)count);
        }
        for (int i = 0; i < count; ++i) {
            SourceRecord record = (SourceRecord)this.poll();
            if (null != record) {
                records.add(record);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Poll returned null. exiting");
            break;
        }
        if (records.isEmpty() && timeout > 0) {
            if (log.isDebugEnabled()) {
                log.debug("Found no records, sleeping {} ms.", (Object)timeout);
            }
            Thread.sleep(timeout);
        }
        return !records.isEmpty();
    }
}

