/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.data;

import java.util.Objects;
import org.apache.kafka.connect.data.Schema;
import shaded.com.google.common.base.MoreObjects;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.collect.ComparisonChain;

public class SchemaKey
implements Comparable<SchemaKey> {
    public final String name;
    public final Integer version;
    public final Schema.Type type;

    private SchemaKey(Schema schema) {
        this.name = schema.name();
        this.version = schema.version();
        this.type = schema.type();
    }

    public static SchemaKey of(Schema schema) {
        Preconditions.checkNotNull(schema, "schema cannot be null.");
        return new SchemaKey(schema);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.version);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Schema) {
            return this.equals(SchemaKey.of((Schema)obj));
        }
        if (!(obj instanceof SchemaKey)) {
            return false;
        }
        return 0 == this.compareTo((SchemaKey)obj);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("type", this.type).add("version", this.version).omitNullValues().toString();
    }

    @Override
    public int compareTo(SchemaKey that) {
        return ComparisonChain.start().compare((Comparable<?>)this.type, (Comparable<?>)that.type).compare((Comparable<?>)((Object)(null == this.name ? "" : this.name)), (Comparable<?>)((Object)(null == that.name ? "" : that.name))).compare(null == this.version ? 0 : this.version, null == that.version ? 0 : that.version).result();
    }
}

