/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.data.type;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.jcustenborder.kafka.connect.utils.data.type.TypeParser;
import com.google.common.base.Preconditions;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.kafka.connect.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDateTypeParser
implements TypeParser {
    static final Logger log = LoggerFactory.getLogger(BaseDateTypeParser.class);
    protected final TimeZone timeZone;
    final SimpleDateFormat[] dateFormats;

    public BaseDateTypeParser(TimeZone timeZone, SimpleDateFormat ... dateFormats) {
        this.dateFormats = dateFormats;
        this.timeZone = timeZone;
    }

    abstract Date process(Date var1);

    @Override
    public Object parseString(String s, Schema schema) {
        Date date = null;
        for (SimpleDateFormat dateFormat : this.dateFormats) {
            try {
                date = dateFormat.parse(s);
                break;
            }
            catch (ParseException e) {
                if (!log.isTraceEnabled()) continue;
                log.trace("Could not parse '{}' to java.util.Date", (Object)s, (Object)e);
            }
        }
        Preconditions.checkState((null != date ? 1 : 0) != 0, (String)"Could not parse '%s' to java.util.Date", (Object)s);
        return this.process(date);
    }

    @Override
    public Object parseJsonNode(JsonNode input, Schema schema) {
        Date result;
        if (input.isNumber()) {
            result = new Date(input.longValue());
        } else if (input.isTextual()) {
            result = (Date)this.parseString(input.textValue(), schema);
        } else {
            throw new IllegalStateException(String.format("NodeType:%s '%s' could not be converted to %s", input.getNodeType(), input.textValue(), this.expectedClass().getSimpleName()));
        }
        return this.process(result);
    }

    @Override
    public Class<?> expectedClass() {
        return Date.class;
    }
}

