/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.data;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public class SchemaBuilders {
    public static SchemaBuilder of(Schema schema, String ... excludeFields) {
        return SchemaBuilders.of(schema, Arrays.asList(excludeFields));
    }

    public static SchemaBuilder of(Schema schema, Collection<String> excludeFields) {
        ImmutableSet exclude;
        ImmutableSet immutableSet = exclude = null != excludeFields ? ImmutableSet.copyOf(excludeFields) : ImmutableSet.of();
        SchemaBuilder builder = Schema.Type.ARRAY == schema.type() ? SchemaBuilder.array((Schema)schema.valueSchema()) : (Schema.Type.MAP == schema.type() ? SchemaBuilder.map((Schema)schema.keySchema(), (Schema)schema.valueSchema()) : SchemaBuilder.type((Schema.Type)schema.type()));
        if (schema.isOptional()) {
            builder.optional();
        }
        if (!Strings.isNullOrEmpty((String)schema.name())) {
            builder.name(schema.name());
        }
        if (!Strings.isNullOrEmpty((String)schema.doc())) {
            builder.doc(schema.doc());
        }
        builder.version(schema.version());
        if (null != schema.parameters()) {
            builder.parameters(schema.parameters());
        }
        if (Schema.Type.STRUCT == schema.type()) {
            schema.fields().stream().filter(arg_0 -> SchemaBuilders.lambda$of$0((Set)exclude, arg_0)).forEach(field -> builder.field(field.name(), field.schema()));
        }
        return builder;
    }

    private static /* synthetic */ boolean lambda$of$0(Set exclude, Field field) {
        return !exclude.contains(field.name());
    }
}

