/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.github.jcustenborder.kafka.connect.utils.jackson.ValueHelper;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class KeyValue {
    private static final Logger log = LoggerFactory.getLogger(KeyValue.class);
    String name;
    Schema schema;
    private Object storage;
    private Struct struct;

    public void value(Object value) {
        log.trace("value(Object) - name = '{}', schema.type() = {}", (Object)this.name, (Object)this.schema.type());
        if (value != null) {
            switch (this.schema.type()) {
                case STRUCT: {
                    Preconditions.checkState((boolean)(value instanceof Struct), (Object)"value must be a struct.");
                    this.struct = (Struct)value;
                    break;
                }
                default: {
                    this.storage = value;
                }
            }
        }
    }

    public Object value() {
        Object result;
        log.trace("value() - name = '{}'", (Object)this.name);
        switch (this.schema.type()) {
            case MAP: {
                Preconditions.checkState((this.storage == null || this.storage instanceof Map ? 1 : 0) != 0, (Object)"storage should be a Map.");
                if (null != this.storage) {
                    Map input = (Map)this.storage;
                    log.trace("value() - converting storage map of {} value(s) to Map<{}, {}>", new Object[]{input.size(), this.schema.keySchema(), this.schema.valueSchema()});
                    LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(input.size());
                    for (Map.Entry kvp : input.entrySet()) {
                        log.trace("value() - converting key.");
                        Object key = ValueHelper.value(this.schema.keySchema(), kvp.getKey());
                        log.trace("value() - converting value.");
                        Object value = ValueHelper.value(this.schema.valueSchema(), kvp.getValue());
                        map.put(key, value);
                    }
                    result = map;
                    break;
                }
                result = null;
                break;
            }
            case ARRAY: {
                Preconditions.checkState((this.storage == null || this.storage instanceof List ? 1 : 0) != 0, (Object)"storage should be a List.");
                if (null != this.storage) {
                    List input = (List)this.storage;
                    log.trace("value() - converting storage map of {} value(s) to List<{}>", (Object)input.size(), (Object)this.schema.valueSchema());
                    ArrayList<Object> list = new ArrayList<Object>(input.size());
                    for (Object o : input) {
                        log.trace("value() - converting key.");
                        Object value = ValueHelper.value(this.schema.valueSchema(), o);
                        list.add(value);
                    }
                    result = list;
                    break;
                }
                result = null;
                break;
            }
            case STRUCT: {
                result = this.struct;
                break;
            }
            default: {
                result = ValueHelper.value(this.schema, this.storage);
            }
        }
        return result;
    }
}

