/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.data;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import org.apache.kafka.common.TopicPartition;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE)
public class SinkOffsetState
implements Comparable<SinkOffsetState> {
    @JsonProperty(value="topic")
    private String topic;
    @JsonProperty(value="partition")
    private Integer partition;
    @JsonProperty(value="offset")
    private Long offset;

    @JsonCreator
    private SinkOffsetState() {
    }

    public String topic() {
        return this.topic;
    }

    public Integer partition() {
        return this.partition;
    }

    public Long offset() {
        return this.offset;
    }

    private SinkOffsetState(String topic, Integer partition, Long offset) {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)topic) ? 1 : 0) != 0, (Object)"topic cannot be null or empty.");
        Preconditions.checkNotNull((Object)partition, (Object)"partition cannot be null.");
        Preconditions.checkNotNull((Object)offset, (Object)"offset cannot be null.");
        this.topic = topic;
        this.partition = partition;
        this.offset = offset;
    }

    public TopicPartition topicPartition() {
        return new TopicPartition(this.topic, this.partition.intValue());
    }

    public static SinkOffsetState of(TopicPartition topicPartition, long offset) {
        Preconditions.checkNotNull((Object)topicPartition, (Object)"topicPartition cannot be null.");
        return SinkOffsetState.of(topicPartition.topic(), topicPartition.partition(), offset);
    }

    public static SinkOffsetState of(String topic, int partition, long offset) {
        return new SinkOffsetState(topic, partition, offset);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("topic", (Object)this.topic).add("partition", (Object)this.partition).add("offset", (Object)this.offset).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.topic, this.partition, this.offset});
    }

    public boolean equals(Object obj) {
        if (obj instanceof SinkOffsetState) {
            return 0 == this.compareTo((SinkOffsetState)obj);
        }
        return false;
    }

    @Override
    public int compareTo(SinkOffsetState that) {
        return ComparisonChain.start().compare((Comparable)((Object)this.topic), (Comparable)((Object)that.topic)).compare((Comparable)this.partition, (Comparable)that.partition).compare((Comparable)this.offset, (Comparable)that.offset).result();
    }
}

