/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.config.validators;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

class ValidCharset
implements ConfigDef.Validator {
    private final Set<String> allowedCharsets;

    public ValidCharset() {
        this((Iterable<String>)ImmutableSet.copyOf(Charset.availableCharsets().keySet()));
    }

    public ValidCharset(String ... charsets) {
        this((Iterable<String>)ImmutableSet.copyOf((Object[])charsets));
    }

    public ValidCharset(Iterable<String> charsets) {
        this.allowedCharsets = ImmutableSet.copyOf(charsets);
    }

    static void validate(String config, String value) {
        try {
            Charset.forName(value);
        }
        catch (Exception ex) {
            ConfigException configException = new ConfigException(config, (Object)value, "Charset is invalid.");
            configException.initCause((Throwable)ex);
            throw configException;
        }
    }

    public void ensureValid(String config, Object value) {
        if (value instanceof String) {
            ValidCharset.validate(config, (String)value);
        } else if (value instanceof List) {
            List values = (List)value;
            for (String v : values) {
                ValidCharset.validate(config, v);
            }
        } else {
            throw new ConfigException(config, value, "Must be a string or list.");
        }
    }

    public String toString() {
        List sortedCharsets = this.allowedCharsets.stream().sorted().collect(Collectors.toList());
        StringBuilder builder = new StringBuilder();
        builder.append("Valid values: '");
        Joiner.on((String)"', '").appendTo(builder, sortedCharsets);
        builder.append('\'');
        return builder.toString();
    }
}

