/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.data;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.errors.DataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConverter<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractConverter.class);

    protected abstract T newValue();

    protected abstract void setStringField(T var1, String var2, String var3);

    protected abstract void setFloat32Field(T var1, String var2, Float var3);

    protected abstract void setFloat64Field(T var1, String var2, Double var3);

    protected abstract void setTimestampField(T var1, String var2, Date var3);

    protected abstract void setDateField(T var1, String var2, Date var3);

    protected abstract void setTimeField(T var1, String var2, Date var3);

    protected abstract void setInt8Field(T var1, String var2, Byte var3);

    protected abstract void setInt16Field(T var1, String var2, Short var3);

    protected abstract void setInt32Field(T var1, String var2, Integer var3);

    protected abstract void setInt64Field(T var1, String var2, Long var3);

    protected abstract void setBytesField(T var1, String var2, byte[] var3);

    protected abstract void setDecimalField(T var1, String var2, BigDecimal var3);

    protected abstract void setBooleanField(T var1, String var2, Boolean var3);

    protected abstract void setStructField(T var1, String var2, Struct var3);

    protected abstract void setArray(T var1, String var2, Schema var3, List var4);

    protected abstract void setMap(T var1, String var2, Schema var3, Map var4);

    protected abstract void setNullField(T var1, String var2);

    public T convert(Object value) {
        Preconditions.checkNotNull((Object)value, (Object)"value cannot be null.");
        T result = this.newValue();
        if (value instanceof Struct) {
            this.convertStruct(result, (Struct)value);
        } else if (value instanceof Map) {
            this.convertMap(result, (Map)value);
        } else {
            throw new DataException(String.format("Only Schema (%s) or Schema less (%s) are supported. %s is not a supported type.", Struct.class.getName(), Map.class.getName(), value.getClass().getName()));
        }
        return result;
    }

    void convertMap(T result, Map value) {
        for (Object key : value.keySet()) {
            Preconditions.checkState((boolean)(key instanceof String), (Object)"Map key must be a String.");
            String fieldName = (String)key;
            Object fieldValue = value.get(key);
            if (null == fieldValue) {
                log.trace("convertStruct() - Setting '{}' to null.", (Object)fieldName);
                this.setNullField(result, fieldName);
                continue;
            }
            if (fieldValue instanceof String) {
                log.trace("convertStruct() - Processing '{}' as string.", (Object)fieldName);
                this.setStringField(result, fieldName, (String)fieldValue);
                continue;
            }
            if (fieldValue instanceof Byte) {
                log.trace("convertStruct() - Processing '{}' as int8.", (Object)fieldName);
                this.setInt8Field(result, fieldName, (Byte)fieldValue);
                continue;
            }
            if (fieldValue instanceof Short) {
                log.trace("convertStruct() - Processing '{}' as int16.", (Object)fieldName);
                this.setInt16Field(result, fieldName, (Short)fieldValue);
                continue;
            }
            if (fieldValue instanceof Integer) {
                log.trace("convertStruct() - Processing '{}' as int32.", (Object)fieldName);
                this.setInt32Field(result, fieldName, (Integer)fieldValue);
                continue;
            }
            if (fieldValue instanceof Long) {
                log.trace("convertStruct() - Processing '{}' as long.", (Object)fieldName);
                this.setInt64Field(result, fieldName, (Long)fieldValue);
                continue;
            }
            if (fieldValue instanceof BigInteger) {
                log.trace("convertStruct() - Processing '{}' as long.", (Object)fieldName);
                this.setInt64Field(result, fieldName, ((BigInteger)fieldValue).longValue());
                continue;
            }
            if (fieldValue instanceof Double) {
                log.trace("convertStruct() - Processing '{}' as float64.", (Object)fieldName);
                this.setFloat64Field(result, fieldName, (Double)fieldValue);
                continue;
            }
            if (fieldValue instanceof Float) {
                log.trace("convertStruct() - Processing '{}' as float32.", (Object)fieldName);
                this.setFloat32Field(result, fieldName, (Float)fieldValue);
                continue;
            }
            if (fieldValue instanceof BigDecimal) {
                log.trace("convertStruct() - Processing '{}' as decimal.", (Object)fieldName);
                this.setDecimalField(result, fieldName, (BigDecimal)fieldValue);
                continue;
            }
            if (fieldValue instanceof Boolean) {
                log.trace("convertStruct() - Processing '{}' as boolean.", (Object)fieldName);
                this.setBooleanField(result, fieldName, (Boolean)fieldValue);
                continue;
            }
            if (fieldValue instanceof Date) {
                log.trace("convertStruct() - Processing '{}' as timestamp.", (Object)fieldName);
                this.setTimestampField(result, fieldName, (Date)fieldValue);
                continue;
            }
            if (fieldValue instanceof byte[]) {
                log.trace("convertStruct() - Processing '{}' as bytes.", (Object)fieldName);
                this.setBytesField(result, fieldName, (byte[])fieldValue);
                continue;
            }
            if (fieldValue instanceof List) {
                log.trace("convertStruct() - Processing '{}' as array.", (Object)fieldName);
                this.setArray(result, fieldName, null, (List)fieldValue);
                continue;
            }
            if (fieldValue instanceof Map) {
                log.trace("convertStruct() - Processing '{}' as map.", (Object)fieldName);
                this.setMap(result, fieldName, null, (Map)fieldValue);
                continue;
            }
            throw new DataException(String.format("%s is not a supported data type.", fieldValue.getClass().getName()));
        }
    }

    void convertStruct(T result, Struct struct) {
        Schema schema = struct.schema();
        block14: for (Field field : schema.fields()) {
            String fieldName = field.name();
            log.trace("convertStruct() - Processing '{}'", (Object)field.name());
            Object fieldValue = struct.get(field);
            if (null == fieldValue) {
                log.trace("convertStruct() - Setting '{}' to null.", (Object)fieldName);
                this.setNullField(result, fieldName);
                continue;
            }
            log.trace("convertStruct() - Field '{}'.field().schema().type() = '{}'", (Object)fieldName, (Object)field.schema().type());
            switch (field.schema().type()) {
                case STRING: {
                    log.trace("convertStruct() - Processing '{}' as string.", (Object)fieldName);
                    this.setStringField(result, fieldName, (String)fieldValue);
                    continue block14;
                }
                case INT8: {
                    log.trace("convertStruct() - Processing '{}' as int8.", (Object)fieldName);
                    this.setInt8Field(result, fieldName, (Byte)fieldValue);
                    continue block14;
                }
                case INT16: {
                    log.trace("convertStruct() - Processing '{}' as int16.", (Object)fieldName);
                    this.setInt16Field(result, fieldName, (Short)fieldValue);
                    continue block14;
                }
                case INT32: {
                    Integer int32Value = (Integer)fieldValue;
                    if ("org.apache.kafka.connect.data.Date".equals(field.schema().name())) {
                        log.trace("convertStruct() - Processing '{}' as date.", (Object)fieldName);
                        this.setDateField(result, fieldName, org.apache.kafka.connect.data.Date.toLogical((Schema)field.schema(), (int)int32Value));
                        continue block14;
                    }
                    if ("org.apache.kafka.connect.data.Time".equals(field.schema().name())) {
                        log.trace("convertStruct() - Processing '{}' as time.", (Object)fieldName);
                        this.setTimeField(result, fieldName, Time.toLogical((Schema)field.schema(), (int)int32Value));
                        continue block14;
                    }
                    log.trace("convertStruct() - Processing '{}' as int32.", (Object)fieldName);
                    this.setInt32Field(result, fieldName, int32Value);
                    continue block14;
                }
                case INT64: {
                    Long int64Value = (Long)fieldValue;
                    if ("org.apache.kafka.connect.data.Timestamp".equals(field.schema().name())) {
                        log.trace("convertStruct() - Processing '{}' as timestamp.", (Object)fieldName);
                        this.setTimestampField(result, fieldName, Timestamp.toLogical((Schema)field.schema(), (long)int64Value));
                        continue block14;
                    }
                    log.trace("convertStruct() - Processing '{}' as int64.", (Object)fieldName);
                    this.setInt64Field(result, fieldName, int64Value);
                    continue block14;
                }
                case BYTES: {
                    byte[] bytes = (byte[])fieldValue;
                    if ("org.apache.kafka.connect.data.Decimal".equals(field.schema().name())) {
                        log.trace("convertStruct() - Processing '{}' as decimal.", (Object)fieldName);
                        this.setDecimalField(result, fieldName, Decimal.toLogical((Schema)field.schema(), (byte[])bytes));
                        continue block14;
                    }
                    log.trace("convertStruct() - Processing '{}' as bytes.", (Object)fieldName);
                    this.setBytesField(result, fieldName, bytes);
                    continue block14;
                }
                case FLOAT32: {
                    log.trace("convertStruct() - Processing '{}' as float32.", (Object)fieldName);
                    this.setFloat32Field(result, fieldName, (Float)fieldValue);
                    continue block14;
                }
                case FLOAT64: {
                    log.trace("convertStruct() - Processing '{}' as float64.", (Object)fieldName);
                    this.setFloat64Field(result, fieldName, (Double)fieldValue);
                    continue block14;
                }
                case BOOLEAN: {
                    log.trace("convertStruct() - Processing '{}' as boolean.", (Object)fieldName);
                    this.setBooleanField(result, fieldName, (Boolean)fieldValue);
                    continue block14;
                }
                case STRUCT: {
                    log.trace("convertStruct() - Processing '{}' as struct.", (Object)fieldName);
                    this.setStructField(result, fieldName, (Struct)fieldValue);
                    continue block14;
                }
                case ARRAY: {
                    log.trace("convertStruct() - Processing '{}' as array.", (Object)fieldName);
                    this.setArray(result, fieldName, schema, (List)fieldValue);
                    continue block14;
                }
                case MAP: {
                    log.trace("convertStruct() - Processing '{}' as map.", (Object)fieldName);
                    this.setMap(result, fieldName, schema, (Map)fieldValue);
                    continue block14;
                }
            }
            throw new DataException("Unsupported schema.type(): " + schema.type());
        }
    }
}

