/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.config;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

@Deprecated
public class ValidPort
implements ConfigDef.Validator {
    final int start;
    final int end;

    ValidPort(int start, int end) {
        Preconditions.checkState((start > 0 ? 1 : 0) != 0, (Object)"start must be greater than 0.");
        Preconditions.checkState((end > 0 ? 1 : 0) != 0, (Object)"end must be greater than 0.");
        Preconditions.checkState((start <= 65535 ? 1 : 0) != 0, (Object)"start must be less than or equal to 65535.");
        Preconditions.checkState((end <= 65535 ? 1 : 0) != 0, (Object)"end must be less than or equal to 65535.");
        Preconditions.checkState((end > start ? 1 : 0) != 0, (Object)"end must be less than or equal to 65535.");
        this.start = start;
        this.end = end;
    }

    public static ValidPort of() {
        return ValidPort.of(1025, 65535);
    }

    public static ValidPort of(int start, int end) {
        return new ValidPort(start, end);
    }

    public void ensureValid(String setting, Object value) {
        if (null == value || !(value instanceof Integer)) {
            throw new ConfigException(setting, (Object)"Must be an integer.");
        }
        Integer port = (Integer)value;
        if (port < this.start || port > this.end) {
            throw new ConfigException(setting, (Object)String.format("(%s) must be between %s and %s.", port, this.start, this.end));
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("start", this.start).add("end", this.end).toString();
    }
}

