/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.config.validators.filesystem;

import com.github.jcustenborder.kafka.connect.utils.config.validators.filesystem.ValidFileSystem;
import java.io.File;
import org.apache.kafka.common.config.ConfigException;

public class ValidDirectory
extends ValidFileSystem {
    private ValidDirectory() {
        this(false);
    }

    protected ValidDirectory(boolean ensureWritable) {
        super(ensureWritable);
    }

    @Override
    protected void ensureValid(String setting, Object input, File file) {
        if (!file.isDirectory()) {
            throw new ConfigException(setting, (Object)String.format("'%s' must be a directory.", file));
        }
    }

    public static ValidDirectory of() {
        return new ValidDirectory();
    }

    public String toString() {
        return "Absolute path to a directory that exists.";
    }
}

