/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.config.validators;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

class ValidURI
implements ConfigDef.Validator {
    final Set<String> validSchemes;

    public ValidURI() {
        this(new String[0]);
    }

    public ValidURI(String ... schemes) {
        this.validSchemes = ImmutableSet.copyOf((Object[])schemes);
    }

    void validate(String config, String value) {
        try {
            URI uri = new URI(value);
            if (!this.validSchemes.isEmpty() && !this.validSchemes.contains(uri.getScheme())) {
                throw new ConfigException(config, (Object)value, String.format("Scheme must be one of the following. '%s'", Joiner.on((String)"', '").join(this.validSchemes)));
            }
        }
        catch (URISyntaxException e) {
            ConfigException configException = new ConfigException(config, (Object)value, "Could not parse to URL.");
            configException.initCause((Throwable)e);
            throw configException;
        }
    }

    public void ensureValid(String config, Object value) {
        if (value instanceof String) {
            this.validate(config, (String)value);
        } else if (value instanceof List) {
            List values = (List)value;
            for (String v : values) {
                this.validate(config, v);
            }
        } else {
            throw new ConfigException(config, value, "Must be a string or list.");
        }
    }
}

