/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.config.validators.filesystem;

import com.google.common.base.Strings;
import java.io.File;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ValidFileSystem
implements ConfigDef.Validator {
    private static final Logger log = LoggerFactory.getLogger(ValidFileSystem.class);
    public final boolean ensureWritable;

    protected ValidFileSystem(boolean ensureWritable) {
        this.ensureWritable = ensureWritable;
    }

    protected abstract void ensureValid(String var1, Object var2, File var3);

    public void ensureValid(String setting, Object input) {
        log.trace("ensureValid('{}', '{}')", (Object)setting, input);
        if (!(input instanceof String)) {
            throw new ConfigException(setting, (Object)"Input must be a string.");
        }
        String value = input.toString();
        if (Strings.isNullOrEmpty((String)value)) {
            throw new ConfigException(setting, (Object)"Cannot be null or empty.");
        }
        File file = new File(value);
        if (!file.isAbsolute()) {
            throw new ConfigException(setting, (Object)String.format("File '%s' is not an absolute path.", file));
        }
        this.ensureValid(setting, input, file);
        if (this.ensureWritable && !file.canWrite()) {
            throw new ConfigException(setting, (Object)String.format("File '%s' should be writable.", file));
        }
        if (!file.canRead()) {
            throw new ConfigException(setting, (Object)String.format("File '%s' should be readable.", file));
        }
    }
}

