/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.github.jcustenborder.kafka.connect.utils.jackson.KeyValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructSerializationModule
extends SimpleModule {
    private static final Logger log = LoggerFactory.getLogger(StructSerializationModule.class);

    public StructSerializationModule() {
        this.addSerializer(Struct.class, new Serializer());
        this.addDeserializer(Struct.class, new Deserializer());
    }

    static class Deserializer
    extends JsonDeserializer<Struct> {
        Deserializer() {
        }

        public Struct deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Storage storage = (Storage)jsonParser.readValueAs(Storage.class);
            return storage.build();
        }
    }

    static class Serializer
    extends JsonSerializer<Struct> {
        Serializer() {
        }

        public void serialize(Struct struct, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            struct.validate();
            Storage result = new Storage();
            result.schema = struct.schema();
            result.keyValues = new ArrayList<KeyValue>();
            for (Field field : struct.schema().fields()) {
                log.trace("serialize() - Processing field '{}'", (Object)field.name());
                KeyValue keyValue = new KeyValue();
                keyValue.name = field.name();
                keyValue.schema = field.schema();
                keyValue.value(struct.get(field));
                result.keyValues.add(keyValue);
            }
            jsonGenerator.writeObject((Object)result);
        }
    }

    public static class Storage {
        public Schema schema;
        public List<KeyValue> keyValues;

        public Struct build() {
            log.trace("build() - Creating struct for {}", (Object)this.schema);
            Struct struct = new Struct(this.schema);
            for (KeyValue keyValue : this.keyValues) {
                log.trace("build() - Setting field value for '{}'", (Object)keyValue.name);
                struct.put(keyValue.name, keyValue.value());
            }
            struct.validate();
            return struct;
        }
    }
}

