/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.config.validators;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.apache.kafka.common.config.ConfigDef;

class BlankOrValidator
implements ConfigDef.Validator {
    final ConfigDef.Validator validator;

    BlankOrValidator(ConfigDef.Validator validator) {
        Preconditions.checkNotNull((Object)validator, (Object)"validator cannot be null.");
        this.validator = validator;
    }

    public void ensureValid(String key, Object o) {
        String s;
        if (o instanceof String && !Strings.isNullOrEmpty((String)(s = o.toString()))) {
            this.validator.ensureValid(key, o);
        }
    }

    public String toString() {
        return String.format("Empty String or %s", this.validator);
    }

    public static ConfigDef.Validator of(ConfigDef.Validator validator) {
        return new BlankOrValidator(validator);
    }
}

