/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.github.jcustenborder.kafka.connect.utils.jackson.ValueHelper;
import com.github.jcustenborder.repackaged.com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructSerializationModule
extends SimpleModule {
    private static final Logger log = LoggerFactory.getLogger(StructSerializationModule.class);

    public StructSerializationModule() {
        this.addSerializer(Struct.class, new Serializer());
        this.addDeserializer(Struct.class, new Deserializer());
    }

    static class Deserializer
    extends JsonDeserializer<Struct> {
        Deserializer() {
        }

        public Struct deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Storage storage = (Storage)jsonParser.readValueAs(Storage.class);
            return storage.build();
        }
    }

    static class Serializer
    extends JsonSerializer<Struct> {
        Serializer() {
        }

        public void serialize(Struct struct, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            struct.validate();
            Storage result = new Storage();
            result.schema = struct.schema();
            result.fieldValues = new ArrayList<FieldValue>();
            for (Field field : struct.schema().fields()) {
                log.trace("serialize() - Processing field '{}'", (Object)field.name());
                FieldValue fieldValue = new FieldValue();
                fieldValue.name = field.name();
                fieldValue.schema = field.schema();
                fieldValue.value(struct.get(field));
                result.fieldValues.add(fieldValue);
            }
            jsonGenerator.writeObject((Object)result);
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class FieldValue {
        String name;
        Schema schema;
        private Object storage;
        private Struct struct;

        void value(Object value) {
            log.trace("value(Object) - name = '{}', schema.type() = {}", (Object)this.name, (Object)this.schema.type());
            if (value != null) {
                switch (this.schema.type()) {
                    case STRUCT: {
                        Preconditions.checkState(value instanceof Struct, "value must be a struct.");
                        this.struct = (Struct)value;
                        break;
                    }
                    default: {
                        this.storage = value;
                    }
                }
            }
        }

        Object value() {
            Object result;
            log.trace("value() - name = '{}'", (Object)this.name);
            switch (this.schema.type()) {
                case MAP: {
                    Preconditions.checkState(this.storage == null || this.storage instanceof Map, "storage should be a Map.");
                    if (null != this.storage) {
                        Map input = (Map)this.storage;
                        log.trace("value() - converting storage map of {} value(s) to Map<{}, {}>", new Object[]{input.size(), this.schema.keySchema(), this.schema.valueSchema()});
                        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(input.size());
                        for (Map.Entry kvp : input.entrySet()) {
                            log.trace("value() - converting key.");
                            Object key = ValueHelper.value(this.schema.keySchema(), kvp.getKey());
                            log.trace("value() - converting value.");
                            Object value = ValueHelper.value(this.schema.valueSchema(), kvp.getValue());
                            map.put(key, value);
                        }
                        result = map;
                        break;
                    }
                    result = null;
                    break;
                }
                case ARRAY: {
                    Preconditions.checkState(this.storage == null || this.storage instanceof List, "storage should be a List.");
                    if (null != this.storage) {
                        List input = (List)this.storage;
                        log.trace("value() - converting storage map of {} value(s) to List<{}>", (Object)input.size(), (Object)this.schema.valueSchema());
                        ArrayList<Object> list = new ArrayList<Object>(input.size());
                        for (Object o : input) {
                            log.trace("value() - converting key.");
                            Object value = ValueHelper.value(this.schema.valueSchema(), o);
                            list.add(value);
                        }
                        result = list;
                        break;
                    }
                    result = null;
                    break;
                }
                case STRUCT: {
                    result = this.struct;
                    break;
                }
                default: {
                    result = ValueHelper.value(this.schema, this.storage);
                }
            }
            return result;
        }
    }

    public static class Storage {
        public Schema schema;
        public List<FieldValue> fieldValues;

        public Struct build() {
            log.trace("build() - Creating struct for {}", (Object)this.schema);
            Struct struct = new Struct(this.schema);
            for (FieldValue fieldValue : this.fieldValues) {
                log.trace("build() - Setting field value for '{}'", (Object)fieldValue.name);
                struct.put(fieldValue.name, fieldValue.value());
            }
            struct.validate();
            return struct;
        }
    }
}

