/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.config;

import com.github.jcustenborder.repackaged.com.google.common.base.CaseFormat;
import com.github.jcustenborder.repackaged.com.google.common.base.Joiner;
import com.github.jcustenborder.repackaged.com.google.common.base.Preconditions;
import com.github.jcustenborder.repackaged.com.google.common.base.Strings;
import com.github.jcustenborder.repackaged.com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;

public class MarkdownFormatter {
    private static List<ConfigDef.ConfigKey> getSortedList(Map<String, ConfigDef.ConfigKey> configKeys) {
        ArrayList<ConfigDef.ConfigKey> configs = new ArrayList<ConfigDef.ConfigKey>(configKeys.values());
        Collections.sort(configs, new Comparator<ConfigDef.ConfigKey>(){

            @Override
            public int compare(ConfigDef.ConfigKey k1, ConfigDef.ConfigKey k2) {
                if (!k1.hasDefault() && k2.hasDefault()) {
                    return -1;
                }
                if (!k2.hasDefault() && k1.hasDefault()) {
                    return 1;
                }
                int cmp = k1.importance.compareTo((Enum)k2.importance);
                if (cmp == 0) {
                    return k1.name.compareTo(k2.name);
                }
                return cmp;
            }
        });
        return configs;
    }

    static String getDefaultValue(ConfigDef.ConfigKey def) {
        if (def.hasDefault()) {
            if (def.defaultValue == null) {
                return "null";
            }
            if (def.type == ConfigDef.Type.STRING && def.defaultValue.toString().isEmpty()) {
                return "\"\"";
            }
            return def.defaultValue.toString();
        }
        return "";
    }

    public static String toMarkdown(ConfigDef configDef) {
        List<ConfigDef.ConfigKey> sortedConfigs = MarkdownFormatter.getSortedList(configDef.configKeys());
        String[] headers = new String[]{"Name", "Description", "Type", "Default", "Valid Values", "Importance"};
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        rows.add(Arrays.asList(headers));
        for (ConfigDef.ConfigKey def : sortedConfigs) {
            ArrayList<String> row = new ArrayList<String>(headers.length);
            for (int i = 0; i < headers.length; ++i) {
                String value;
                switch (i) {
                    case 0: {
                        value = def.name;
                        break;
                    }
                    case 1: {
                        value = null == def.documentation ? "" : def.documentation;
                        break;
                    }
                    case 2: {
                        value = def.type.toString().toLowerCase();
                        break;
                    }
                    case 3: {
                        String defaultValue = MarkdownFormatter.getDefaultValue(def);
                        value = null == defaultValue ? "" : defaultValue;
                        break;
                    }
                    case 4: {
                        String validValues = def.validator != null ? def.validator.toString() : "";
                        value = null == validValues ? "" : validValues;
                        break;
                    }
                    case 5: {
                        value = def.importance.toString().toLowerCase();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("There are more headers than columns.");
                    }
                }
                row.add(value);
            }
            rows.add(row);
        }
        return MarkdownFormatter.markdownTable(rows);
    }

    static List<Integer> lengths(List<List<String>> rows) {
        ArrayList<Integer> lengths = new ArrayList<Integer>(rows.size());
        for (int i = 0; i < rows.get(0).size(); ++i) {
            lengths.add(rows.get(0).get(i).length());
        }
        for (List<String> row : rows) {
            for (int i = 0; i < row.size(); ++i) {
                int previous = (Integer)lengths.get(i);
                int current = Strings.isNullOrEmpty(row.get(i)) ? 0 : row.get(i).length();
                int value = Math.max(current, previous);
                lengths.set(i, value);
            }
        }
        return lengths;
    }

    static String markdownTable(List<List<String>> rows) {
        StringBuilder builder = new StringBuilder();
        List<Integer> lengths = MarkdownFormatter.lengths(rows);
        int index = 0;
        for (List<String> row : rows) {
            ArrayList<String> copy = new ArrayList<String>(row.size());
            for (int i = 0; i < row.size(); ++i) {
                String f = Strings.padEnd(row.get(i) == null ? "" : row.get(i), lengths.get(i), ' ');
                copy.add(f);
            }
            builder.append("| ");
            Joiner.on(" | ").appendTo(builder, (Iterable<?>)copy);
            builder.append(" |\n");
            if (index == 0) {
                ArrayList<String> bar = new ArrayList<String>(lengths.size());
                for (Integer length : lengths) {
                    bar.add(Strings.repeat("-", length + 2));
                }
                builder.append("|");
                Joiner.on("|").appendTo(builder, (Iterable<?>)bar);
                builder.append("|\n");
            }
            ++index;
        }
        return builder.toString();
    }

    static String schema(Schema schema) {
        String result = !Strings.isNullOrEmpty(schema.name()) ? ("org.apache.kafka.connect.data.Time".equals(schema.name()) ? "[Time](https://kafka.apache.org/0102/javadoc/org/apache/kafka/connect/data/Time.html)" : ("org.apache.kafka.connect.data.Date".equals(schema.name()) ? "[Date](https://kafka.apache.org/0102/javadoc/org/apache/kafka/connect/data/Date.html)" : ("org.apache.kafka.connect.data.Timestamp".equals(schema.name()) ? "[Timestamp](https://kafka.apache.org/0102/javadoc/org/apache/kafka/connect/data/Timestamp.html)" : ("org.apache.kafka.connect.data.Decimal".equals(schema.name()) ? "[Decimal](https://kafka.apache.org/0102/javadoc/org/apache/kafka/connect/data/Decimal.html)" : String.format("[%s](#%s)", schema.name(), schema.name()))))) : (Schema.Type.ARRAY == schema.type() ? String.format("Array of %s", MarkdownFormatter.schema(schema.valueSchema())) : (Schema.Type.MAP == schema.type() ? String.format("Map of <%s, %s>", MarkdownFormatter.schema(schema.keySchema()), MarkdownFormatter.schema(schema.valueSchema())) : String.format("[%s](https://kafka.apache.org/0102/javadoc/org/apache/kafka/connect/data/Schema.Type.html#%s)", CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, schema.type().toString()), schema.type())));
        return result;
    }

    public static String toMarkdown(Schema schema) {
        Preconditions.checkNotNull(schema, "schema cannot be null.");
        StringBuilder builder = new StringBuilder();
        builder.append("## ");
        if (Strings.isNullOrEmpty(schema.name())) {
            builder.append(schema.type());
        } else {
            builder.append(schema.name());
        }
        if (!Strings.isNullOrEmpty(schema.doc())) {
            builder.append("\n\n");
            builder.append(schema.doc());
        }
        if (Schema.Type.STRUCT == schema.type()) {
            ArrayList<List<String>> rows = new ArrayList<List<String>>();
            rows.add(ImmutableList.of("Name", "Optional", "Schema", "Default Value", "Documentation"));
            for (Field field : schema.fields()) {
                Schema fieldSchema = field.schema();
                ImmutableList<String> row = ImmutableList.of(field.name(), String.valueOf(fieldSchema.isOptional()), MarkdownFormatter.schema(fieldSchema), fieldSchema.defaultValue() == null ? "" : fieldSchema.defaultValue().toString(), Strings.isNullOrEmpty(fieldSchema.doc()) ? "" : fieldSchema.doc());
                rows.add(row);
            }
            builder.append("\n\n");
            builder.append(MarkdownFormatter.markdownTable(rows));
        } else if (Schema.Type.MAP == schema.type()) {
            // empty if block
        }
        return builder.toString();
    }
}

