/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.apache.kafka.common.utils.Time;

public class TimeSerializationModule
extends SimpleModule {
    public TimeSerializationModule() {
        this.addSerializer(Time.class, new Serializer());
        this.addDeserializer(Time.class, new Deserializer());
    }

    static class Deserializer
    extends JsonDeserializer<Time> {
        Deserializer() {
        }

        public Time deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            Storage storage = (Storage)jsonParser.readValueAs(Storage.class);
            return storage;
        }
    }

    static class Serializer
    extends JsonSerializer<Time> {
        Serializer() {
        }

        public void serialize(Time time, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            Storage storage = new Storage(time);
            jsonGenerator.writeObject((Object)storage);
        }
    }

    public static class Storage
    implements Time {
        public long milliseconds;
        public long nanoseconds;

        public Storage() {
        }

        public Storage(Time time) {
            this.milliseconds = time.milliseconds();
            this.nanoseconds = time.nanoseconds();
        }

        public long milliseconds() {
            return this.milliseconds;
        }

        public long nanoseconds() {
            return this.nanoseconds;
        }

        public void sleep(long l) {
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

