/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.jackson;

import com.google.common.io.BaseEncoding;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ValueHelper {
    static final Logger log = LoggerFactory.getLogger(ValueHelper.class);

    ValueHelper() {
    }

    static Object int8(Object o) {
        if (o instanceof Long) {
            Number number = (Number)o;
            return number.byteValue();
        }
        return o;
    }

    static Object int16(Object o) {
        if (o instanceof Long) {
            Number number = (Number)o;
            return number.shortValue();
        }
        return o;
    }

    static Object int32(Object o) {
        if (o instanceof Long) {
            Number number = (Number)o;
            return number.intValue();
        }
        return o;
    }

    static Object int64(Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.longValue();
        }
        return value;
    }

    static Object float64(Object o) {
        if (o instanceof Number) {
            Number integer = (Number)o;
            return integer.doubleValue();
        }
        return o;
    }

    static Object float32(Object o) {
        if (o instanceof Number) {
            Number integer = (Number)o;
            return Float.valueOf(integer.floatValue());
        }
        return o;
    }

    static Object bytes(Object value) {
        if (value instanceof String) {
            String s = (String)value;
            return BaseEncoding.base64().decode((CharSequence)s);
        }
        return value;
    }

    static Object decimal(Schema schema, Object value) {
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return Decimal.toLogical((Schema)schema, (byte[])bytes);
        }
        if (value instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)value;
            int scale = Integer.parseInt((String)schema.parameters().get("scale"));
            if (scale == decimal.scale()) {
                return decimal;
            }
            return decimal.setScale(scale);
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            int scale = Integer.parseInt((String)schema.parameters().get("scale"));
            BigDecimal decimal = BigDecimal.valueOf(number.longValue(), scale);
            return decimal;
        }
        return value;
    }

    static Object date(Schema schema, Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            return org.apache.kafka.connect.data.Date.toLogical((Schema)schema, (int)number.intValue());
        }
        return value;
    }

    static Object time(Schema schema, Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            return Time.toLogical((Schema)schema, (int)number.intValue());
        }
        return value;
    }

    static Object timestamp(Schema schema, Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            return Timestamp.toLogical((Schema)schema, (long)number.longValue());
        }
        return value;
    }

    public static Object value(Schema schema, Object value) {
        Object result;
        if (null == value) {
            return null;
        }
        switch (schema.type()) {
            case BYTES: {
                if ("org.apache.kafka.connect.data.Decimal".equals(schema.name())) {
                    result = ValueHelper.decimal(schema, value);
                    break;
                }
                result = ValueHelper.bytes(value);
                break;
            }
            case INT32: {
                if ("org.apache.kafka.connect.data.Date".equals(schema.name())) {
                    result = ValueHelper.date(schema, value);
                    break;
                }
                if ("org.apache.kafka.connect.data.Time".equals(schema.name())) {
                    result = ValueHelper.time(schema, value);
                    break;
                }
                result = ValueHelper.int32(value);
                break;
            }
            case INT16: {
                result = ValueHelper.int16(value);
                break;
            }
            case INT64: {
                if ("org.apache.kafka.connect.data.Timestamp".equals(schema.name())) {
                    result = ValueHelper.timestamp(schema, value);
                    break;
                }
                result = ValueHelper.int64(value);
                break;
            }
            case INT8: {
                result = ValueHelper.int8(value);
                break;
            }
            case FLOAT32: {
                result = ValueHelper.float32(value);
                break;
            }
            case FLOAT64: {
                result = ValueHelper.float64(value);
                break;
            }
            case STRUCT: {
                log.trace("struct");
            }
            default: {
                result = value;
            }
        }
        return result;
    }

    public Object convert(Object value) {
        Object result;
        if (value instanceof java.sql.Date) {
            java.sql.Date d = (java.sql.Date)value;
            result = new Date(d.getTime());
        } else {
            result = value;
        }
        return result;
    }
}

