/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.data.type;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.jcustenborder.kafka.connect.utils.data.type.TypeParser;
import com.google.common.base.Preconditions;
import org.apache.kafka.connect.data.Schema;

public class Float64TypeParser
implements TypeParser {
    @Override
    public Object parseString(String s, Schema schema) {
        return Double.parseDouble(s);
    }

    @Override
    public Class<?> expectedClass() {
        return Double.class;
    }

    @Override
    public Object parseJsonNode(JsonNode input, Schema schema) {
        Preconditions.checkState((input.isFloat() || input.isDouble() ? 1 : 0) != 0, (String)"'%s' is not a '%s'", (Object[])new Object[]{input.asText(), this.expectedClass().getSimpleName()});
        return input.decimalValue().doubleValue();
    }
}

