/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.github.jcustenborder.kafka.connect.utils.templates.Notes;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Notes.Section", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableSection
implements Notes.Section {
    private final String title;
    private final String text;

    private ImmutableSection(String title, String text) {
        this.title = title;
        this.text = text;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public final ImmutableSection withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableSection(newValue, this.text);
    }

    public final ImmutableSection withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new ImmutableSection(this.title, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSection && this.equalTo((ImmutableSection)another);
    }

    private boolean equalTo(ImmutableSection another) {
        return this.title.equals(another.title) && this.text.equals(another.text);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.text.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Section").omitNullValues().add("title", (Object)this.title).add("text", (Object)this.text).toString();
    }

    public static ImmutableSection copyOf(Notes.Section instance) {
        if (instance instanceof ImmutableSection) {
            return (ImmutableSection)instance;
        }
        return ImmutableSection.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Notes.Section", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private static final long INIT_BIT_TEXT = 2L;
        private long initBits = 3L;
        @Nullable
        private String title;
        @Nullable
        private String text;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Notes.Section instance) {
            Objects.requireNonNull(instance, "instance");
            this.title(instance.getTitle());
            this.text(instance.getText());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder text(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSection build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSection(this.title, this.text);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("title");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("text");
            }
            return "Cannot build Section, some of required attributes are not set " + attributes;
        }
    }
}

