/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.github.jcustenborder.kafka.connect.utils.templates.Plugin;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Plugin.SinkConnectorExampleInput", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableSinkConnectorExampleInput
implements Plugin.SinkConnectorExampleInput {
    @Nullable
    private final String config;
    private final Plugin.SinkConnectorExample example;
    @Nullable
    private final String inputJson;
    @Nullable
    private final String inputDescription;
    @Nullable
    private final String outputJson;
    @Nullable
    private final String outputDescription;

    private ImmutableSinkConnectorExampleInput(@Nullable String config, Plugin.SinkConnectorExample example, @Nullable String inputJson, @Nullable String inputDescription, @Nullable String outputJson, @Nullable String outputDescription) {
        this.config = config;
        this.example = example;
        this.inputJson = inputJson;
        this.inputDescription = inputDescription;
        this.outputJson = outputJson;
        this.outputDescription = outputDescription;
    }

    @Override
    @Nullable
    public String getConfig() {
        return this.config;
    }

    @Override
    public Plugin.SinkConnectorExample getExample() {
        return this.example;
    }

    @Override
    @Nullable
    public String getInputJson() {
        return this.inputJson;
    }

    @Override
    @Nullable
    public String getInputDescription() {
        return this.inputDescription;
    }

    @Override
    @Nullable
    public String getOutputJson() {
        return this.outputJson;
    }

    @Override
    @Nullable
    public String getOutputDescription() {
        return this.outputDescription;
    }

    public final ImmutableSinkConnectorExampleInput withConfig(@Nullable String value) {
        if (Objects.equals(this.config, value)) {
            return this;
        }
        return new ImmutableSinkConnectorExampleInput(value, this.example, this.inputJson, this.inputDescription, this.outputJson, this.outputDescription);
    }

    public final ImmutableSinkConnectorExampleInput withExample(Plugin.SinkConnectorExample value) {
        if (this.example == value) {
            return this;
        }
        Plugin.SinkConnectorExample newValue = Objects.requireNonNull(value, "example");
        return new ImmutableSinkConnectorExampleInput(this.config, newValue, this.inputJson, this.inputDescription, this.outputJson, this.outputDescription);
    }

    public final ImmutableSinkConnectorExampleInput withInputJson(@Nullable String value) {
        if (Objects.equals(this.inputJson, value)) {
            return this;
        }
        return new ImmutableSinkConnectorExampleInput(this.config, this.example, value, this.inputDescription, this.outputJson, this.outputDescription);
    }

    public final ImmutableSinkConnectorExampleInput withInputDescription(@Nullable String value) {
        if (Objects.equals(this.inputDescription, value)) {
            return this;
        }
        return new ImmutableSinkConnectorExampleInput(this.config, this.example, this.inputJson, value, this.outputJson, this.outputDescription);
    }

    public final ImmutableSinkConnectorExampleInput withOutputJson(@Nullable String value) {
        if (Objects.equals(this.outputJson, value)) {
            return this;
        }
        return new ImmutableSinkConnectorExampleInput(this.config, this.example, this.inputJson, this.inputDescription, value, this.outputDescription);
    }

    public final ImmutableSinkConnectorExampleInput withOutputDescription(@Nullable String value) {
        if (Objects.equals(this.outputDescription, value)) {
            return this;
        }
        return new ImmutableSinkConnectorExampleInput(this.config, this.example, this.inputJson, this.inputDescription, this.outputJson, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSinkConnectorExampleInput && this.equalTo((ImmutableSinkConnectorExampleInput)another);
    }

    private boolean equalTo(ImmutableSinkConnectorExampleInput another) {
        return Objects.equals(this.config, another.config) && this.example.equals(another.example) && Objects.equals(this.inputJson, another.inputJson) && Objects.equals(this.inputDescription, another.inputDescription) && Objects.equals(this.outputJson, another.outputJson) && Objects.equals(this.outputDescription, another.outputDescription);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.config);
        h += (h << 5) + this.example.hashCode();
        h += (h << 5) + Objects.hashCode(this.inputJson);
        h += (h << 5) + Objects.hashCode(this.inputDescription);
        h += (h << 5) + Objects.hashCode(this.outputJson);
        h += (h << 5) + Objects.hashCode(this.outputDescription);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SinkConnectorExampleInput").omitNullValues().add("config", (Object)this.config).add("example", (Object)this.example).add("inputJson", (Object)this.inputJson).add("inputDescription", (Object)this.inputDescription).add("outputJson", (Object)this.outputJson).add("outputDescription", (Object)this.outputDescription).toString();
    }

    public static ImmutableSinkConnectorExampleInput copyOf(Plugin.SinkConnectorExampleInput instance) {
        if (instance instanceof ImmutableSinkConnectorExampleInput) {
            return (ImmutableSinkConnectorExampleInput)instance;
        }
        return ImmutableSinkConnectorExampleInput.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Plugin.SinkConnectorExampleInput", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_EXAMPLE = 1L;
        private long initBits = 1L;
        @Nullable
        private String config;
        @Nullable
        private Plugin.SinkConnectorExample example;
        @Nullable
        private String inputJson;
        @Nullable
        private String inputDescription;
        @Nullable
        private String outputJson;
        @Nullable
        private String outputDescription;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Plugin.SinkConnectorExampleInput instance) {
            String outputDescriptionValue;
            String outputJsonValue;
            String inputDescriptionValue;
            Objects.requireNonNull(instance, "instance");
            String configValue = instance.getConfig();
            if (configValue != null) {
                this.config(configValue);
            }
            this.example((Plugin.SinkConnectorExample)instance.getExample());
            String inputJsonValue = instance.getInputJson();
            if (inputJsonValue != null) {
                this.inputJson(inputJsonValue);
            }
            if ((inputDescriptionValue = instance.getInputDescription()) != null) {
                this.inputDescription(inputDescriptionValue);
            }
            if ((outputJsonValue = instance.getOutputJson()) != null) {
                this.outputJson(outputJsonValue);
            }
            if ((outputDescriptionValue = instance.getOutputDescription()) != null) {
                this.outputDescription(outputDescriptionValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder config(@Nullable String config) {
            this.config = config;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder example(Plugin.SinkConnectorExample example) {
            this.example = Objects.requireNonNull(example, "example");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder inputJson(@Nullable String inputJson) {
            this.inputJson = inputJson;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder inputDescription(@Nullable String inputDescription) {
            this.inputDescription = inputDescription;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder outputJson(@Nullable String outputJson) {
            this.outputJson = outputJson;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder outputDescription(@Nullable String outputDescription) {
            this.outputDescription = outputDescription;
            return this;
        }

        public ImmutableSinkConnectorExampleInput build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSinkConnectorExampleInput(this.config, this.example, this.inputJson, this.inputDescription, this.outputJson, this.outputDescription);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("example");
            }
            return "Cannot build SinkConnectorExampleInput, some of required attributes are not set " + attributes;
        }
    }
}

