/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.github.jcustenborder.kafka.connect.utils.templates.Notes;
import com.github.jcustenborder.kafka.connect.utils.templates.Plugin;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Plugin.ConfigProvider", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableConfigProvider
implements Plugin.ConfigProvider {
    @Nullable
    private final String warning;
    @Nullable
    private final String tip;
    @Nullable
    private final String important;
    @Nullable
    private final String danger;
    @Nullable
    private final String note;
    @Nullable
    private final String title;
    @Nullable
    private final String description;
    @Nullable
    private final String icon;
    @Nullable
    private final String introduction;
    @Nullable
    private final ImmutableList<Notes.Section> sections;
    private final Class cls;
    @Nullable
    private final Plugin.Configuration configuration;
    private final ImmutableList<String> examples;

    private ImmutableConfigProvider(@Nullable String warning, @Nullable String tip, @Nullable String important, @Nullable String danger, @Nullable String note, @Nullable String title, @Nullable String description, @Nullable String icon, @Nullable String introduction, @Nullable ImmutableList<Notes.Section> sections, Class cls, @Nullable Plugin.Configuration configuration, ImmutableList<String> examples) {
        this.warning = warning;
        this.tip = tip;
        this.important = important;
        this.danger = danger;
        this.note = note;
        this.title = title;
        this.description = description;
        this.icon = icon;
        this.introduction = introduction;
        this.sections = sections;
        this.cls = cls;
        this.configuration = configuration;
        this.examples = examples;
    }

    @Override
    @Nullable
    public String getWarning() {
        return this.warning;
    }

    @Override
    @Nullable
    public String getTip() {
        return this.tip;
    }

    @Override
    @Nullable
    public String getImportant() {
        return this.important;
    }

    @Override
    @Nullable
    public String getDanger() {
        return this.danger;
    }

    @Override
    @Nullable
    public String getNote() {
        return this.note;
    }

    @Override
    @Nullable
    public String getTitle() {
        return this.title;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public String getIcon() {
        return this.icon;
    }

    @Override
    @Nullable
    public String getIntroduction() {
        return this.introduction;
    }

    @Nullable
    public ImmutableList<Notes.Section> getSections() {
        return this.sections;
    }

    @Override
    public Class getCls() {
        return this.cls;
    }

    @Override
    @Nullable
    public Plugin.Configuration getConfiguration() {
        return this.configuration;
    }

    public ImmutableList<String> getExamples() {
        return this.examples;
    }

    public final ImmutableConfigProvider withWarning(@Nullable String value) {
        if (Objects.equals(this.warning, value)) {
            return this;
        }
        return new ImmutableConfigProvider(value, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.sections, this.cls, this.configuration, this.examples);
    }

    public final ImmutableConfigProvider withTip(@Nullable String value) {
        if (Objects.equals(this.tip, value)) {
            return this;
        }
        return new ImmutableConfigProvider(this.warning, value, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.sections, this.cls, this.configuration, this.examples);
    }

    public final ImmutableConfigProvider withImportant(@Nullable String value) {
        if (Objects.equals(this.important, value)) {
            return this;
        }
        return new ImmutableConfigProvider(this.warning, this.tip, value, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.sections, this.cls, this.configuration, this.examples);
    }

    public final ImmutableConfigProvider withDanger(@Nullable String value) {
        if (Objects.equals(this.danger, value)) {
            return this;
        }
        return new ImmutableConfigProvider(this.warning, this.tip, this.important, value, this.note, this.title, this.description, this.icon, this.introduction, this.sections, this.cls, this.configuration, this.examples);
    }

    public final ImmutableConfigProvider withNote(@Nullable String value) {
        if (Objects.equals(this.note, value)) {
            return this;
        }
        return new ImmutableConfigProvider(this.warning, this.tip, this.important, this.danger, value, this.title, this.description, this.icon, this.introduction, this.sections, this.cls, this.configuration, this.examples);
    }

    public final ImmutableConfigProvider withTitle(@Nullable String value) {
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutableConfigProvider(this.warning, this.tip, this.important, this.danger, this.note, value, this.description, this.icon, this.introduction, this.sections, this.cls, this.configuration, this.examples);
    }

    public final ImmutableConfigProvider withDescription(@Nullable String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableConfigProvider(this.warning, this.tip, this.important, this.danger, this.note, this.title, value, this.icon, this.introduction, this.sections, this.cls, this.configuration, this.examples);
    }

    public final ImmutableConfigProvider withIcon(@Nullable String value) {
        if (Objects.equals(this.icon, value)) {
            return this;
        }
        return new ImmutableConfigProvider(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, value, this.introduction, this.sections, this.cls, this.configuration, this.examples);
    }

    public final ImmutableConfigProvider withIntroduction(@Nullable String value) {
        if (Objects.equals(this.introduction, value)) {
            return this;
        }
        return new ImmutableConfigProvider(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, value, this.sections, this.cls, this.configuration, this.examples);
    }

    public final ImmutableConfigProvider withSections(Notes.Section ... elements) {
        if (elements == null) {
            return new ImmutableConfigProvider(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, null, this.cls, this.configuration, this.examples);
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf((Object[])elements);
        return new ImmutableConfigProvider(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, (ImmutableList<Notes.Section>)newValue, this.cls, this.configuration, this.examples);
    }

    public final ImmutableConfigProvider withSections(@Nullable Iterable<? extends Notes.Section> elements) {
        if (this.sections == elements) {
            return this;
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableConfigProvider(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, (ImmutableList<Notes.Section>)newValue, this.cls, this.configuration, this.examples);
    }

    public final ImmutableConfigProvider withCls(Class value) {
        if (this.cls == value) {
            return this;
        }
        Class newValue = Objects.requireNonNull(value, "cls");
        return new ImmutableConfigProvider(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.sections, newValue, this.configuration, this.examples);
    }

    public final ImmutableConfigProvider withConfiguration(@Nullable Plugin.Configuration value) {
        if (this.configuration == value) {
            return this;
        }
        return new ImmutableConfigProvider(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.sections, this.cls, value, this.examples);
    }

    public final ImmutableConfigProvider withExamples(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableConfigProvider(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.sections, this.cls, this.configuration, (ImmutableList<String>)newValue);
    }

    public final ImmutableConfigProvider withExamples(Iterable<String> elements) {
        if (this.examples == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableConfigProvider(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.sections, this.cls, this.configuration, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConfigProvider && this.equalTo((ImmutableConfigProvider)another);
    }

    private boolean equalTo(ImmutableConfigProvider another) {
        return Objects.equals(this.warning, another.warning) && Objects.equals(this.tip, another.tip) && Objects.equals(this.important, another.important) && Objects.equals(this.danger, another.danger) && Objects.equals(this.note, another.note) && Objects.equals(this.title, another.title) && Objects.equals(this.description, another.description) && Objects.equals(this.icon, another.icon) && Objects.equals(this.introduction, another.introduction) && Objects.equals(this.sections, another.sections) && this.cls.equals(another.cls) && Objects.equals(this.configuration, another.configuration) && this.examples.equals(another.examples);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.warning);
        h += (h << 5) + Objects.hashCode(this.tip);
        h += (h << 5) + Objects.hashCode(this.important);
        h += (h << 5) + Objects.hashCode(this.danger);
        h += (h << 5) + Objects.hashCode(this.note);
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.icon);
        h += (h << 5) + Objects.hashCode(this.introduction);
        h += (h << 5) + Objects.hashCode(this.sections);
        h += (h << 5) + this.cls.hashCode();
        h += (h << 5) + Objects.hashCode(this.configuration);
        h += (h << 5) + this.examples.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ConfigProvider").omitNullValues().add("warning", (Object)this.warning).add("tip", (Object)this.tip).add("important", (Object)this.important).add("danger", (Object)this.danger).add("note", (Object)this.note).add("title", (Object)this.title).add("description", (Object)this.description).add("icon", (Object)this.icon).add("introduction", (Object)this.introduction).add("sections", this.sections).add("cls", (Object)this.cls).add("configuration", (Object)this.configuration).add("examples", this.examples).toString();
    }

    public static ImmutableConfigProvider copyOf(Plugin.ConfigProvider instance) {
        if (instance instanceof ImmutableConfigProvider) {
            return (ImmutableConfigProvider)instance;
        }
        return ImmutableConfigProvider.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Plugin.ConfigProvider", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CLS = 1L;
        private long initBits = 1L;
        @Nullable
        private String warning;
        @Nullable
        private String tip;
        @Nullable
        private String important;
        @Nullable
        private String danger;
        @Nullable
        private String note;
        @Nullable
        private String title;
        @Nullable
        private String description;
        @Nullable
        private String icon;
        @Nullable
        private String introduction;
        private ImmutableList.Builder<Notes.Section> sections = null;
        @Nullable
        private Class cls;
        @Nullable
        private Plugin.Configuration configuration;
        private ImmutableList.Builder<String> examples = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Notes instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Plugin.Configurable instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Plugin.ConfigProvider instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Notes instance;
            if (object instanceof Notes) {
                String introductionValue;
                List<Notes.Section> sectionsValue;
                String titleValue;
                String dangerValue;
                String tipValue;
                String warningValue;
                String descriptionValue;
                String iconValue;
                String noteValue;
                instance = (Notes)object;
                String importantValue = instance.getImportant();
                if (importantValue != null) {
                    this.important(importantValue);
                }
                if ((noteValue = instance.getNote()) != null) {
                    this.note(noteValue);
                }
                if ((iconValue = instance.getIcon()) != null) {
                    this.icon(iconValue);
                }
                if ((descriptionValue = instance.getDescription()) != null) {
                    this.description(descriptionValue);
                }
                if ((warningValue = instance.getWarning()) != null) {
                    this.warning(warningValue);
                }
                if ((tipValue = instance.getTip()) != null) {
                    this.tip(tipValue);
                }
                if ((dangerValue = instance.getDanger()) != null) {
                    this.danger(dangerValue);
                }
                if ((titleValue = instance.getTitle()) != null) {
                    this.title(titleValue);
                }
                if ((sectionsValue = instance.getSections()) != null) {
                    this.addAllSections(sectionsValue);
                }
                if ((introductionValue = instance.getIntroduction()) != null) {
                    this.introduction(introductionValue);
                }
            }
            if (object instanceof Plugin.Configurable) {
                instance = (Plugin.Configurable)object;
                this.addAllExamples(instance.getExamples());
                Plugin.Configuration configurationValue = instance.getConfiguration();
                if (configurationValue != null) {
                    this.configuration(configurationValue);
                }
                this.cls(instance.getCls());
            }
        }

        @CanIgnoreReturnValue
        public final Builder warning(@Nullable String warning) {
            this.warning = warning;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tip(@Nullable String tip) {
            this.tip = tip;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder important(@Nullable String important) {
            this.important = important;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder danger(@Nullable String danger) {
            this.danger = danger;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder note(@Nullable String note) {
            this.note = note;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder icon(@Nullable String icon) {
            this.icon = icon;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder introduction(@Nullable String introduction) {
            this.introduction = introduction;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSections(Notes.Section element) {
            if (this.sections == null) {
                this.sections = ImmutableList.builder();
            }
            this.sections.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSections(Notes.Section ... elements) {
            if (this.sections == null) {
                this.sections = ImmutableList.builder();
            }
            this.sections.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sections(@Nullable Iterable<? extends Notes.Section> elements) {
            if (elements == null) {
                this.sections = null;
                return this;
            }
            this.sections = ImmutableList.builder();
            return this.addAllSections(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSections(Iterable<? extends Notes.Section> elements) {
            Objects.requireNonNull(elements, "sections element");
            if (this.sections == null) {
                this.sections = ImmutableList.builder();
            }
            this.sections.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cls(Class cls) {
            this.cls = Objects.requireNonNull(cls, "cls");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder configuration(@Nullable Plugin.Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExamples(String element) {
            this.examples.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExamples(String ... elements) {
            this.examples.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder examples(Iterable<String> elements) {
            this.examples = ImmutableList.builder();
            return this.addAllExamples(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExamples(Iterable<String> elements) {
            this.examples.addAll(elements);
            return this;
        }

        public ImmutableConfigProvider build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableConfigProvider(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction, this.sections == null ? null : this.sections.build(), this.cls, this.configuration, this.examples.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("cls");
            }
            return "Cannot build ConfigProvider, some of required attributes are not set " + attributes;
        }
    }
}

