/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.difflib.DiffUtils;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.Patch;
import com.github.jcustenborder.kafka.connect.utils.jackson.ObjectMapperFactory;
import com.github.jcustenborder.kafka.connect.utils.templates.ImmutableSchemaInput;
import com.github.jcustenborder.kafka.connect.utils.templates.ImmutableSinkConnectorExampleInput;
import com.github.jcustenborder.kafka.connect.utils.templates.ImmutableSourceConnectorExampleInput;
import com.github.jcustenborder.kafka.connect.utils.templates.ImmutableTransformationExampleInput;
import com.github.jcustenborder.kafka.connect.utils.templates.Plugin;
import com.github.jcustenborder.kafka.connect.utils.templates.PluginLoader;
import com.google.common.base.CaseFormat;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.transforms.Transformation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDocumentationTest {
    private static final Logger log = LoggerFactory.getLogger(BaseDocumentationTest.class);
    static Configuration configuration;
    static ClassTemplateLoader loader;
    final File targetDirectory = new File("target");
    final File outputDirectory = new File(this.targetDirectory, "docs");
    final File sourcesDirectory = new File(this.outputDirectory, "sources");
    final File sourcesExamplesDirectory = new File(this.sourcesDirectory, "examples");
    final File sinksDirectory = new File(this.outputDirectory, "sinks");
    final File sinksExamplesDirectory = new File(this.sinksDirectory, "examples");
    final File transformationsDirectory = new File(this.outputDirectory, "transformations");
    final File convertersDirectory = new File(this.outputDirectory, "converters");
    final File transformationsExampleDirectory = new File(this.transformationsDirectory, "examples");
    Plugin plugin;
    static Map<Package, Plugin> pluginCache;

    protected List<Schema> schemas() {
        return Arrays.asList(new Schema[0]);
    }

    protected Package getPackage() {
        return this.getClass().getPackage();
    }

    @BeforeAll
    public static void loadTemplates() {
        loader = new ClassTemplateLoader(BaseDocumentationTest.class, "templates");
        configuration = new Configuration(Configuration.getVersion());
        configuration.setDefaultEncoding("UTF-8");
        configuration.setTemplateLoader((TemplateLoader)loader);
        configuration.setObjectWrapper((ObjectWrapper)new BeansWrapper(Configuration.getVersion()));
        configuration.setNumberFormat("computer");
    }

    static <T> List<Class<? extends T>> list(Reflections reflections, Package pkg, Class<? extends T> cls) {
        List<Class<? extends T>> classes = reflections.getSubTypesOf(cls).stream().filter(c -> c.getName().startsWith(pkg.getName())).filter(c -> Modifier.isPublic(c.getModifiers())).filter(c -> !Modifier.isAbstract(c.getModifiers())).filter((Predicate<Class>)((com.google.common.base.Predicate)aClass -> Arrays.stream(aClass.getConstructors()).filter(c -> Modifier.isPublic(c.getModifiers())).anyMatch(c -> c.getParameterCount() == 0))).sorted(Comparator.comparing(Class::getName)).collect(Collectors.toList());
        return classes;
    }

    @BeforeEach
    public void before() throws MalformedURLException {
        ObjectMapperFactory.INSTANCE.configure(SerializationFeature.INDENT_OUTPUT, true);
        Arrays.asList(this.targetDirectory, this.outputDirectory, this.sourcesDirectory, this.sourcesExamplesDirectory, this.sinksDirectory, this.sinksExamplesDirectory, this.transformationsDirectory, this.transformationsExampleDirectory, this.convertersDirectory).stream().filter(f -> !f.isDirectory()).forEach(File::mkdirs);
        log.info("before() - {}", this.getClass());
        Package pkg = this.getPackage();
        this.plugin = pluginCache.computeIfAbsent(pkg, aPackage -> {
            PluginLoader loader = new PluginLoader((Package)aPackage);
            return loader.load();
        });
    }

    DynamicTest connectorRstTest(File outputFile, Plugin.Configurable configurable, String templateName, boolean writeExamples) {
        return DynamicTest.dynamicTest((String)configurable.getCls().getSimpleName(), () -> this.write(outputFile, configurable, templateName));
    }

    private void write(File outputFile, Object input, String templateName) throws IOException, TemplateException {
        Template template = configuration.getTemplate(templateName);
        log.info("Writing {}", (Object)outputFile);
        try (BufferedWriter writer = Files.newWriter((File)outputFile, (Charset)Charsets.UTF_8);){
            this.process(writer, template, input);
        }
    }

    @TestFactory
    public Stream<DynamicTest> rstSources() {
        String templateName = "rst/source.rst.ftl";
        return this.plugin.getSourceConnectors().stream().map(sc -> this.connectorRstTest(new File(this.sourcesDirectory, sc.getCls().getSimpleName() + ".rst"), (Plugin.Configurable)sc, "rst/source.rst.ftl", true));
    }

    @TestFactory
    public Stream<DynamicTest> rstSinks() {
        String templateName = "rst/sink.rst.ftl";
        return this.plugin.getSinkConnectors().stream().map(sc -> this.connectorRstTest(this.outputRST(this.sinksDirectory, sc.getCls()), (Plugin.Configurable)sc, "rst/sink.rst.ftl", true));
    }

    void process(Writer writer, Template template, Object input) throws IOException, TemplateException {
        ImmutableMap variables = ImmutableMap.of((Object)"input", (Object)input);
        template.process((Object)variables, writer);
    }

    void assertConfig(Class<? extends Connector> connectorClass, Map<String, String> config) throws IllegalAccessException, InstantiationException {
        log.info("Creating instance of {}", (Object)connectorClass.getName());
        Connector connector = connectorClass.newInstance();
        ConfigDef configDef = connector.config();
        Assertions.assertNotNull((Object)configDef, (String)"connector.config() should always return a config.");
        int errorCount = 0;
        List values = configDef.validate(config);
        for (ConfigValue value : values) {
            errorCount += value.errorMessages().size();
        }
        Assertions.assertEquals((int)0, (int)errorCount, () -> {
            StringBuilder builder = new StringBuilder();
            builder.append("Example validation was not successful.");
            builder.append('\n');
            for (ConfigValue value : values) {
                for (String s : value.errorMessages()) {
                    builder.append(value.name());
                    builder.append(": ");
                    builder.append(s);
                    builder.append('\n');
                }
            }
            return builder.toString();
        });
    }

    @TestFactory
    public Stream<DynamicTest> validateSinkConnectorExamples() {
        Map<File, Plugin.SinkConnector> sinkConnectorExamples = this.examples(this.plugin.getSinkConnectors());
        return sinkConnectorExamples.entrySet().stream().map(e -> DynamicTest.dynamicTest((String)String.format("%s/%s", ((Plugin.SinkConnector)e.getValue()).getCls().getSimpleName(), ((File)e.getKey()).getName()), () -> {
            Plugin.SinkConnectorExample example = this.loadExample((Map.Entry<File, ?>)e, (Class)Plugin.SinkConnectorExample.class);
            Plugin.SinkConnector sinkConnector = (Plugin.SinkConnector)e.getValue();
            File rstOutputFile = this.outputRST(this.sinksExamplesDirectory, sinkConnector.getCls(), (File)e.getKey());
            this.assertConfig(sinkConnector.getCls(), example.getConfig());
            ImmutableSinkConnectorExampleInput.Builder builder = ImmutableSinkConnectorExampleInput.builder();
            builder.example(example);
            String config = this.connectorConfig(sinkConnector, example);
            builder.config(config);
            if (null != example.getInput()) {
                builder.inputJson(this.writeValueAsIndentedString(example.getInput()));
            }
            if (null != example.getOutput()) {
                builder.outputJson(this.writeValueAsIndentedString(example.getOutput()));
            }
            this.write(rstOutputFile, builder.build(), "rst/sinkConnectorExample.rst.ftl");
        }));
    }

    private String writeValueAsIndentedString(Object o) throws JsonProcessingException {
        String result = ObjectMapperFactory.INSTANCE.writeValueAsString(o);
        return result.replaceAll("(?m)^", "    ");
    }

    private String connectorConfig(Plugin.Connector connector, Plugin.ConnectorExample example) throws JsonProcessingException {
        ObjectNode config = ObjectMapperFactory.INSTANCE.createObjectNode();
        config.put("connector.class", connector.getCls().getName());
        if (connector instanceof Plugin.SinkConnector) {
            config.put("topic", "<required setting>");
        }
        for (Map.Entry<String, String> entry : example.getConfig().entrySet()) {
            config.put(entry.getKey(), entry.getValue());
        }
        if (null != example.transformations() && !example.transformations().isEmpty()) {
            config.put("transforms", Joiner.on((char)',').join(example.transformations().keySet()));
            for (Map.Entry<String, Object> entry : example.transformations().entrySet()) {
                Assertions.assertTrue((boolean)((Map)entry.getValue()).containsKey("type"), (String)String.format("Transform '%s' does not have a type property.", entry.getKey()));
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    String key = String.format("transforms.%s.%s", entry.getKey(), entry2.getKey());
                    config.put(key, (String)entry2.getValue());
                }
            }
        }
        return this.writeValueAsIndentedString(config);
    }

    @TestFactory
    public Stream<DynamicTest> validateSourceConnectorExamples() {
        Map<File, Plugin.SourceConnector> sourceConnectorExamples = this.examples(this.plugin.getSourceConnectors());
        return sourceConnectorExamples.entrySet().stream().map(e -> DynamicTest.dynamicTest((String)String.format("%s/%s", ((Plugin.SourceConnector)e.getValue()).getCls().getSimpleName(), ((File)e.getKey()).getName()), () -> {
            Plugin.SourceConnectorExample example = this.loadExample((Map.Entry<File, ?>)e, (Class)Plugin.SourceConnectorExample.class);
            Plugin.SourceConnector sourceConnector = (Plugin.SourceConnector)e.getValue();
            File rstOutputFile = this.outputRST(this.sourcesExamplesDirectory, sourceConnector.getCls(), (File)e.getKey());
            this.assertConfig(sourceConnector.getCls(), example.getConfig());
            ImmutableSourceConnectorExampleInput.Builder builder = ImmutableSourceConnectorExampleInput.builder();
            builder.example(example);
            String config = this.connectorConfig(sourceConnector, example);
            builder.config(config);
            if (null != example.getOutput()) {
                builder.outputJson(this.writeValueAsIndentedString(example.getOutput()));
            }
            this.write(rstOutputFile, builder.build(), "rst/sourceConnectorExample.rst.ftl");
        }));
    }

    <T extends Plugin.Configurable> Map<File, T> examples(List<T> input) {
        LinkedHashMap<File, Plugin.Configurable> result = new LinkedHashMap<File, Plugin.Configurable>();
        for (Plugin.Configurable configurable : input) {
            for (String example : configurable.getExamples()) {
                result.put(new File(example), configurable);
            }
        }
        return result;
    }

    @TestFactory
    public Stream<DynamicTest> validateTransformationExamples() {
        Map<File, Plugin.Transformation> transformationExamples = this.examples(this.plugin.getTransformations());
        return transformationExamples.entrySet().stream().map(e -> DynamicTest.dynamicTest((String)String.format("%s/%s", ((Plugin.Transformation)e.getValue()).getCls().getSimpleName(), ((File)e.getKey()).getName()), () -> {
            Class transformationClass;
            Plugin.Transformation transformation = (Plugin.Transformation)e.getValue();
            File rstOutputFile = this.outputRST(this.transformationsExampleDirectory, transformation.getCls(), (File)e.getKey());
            Plugin.TransformationExample example = this.loadExample((Map.Entry<File, ?>)e, (Class)Plugin.TransformationExample.class);
            if (Strings.isNullOrEmpty((String)example.getChildClass())) {
                transformationClass = transformation.getCls();
            } else {
                Optional<Class> childClass = Arrays.stream(transformation.getCls().getClasses()).filter(c -> example.getChildClass().equals(c.getSimpleName())).findFirst();
                Assertions.assertTrue((boolean)childClass.isPresent(), (String)String.format("Could not find child '%s' of class '%s'", example.getChildClass(), transformation.getCls().getName()));
                transformationClass = childClass.get();
            }
            Transformation transform = (Transformation)transformationClass.newInstance();
            transform.configure(example.getConfig());
            ImmutableTransformationExampleInput.Builder builder = ImmutableTransformationExampleInput.builder();
            builder.example(example);
            if (null != example.getConfig() && !example.getConfig().isEmpty()) {
                String transformKey = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, transformation.getCls().getSimpleName());
                String transformPrefix = "transforms." + transformKey + ".";
                LinkedHashMap<String, String> config = new LinkedHashMap<String, String>();
                config.put("transforms", transformKey);
                config.put(transformPrefix + "type", transformationClass.getName());
                for (Map.Entry<String, String> a : example.getConfig().entrySet()) {
                    config.put(transformPrefix + a.getKey(), a.getValue());
                }
                String configJson = this.writeValueAsIndentedString(config);
                builder.config(configJson);
            }
            if (null != example.getInput()) {
                String inputJson = this.writeValueAsIndentedString(example.getInput());
                builder.inputJson(inputJson);
                SinkRecord output = (SinkRecord)transform.apply((ConnectRecord)example.getInput());
                if (null != output) {
                    String outputJson = this.writeValueAsIndentedString(output);
                    builder.outputJson(outputJson);
                    List<String> inputLines = Arrays.asList(inputJson.split("\\r?\\n"));
                    List<String> outputLines = Arrays.asList(outputJson.split("\\r?\\n"));
                    Patch patch = DiffUtils.diff(inputLines, outputLines);
                    for (AbstractDelta delta : patch.getDeltas()) {
                        log.trace("delta: start={} end={}", (Object)delta.getTarget().getPosition(), (Object)delta.getTarget().last());
                        int lineStart = delta.getTarget().getPosition() + 1;
                        int lineEnd = lineStart + delta.getTarget().size() - 1;
                        for (int i = lineStart; i <= lineEnd; ++i) {
                            builder.addOutputEmphasizeLines(i);
                        }
                    }
                }
            }
            try (BufferedWriter writer = Files.newWriter((File)rstOutputFile, (Charset)Charsets.UTF_8);){
                Template template = configuration.getTemplate("rst/transformationExample.rst.ftl");
                this.process(writer, template, builder.build());
            }
        }));
    }

    private <T> T loadExample(Map.Entry<File, ?> e, Class<T> cls) throws IOException {
        log.info("loadExample() - file = '{}'", (Object)e.getKey().getAbsolutePath());
        try (InputStream inputStream = this.getClass().getResourceAsStream(e.getKey().getAbsolutePath());){
            Object object = ObjectMapperFactory.INSTANCE.readValue(inputStream, cls);
            return (T)object;
        }
    }

    private File outputRST(File parentDirectory, Class<?> cls) {
        return new File(parentDirectory, cls.getSimpleName() + ".rst");
    }

    private File outputRST(File parentDirectory, Class<?> cls, File exampleFile) {
        return new File(parentDirectory, String.format("%s.%s.rst", cls.getSimpleName(), Files.getNameWithoutExtension((String)exampleFile.getName())));
    }

    @TestFactory
    public Stream<DynamicTest> rstTransformations() throws IOException, TemplateException {
        String templateName = "rst/transformation.rst.ftl";
        return this.plugin.getTransformations().stream().map(sc -> this.connectorRstTest(this.outputRST(this.transformationsDirectory, sc.getCls()), (Plugin.Configurable)sc, "rst/transformation.rst.ftl", true));
    }

    Plugin.SchemaInput buildSchemaInput(Schema schema) {
        return this.buildSchemaInput(schema, null);
    }

    Plugin.SchemaInput buildSchemaInput(Schema schema, String fieldName) {
        ImmutableSchemaInput.Builder schemaInput = ImmutableSchemaInput.builder().name(schema.name()).doc(schema.doc()).type(schema.type()).fieldName(fieldName).isOptional(schema.isOptional());
        if (Schema.Type.STRUCT == schema.type()) {
            for (Field field : schema.fields()) {
                Plugin.SchemaInput fieldSchema = this.buildSchemaInput(field.schema(), field.name());
                schemaInput.addFields(fieldSchema);
            }
        } else if (Schema.Type.MAP == schema.type()) {
            schemaInput.key(this.buildSchemaInput(schema.keySchema()));
            schemaInput.value(this.buildSchemaInput(schema.valueSchema()));
        } else if (Schema.Type.ARRAY == schema.type()) {
            schemaInput.value(this.buildSchemaInput(schema.valueSchema()));
        }
        return schemaInput.build();
    }

    void findAllSchemas(Set<Schema> schemas, Schema schema) {
        schemas.add(schema);
        if (Schema.Type.STRUCT == schema.type()) {
            for (Field field : schema.fields()) {
                this.findAllSchemas(schemas, field.schema());
            }
        } else if (Schema.Type.MAP == schema.type()) {
            this.findAllSchemas(schemas, schema.keySchema());
            this.findAllSchemas(schemas, schema.valueSchema());
        } else if (Schema.Type.ARRAY == schema.type()) {
            this.findAllSchemas(schemas, schema.valueSchema());
        }
    }

    @TestFactory
    public Stream<DynamicTest> rstSchemas() throws IOException, TemplateException {
        File parentDirectory = new File(this.outputDirectory, "schemas");
        List<Schema> schemas = this.schemas();
        LinkedHashSet<Schema> allSchemas = new LinkedHashSet<Schema>();
        for (Schema s : schemas) {
            this.findAllSchemas(allSchemas, s);
        }
        if (!schemas.isEmpty()) {
            if (!parentDirectory.exists()) {
                parentDirectory.mkdirs();
            }
            File outputFile = new File(this.outputDirectory, "schemas.rst");
            String templateName = "rst/schemas.rst.ftl";
            Template template = configuration.getTemplate("rst/schemas.rst.ftl");
            try (BufferedWriter writer = Files.newWriter((File)outputFile, (Charset)Charsets.UTF_8);){
                this.process(writer, template, this.plugin);
            }
        }
        String templateName = "rst/schema.rst.ftl";
        return allSchemas.stream().filter(schema -> !Strings.isNullOrEmpty((String)schema.name())).map(schema -> DynamicTest.dynamicTest((String)String.format("%s.%s", schema.type(), schema.name()), () -> {
            Plugin.SchemaInput schemaInput = this.buildSchemaInput((Schema)schema);
            StringBuilder filenameBuilder = new StringBuilder().append(schema.type().toString().toLowerCase());
            if (!Strings.isNullOrEmpty((String)schema.name())) {
                filenameBuilder.append('.').append(schema.name());
            }
            filenameBuilder.append(".rst");
            File outputFile = new File(parentDirectory, filenameBuilder.toString());
            Template template = configuration.getTemplate("rst/schema.rst.ftl");
            log.info("Writing {}", (Object)outputFile);
            try (BufferedWriter writer = Files.newWriter((File)outputFile, (Charset)Charsets.UTF_8);){
                ImmutableMap variables = ImmutableMap.of((Object)"input", (Object)schemaInput);
                template.process((Object)variables, (Writer)writer);
            }
        }));
    }

    @Test
    public void rstIndex() throws IOException, TemplateException {
        File outputFile = new File(this.outputDirectory, "index.rst");
        String templateName = "rst/index.rst.ftl";
        Template template = configuration.getTemplate("rst/index.rst.ftl");
        try (BufferedWriter writer = Files.newWriter((File)outputFile, (Charset)Charsets.UTF_8);){
            this.process(writer, template, this.plugin);
        }
    }

    @Test
    public void readmeMD() throws IOException, TemplateException {
        File outputFile = new File("target", "README.md");
        Template template = configuration.getTemplate("md/README.md.ftl");
        try (BufferedWriter writer = Files.newWriter((File)outputFile, (Charset)Charsets.UTF_8);){
            this.process(writer, template, this.plugin);
        }
    }

    static {
        pluginCache = new HashMap<Package, Plugin>();
    }
}

