/*
 * Decompiled with CFR 0.152.
 */
package com.github.jcustenborder.kafka.connect.utils.templates;

import com.github.jcustenborder.kafka.connect.utils.templates.Notes;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Notes.Copy", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableCopy
implements Notes.Copy {
    @Nullable
    private final String warning;
    @Nullable
    private final String tip;
    @Nullable
    private final String important;
    @Nullable
    private final String danger;
    @Nullable
    private final String note;
    @Nullable
    private final String title;
    @Nullable
    private final String description;
    @Nullable
    private final String icon;
    @Nullable
    private final String introduction;

    private ImmutableCopy(@Nullable String warning, @Nullable String tip, @Nullable String important, @Nullable String danger, @Nullable String note, @Nullable String title, @Nullable String description, @Nullable String icon, @Nullable String introduction) {
        this.warning = warning;
        this.tip = tip;
        this.important = important;
        this.danger = danger;
        this.note = note;
        this.title = title;
        this.description = description;
        this.icon = icon;
        this.introduction = introduction;
    }

    @Override
    @Nullable
    public String getWarning() {
        return this.warning;
    }

    @Override
    @Nullable
    public String getTip() {
        return this.tip;
    }

    @Override
    @Nullable
    public String getImportant() {
        return this.important;
    }

    @Override
    @Nullable
    public String getDanger() {
        return this.danger;
    }

    @Override
    @Nullable
    public String getNote() {
        return this.note;
    }

    @Override
    @Nullable
    public String getTitle() {
        return this.title;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public String getIcon() {
        return this.icon;
    }

    @Override
    @Nullable
    public String getIntroduction() {
        return this.introduction;
    }

    public final ImmutableCopy withWarning(@Nullable String value) {
        if (Objects.equals(this.warning, value)) {
            return this;
        }
        return new ImmutableCopy(value, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction);
    }

    public final ImmutableCopy withTip(@Nullable String value) {
        if (Objects.equals(this.tip, value)) {
            return this;
        }
        return new ImmutableCopy(this.warning, value, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction);
    }

    public final ImmutableCopy withImportant(@Nullable String value) {
        if (Objects.equals(this.important, value)) {
            return this;
        }
        return new ImmutableCopy(this.warning, this.tip, value, this.danger, this.note, this.title, this.description, this.icon, this.introduction);
    }

    public final ImmutableCopy withDanger(@Nullable String value) {
        if (Objects.equals(this.danger, value)) {
            return this;
        }
        return new ImmutableCopy(this.warning, this.tip, this.important, value, this.note, this.title, this.description, this.icon, this.introduction);
    }

    public final ImmutableCopy withNote(@Nullable String value) {
        if (Objects.equals(this.note, value)) {
            return this;
        }
        return new ImmutableCopy(this.warning, this.tip, this.important, this.danger, value, this.title, this.description, this.icon, this.introduction);
    }

    public final ImmutableCopy withTitle(@Nullable String value) {
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutableCopy(this.warning, this.tip, this.important, this.danger, this.note, value, this.description, this.icon, this.introduction);
    }

    public final ImmutableCopy withDescription(@Nullable String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableCopy(this.warning, this.tip, this.important, this.danger, this.note, this.title, value, this.icon, this.introduction);
    }

    public final ImmutableCopy withIcon(@Nullable String value) {
        if (Objects.equals(this.icon, value)) {
            return this;
        }
        return new ImmutableCopy(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, value, this.introduction);
    }

    public final ImmutableCopy withIntroduction(@Nullable String value) {
        if (Objects.equals(this.introduction, value)) {
            return this;
        }
        return new ImmutableCopy(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCopy && this.equalTo((ImmutableCopy)another);
    }

    private boolean equalTo(ImmutableCopy another) {
        return Objects.equals(this.warning, another.warning) && Objects.equals(this.tip, another.tip) && Objects.equals(this.important, another.important) && Objects.equals(this.danger, another.danger) && Objects.equals(this.note, another.note) && Objects.equals(this.title, another.title) && Objects.equals(this.description, another.description) && Objects.equals(this.icon, another.icon) && Objects.equals(this.introduction, another.introduction);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.warning);
        h += (h << 5) + Objects.hashCode(this.tip);
        h += (h << 5) + Objects.hashCode(this.important);
        h += (h << 5) + Objects.hashCode(this.danger);
        h += (h << 5) + Objects.hashCode(this.note);
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.icon);
        h += (h << 5) + Objects.hashCode(this.introduction);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Copy").omitNullValues().add("warning", (Object)this.warning).add("tip", (Object)this.tip).add("important", (Object)this.important).add("danger", (Object)this.danger).add("note", (Object)this.note).add("title", (Object)this.title).add("description", (Object)this.description).add("icon", (Object)this.icon).add("introduction", (Object)this.introduction).toString();
    }

    public static ImmutableCopy copyOf(Notes.Copy instance) {
        if (instance instanceof ImmutableCopy) {
            return (ImmutableCopy)instance;
        }
        return ImmutableCopy.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Notes.Copy", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String warning;
        @Nullable
        private String tip;
        @Nullable
        private String important;
        @Nullable
        private String danger;
        @Nullable
        private String note;
        @Nullable
        private String title;
        @Nullable
        private String description;
        @Nullable
        private String icon;
        @Nullable
        private String introduction;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Notes instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Notes.Copy instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof Notes) {
                String introductionValue;
                String titleValue;
                String dangerValue;
                String tipValue;
                String descriptionValue;
                String warningValue;
                String iconValue;
                String noteValue;
                Notes instance = (Notes)object;
                String importantValue = instance.getImportant();
                if (importantValue != null) {
                    this.important(importantValue);
                }
                if ((noteValue = instance.getNote()) != null) {
                    this.note(noteValue);
                }
                if ((iconValue = instance.getIcon()) != null) {
                    this.icon(iconValue);
                }
                if ((warningValue = instance.getWarning()) != null) {
                    this.warning(warningValue);
                }
                if ((descriptionValue = instance.getDescription()) != null) {
                    this.description(descriptionValue);
                }
                if ((tipValue = instance.getTip()) != null) {
                    this.tip(tipValue);
                }
                if ((dangerValue = instance.getDanger()) != null) {
                    this.danger(dangerValue);
                }
                if ((titleValue = instance.getTitle()) != null) {
                    this.title(titleValue);
                }
                if ((introductionValue = instance.getIntroduction()) != null) {
                    this.introduction(introductionValue);
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder warning(@Nullable String warning) {
            this.warning = warning;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tip(@Nullable String tip) {
            this.tip = tip;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder important(@Nullable String important) {
            this.important = important;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder danger(@Nullable String danger) {
            this.danger = danger;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder note(@Nullable String note) {
            this.note = note;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder title(@Nullable String title) {
            this.title = title;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder icon(@Nullable String icon) {
            this.icon = icon;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder introduction(@Nullable String introduction) {
            this.introduction = introduction;
            return this;
        }

        public ImmutableCopy build() {
            return new ImmutableCopy(this.warning, this.tip, this.important, this.danger, this.note, this.title, this.description, this.icon, this.introduction);
        }
    }
}

